<?php
require '../../main.inc.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/pdf.lib.php';
require_once DOL_DOCUMENT_ROOT . '/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/company.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/date.lib.php';

$langs->loadLangs(['scrap@scrap', 'main', 'products']);

$startDate = GETPOST('start_date', 'alpha');
$endDate   = GETPOST('end_date', 'alpha');

if (empty($startDate) || empty($endDate)) accessforbidden('Missing date range');

$logoBlue = [0, 117, 169]; // NEOS blue

// --- SQL ---
$sql = "SELECT 
            s.rowid,
            p.ref AS product_ref,
            e.ref AS warehouse,
            s.qty,
            s.cost,
            s.reason,
            s.scrap_date,
            u.firstname,
            u.lastname
        FROM " . MAIN_DB_PREFIX . "scrap s
        LEFT JOIN " . MAIN_DB_PREFIX . "product p ON s.fk_product = p.rowid
        LEFT JOIN " . MAIN_DB_PREFIX . "entrepot e ON s.fk_warehouse = e.rowid
        LEFT JOIN " . MAIN_DB_PREFIX . "user u ON s.fk_user_scrap = u.rowid
        WHERE s.entity = " . (int) $conf->entity . "
        AND s.scrap_date BETWEEN '" . $db->escape($startDate) . " 00:00:00'
                            AND '" . $db->escape($endDate) . " 23:59:59'
        ORDER BY s.scrap_date ASC";

$resql = $db->query($sql);
$scrapData = [];
if ($resql) while ($obj = $db->fetch_object($resql)) $scrapData[] = $obj;

// --- PDF setup ---
$pdf = pdf_getInstance($langs->defaultlang);
$pdf->SetTitle('Scrap Report');
$pdf->SetMargins(15, 15, 15);
$pdf->AddPage();
$default_font_size = pdf_getPDFFontSize($langs);
$pdf->SetFont(pdf_getPDFFont($langs), '', $default_font_size);

/* ----------------------------------------------------------------
   HEADER
---------------------------------------------------------------- */
$headerTopY = 14; $headerHeight = 25; $headerLogoMaxWidth = 80;
$logoPath = $conf->mycompany->dir_output . '/logos/' . $mysoc->logo;

if (is_readable($logoPath)) {
    list($ow, $oh) = getimagesize($logoPath);
    $ratio = $ow / $oh; $logoHeight = $headerHeight; $logoWidth = $logoHeight * $ratio;
    if ($logoWidth > $headerLogoMaxWidth) { $logoWidth = $headerLogoMaxWidth; $logoHeight = $logoWidth / $ratio; }
    $logoY = $headerTopY + (($headerHeight - $logoHeight) / 2);
    $pdf->Image($logoPath, 15, $logoY, $logoWidth, $logoHeight);
}

$pdf->SetFont('', 'B', 12);
$pdf->SetXY(120, $headerTopY);
$pdf->Cell(80, 6, $langs->trans("General Scrap Record"), 0, 1, 'R');
$pdf->SetFont('', '', 9);
$pdf->SetXY(120, $headerTopY + 7);
$pdf->Cell(80, 5, 'Report Date Range: ' . $startDate . ' → ' . $endDate, 0, 1, 'R');
$pdf->SetXY(120, $headerTopY + 12);
$pdf->Cell(80, 5, 'Generated: ' . dol_print_date(dol_now(), '%d/%m/%Y %H:%M'), 0, 1, 'R');

/* ----------------------------------------------------------------
   COMPANY INFO BOX
---------------------------------------------------------------- */
$companyBoxY = $headerTopY + $headerHeight + 5;
$pdf->SetXY(15, $companyBoxY);
$pdf->SetFont('', '', 9);
$pdf->SetFillColor(240, 240, 240);
$pdf->MultiCell(80, 5,
    $mysoc->name . "\n" .
    $mysoc->address . "\n" .
    $mysoc->zip . ' ' . $mysoc->town . "\n" .
    $mysoc->country . "\n" .
    $mysoc->email . "\n" .
    $mysoc->url,
    0, 'L', 1
);

/* ----------------------------------------------------------------
   MONTHLY SUMMARY (centered & 12 months + total)
---------------------------------------------------------------- */
$afterCompany = $companyBoxY + 35;
$colWidthsSummary = [60, 60, 60];
$tableWidthSummary = array_sum($colWidthsSummary);
$pageWidth = $pdf->getPageWidth();
$centerX = ($pageWidth - $tableWidthSummary) / 2;

$pdf->SetFont('', 'B', 10);
$pdf->SetFillColor($logoBlue[0], $logoBlue[1], $logoBlue[2]);
$pdf->SetTextColor(255, 255, 255);
$pdf->SetXY($centerX, $afterCompany);
$pdf->Cell($tableWidthSummary, 8, $langs->trans('Monthly Summary'), 0, 1, 'C', 1);

$pdf->SetFont('', 'B', 9);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetXY($centerX, $afterCompany + 8);
$pdf->Cell($colWidthsSummary[0], 7, $langs->trans('Month'), 1, 0, 'C');
$pdf->Cell($colWidthsSummary[1], 7, $langs->trans('Total Qty'), 1, 0, 'C');
$pdf->Cell($colWidthsSummary[2], 7, $langs->trans('Total Cost'), 1, 1, 'C');

$pdf->SetFont('', '', 9);
$pdf->SetLineWidth(0.2);
$monthlyData = [];
foreach ($scrapData as $row) {
    $monthKey = dol_print_date(dol_stringtotime($row->scrap_date), '%m');
    if (!isset($monthlyData[$monthKey])) $monthlyData[$monthKey] = ['qty' => 0, 'cost' => 0];
    $monthlyData[$monthKey]['qty']  += $row->qty;
    $monthlyData[$monthKey]['cost'] += ($row->qty * $row->cost);
}

$months = ['01'=>'Jan','02'=>'Feb','03'=>'Mar','04'=>'Apr','05'=>'May','06'=>'Jun','07'=>'Jul','08'=>'Aug','09'=>'Sep','10'=>'Oct','11'=>'Nov','12'=>'Dec'];
$y = $pdf->GetY(); $totalQty = 0; $totalCost = 0;
foreach ($months as $num=>$name) {
    $qty  = $monthlyData[$num]['qty'] ?? 0;
    $cost = $monthlyData[$num]['cost'] ?? 0;
    $pdf->SetXY($centerX, $y);
    $pdf->Cell($colWidthsSummary[0],7,$name,1,0,'C');
    $pdf->Cell($colWidthsSummary[1],7,number_format($qty,2),1,0,'R');
    $pdf->Cell($colWidthsSummary[2],7,price($cost),1,1,'R');
    $y+=7; $totalQty+=$qty; $totalCost+=$cost;
}
$pdf->SetFont('', 'B', 9);
$pdf->SetFillColor(220,220,220);
$pdf->SetXY($centerX,$y);
$pdf->Cell($colWidthsSummary[0],7,$langs->trans('Total'),1,0,'C',1);
$pdf->Cell($colWidthsSummary[1],7,number_format($totalQty,2),1,0,'R',1);
$pdf->Cell($colWidthsSummary[2],7,price($totalCost),1,1,'R',1);
$y+=10;

/* ----------------------------------------------------------------
   DETAILED SCRAP LIST (centered, right-aligned money)
---------------------------------------------------------------- */
$pdf->SetFont('', 'B', 10);
$pdf->SetFillColor($logoBlue[0],$logoBlue[1],$logoBlue[2]);
$pdf->SetTextColor(255,255,255);

$colWidths = [30,25,20,25,25,40,25,15];
$tableWidth = array_sum($colWidths);
$centerX = ($pdf->getPageWidth() - $tableWidth)/2;

$pdf->SetXY($centerX,$y);
$pdf->Cell($tableWidth,8,$langs->trans('Detailed Scrap List'),0,1,'C',1);

$pdf->SetFont('', 'B', 9);
$pdf->SetTextColor(0,0,0);
$pdf->SetXY($centerX,$y+8);
$headers = ['FG / PACK','Warehouse','Qty','Unit Cost','Total Cost','Reason','Date','User'];
foreach ($headers as $i=>$title) $pdf->Cell($colWidths[$i],7,$langs->trans($title),1,0,'C');
$pdf->Ln();

$pdf->SetFont('', '', 9);
$pdf->SetLineWidth(0.2);
$y = $pdf->GetY();
$totalListQty = 0; $totalListCost = 0;

foreach ($scrapData as $row) {
    $initials = strtoupper(substr($row->firstname,0,1).substr($row->lastname,0,1));
    $totalCostRow = $row->qty * $row->cost;
    $pdf->SetXY($centerX,$y);
    $pdf->Cell($colWidths[0],7,$row->product_ref,1,0,'C');
    $pdf->Cell($colWidths[1],7,$row->warehouse,1,0,'C');
    $pdf->Cell($colWidths[2],7,number_format($row->qty,2),1,0,'R');
    $pdf->Cell($colWidths[3],7,price($row->cost),1,0,'R');
    $pdf->Cell($colWidths[4],7,price($totalCostRow),1,0,'R');
    $pdf->Cell($colWidths[5],7,$row->reason,1,0,'C');
    $pdf->Cell($colWidths[6],7,dol_print_date(dol_stringtotime($row->scrap_date),'%d/%m/%Y'),1,0,'C');
    $pdf->Cell($colWidths[7],7,$initials,1,1,'C');
    $y+=7; $totalListQty+=$row->qty; $totalListCost+=$totalCostRow;
}

// Totals
$pdf->SetFont('', 'B', 9);
$pdf->SetFillColor(220,220,220);
$pdf->SetXY($centerX,$y);
$pdf->Cell($colWidths[0]+$colWidths[1],7,$langs->trans('Total'),1,0,'C',1);
$pdf->Cell($colWidths[2],7,number_format($totalListQty,2),1,0,'R',1);
$pdf->Cell($colWidths[3],7,'',1,0,'C',1);
$pdf->Cell($colWidths[4],7,price($totalListCost),1,0,'R',1);
$pdf->Cell($colWidths[5]+$colWidths[6]+$colWidths[7],7,'',1,1,'C',1);

$pdf->Output('scrap_report_'.$startDate.'_'.$endDate.'.pdf','I');
exit;
?>
