// Ogólny JS modułu – autocomplete, +Add step, itd.
// WYMAGA: window.PR_CONFIG zdefiniowanego w productionrules_rules.php
// (Sales Order rules also reuses this file, so make it resilient)
window.PR_CONFIG = window.PR_CONFIG || { urls: {} };

$(function() {

            function attachProductAutocomplete(fieldId) {
        var $el = $("#" + fieldId);

	        // This JS file is shared by multiple pages. If a page doesn't expose
	        // the autocomplete endpoints, don't break the rest of the UI.
	        if (!window.PR_CONFIG || !window.PR_CONFIG.urls || !window.PR_CONFIG.urls.getProducts) {
	            return;
	        }

        $el.autocomplete({
            source: function (request, response) {
                var full = request.term || '';
                $el.data('pr_full_term', full);

                var parts = full.split(',');
                var last = parts[parts.length - 1].trim();

                // For material packs: wait until user types at least 1 digit, and allow only digits
                if (fieldId === 'bom_raw_ref' || fieldId === 'so_material_packs') {
                    if (last.length === 0) {
                        response([]);
                        return;
                    }
                    if (!/^\d+$/.test(last)) {
                        response([]);
                        return;
                    }
                }

                $.ajax({
                    url: PR_CONFIG.urls.getProducts,
                    data: {
                        action: 'search',
                        term: last,
                        field: fieldId
                    },
	                    dataType: "json",
	                    success: function (data) {
                        // Filter out SF/FG etc. for material packs field - keep only numeric refs
                        if ((fieldId === 'bom_raw_ref' || fieldId === 'so_material_packs') && Array.isArray(data)) {
                            data = data.filter(function (item) {
                                var v = '';
                                if (typeof item === 'string') v = item;
                                else v = (item.value || item.label || '');
                                var first = String(v).trim().split(/[\s-]/)[0];
                                return /^\d+$/.test(first);
                            });
                        }
                        response(data);
	                    },
	                    error: function () {
	                        // Always resolve the autocomplete response to stop the loading indicator
	                        response([]);
	                    }
                });
            },

            // IMPORTANT: prevent keyboard navigation from overwriting the whole input
            focus: function (event, ui) {
                if (fieldId === 'bom_raw_ref' || fieldId === 'so_material_packs') {
                    event.preventDefault();
                    return false;
                }
            },

            minLength: 1,
            delay: 150,

            select: function (event, ui) {
                if (fieldId === 'bom_raw_ref' || fieldId === 'so_material_packs') {
                    event.preventDefault();

                    var v = '';
                    if (ui && ui.item) {
                        v = (ui.item.value || ui.item.label || ui.item) || '';
                    }
                    var first = String(v).trim().split(/[\s-]/)[0];

                    // Use the saved full term (before jQuery UI touched the value)
                    var full = $el.data('pr_full_term') || this.value || '';
                    var current = full.split(',');
                    current[current.length - 1] = ' ' + first;

                    this.value = current.join(',').replace(/^\s+/, '');
                    return false;
                }
            }
        });
    }


    function attachOperationAutocomplete(fieldId) {
	    if (!window.PR_CONFIG || !window.PR_CONFIG.urls || !window.PR_CONFIG.urls.getOperations) {
	        return;
	    }
        $("#" + fieldId).autocomplete({
            source: function(request, response) {
                $.ajax({
                    url: PR_CONFIG.urls.getOperations,
                    data: { term: request.term },
                    dataType: "json",
                    success: function(data){
                        response(data);
                    }
                });
            },
            minLength: 1,
            delay: 100
        });
    }

    function attachWorkstationAutocomplete(fieldId) {
	    if (!window.PR_CONFIG || !window.PR_CONFIG.urls || !window.PR_CONFIG.urls.getWorkstations) {
	        return;
	    }
        $("#" + fieldId).autocomplete({
            source: function(request, response) {
                $.ajax({
                    url: PR_CONFIG.urls.getWorkstations,
                    data: { term: request.term },
                    dataType: "json",
                    success: function(data){
                        response(data);
                    }
                });
            },
            minLength: 1,
            delay: 100
        });
    }

    // Inicjalizacja autocomplete
    attachProductAutocomplete("from_ref");
    attachProductAutocomplete("to_ref");
    attachProductAutocomplete("fg_ref");
    attachProductAutocomplete("new_ruleset_ref");
    attachProductAutocomplete("bom_raw_ref");
    // Sales Order rules page fields
    attachProductAutocomplete("so_new_ruleset_ref");
    attachProductAutocomplete("so_sell_ref");
    attachProductAutocomplete("so_comp_ref");
    attachProductAutocomplete("so_material_packs");
    
    attachOperationAutocomplete("operation");
    attachWorkstationAutocomplete("workstation");

    // ADMIN ONLY: +Add step order
    if (PR_CONFIG.isAdmin) {
        $("#addStepLink").click(function(e) {
            e.preventDefault();

            //var current = parseInt($("select[name='step_order_new']").val(), 10) || PR_CONFIG.maxStepOrder;
            var current = PR_CONFIG.maxStepOrder;
            var suggested = current + 10;

            var val = window.prompt(
                "Add new step order value (integer).\n" +
                "Current max: " + PR_CONFIG.maxStepOrder + "\n" +
                "Suggestion: " + suggested,
                suggested
            );

            if (val === null) return; // cancelled

            val = parseInt(val, 10);
            if (isNaN(val) || val <= 0) {
                alert("Invalid value");
                return;
            }

            $.ajax({
                url: PR_CONFIG.urls.addStepOrder,
                method: "POST",
                dataType: "json",
                data: {
                    value: val
                }
            }).done(function(resp) {
                if (!resp || !resp.success) {
                    alert("Ajax error: " + (resp && resp.message ? resp.message : "unknown"));
                    return;
                }

                // Zaktualizuj globalny max
                PR_CONFIG.maxStepOrder = resp.max_steporder;

                // Dodaj nową opcję do selecta (jeśli jej nie ma)
                var $sel = $("select[name='step_order_new']");
                if ($sel.find("option[value='" + val + "']").length === 0) {
                    $sel.append('<option value="'+val+'">'+val+'</option>');
                }
                $sel.val(val);
            }).fail(function(xhr) {
                alert("Ajax error: " + xhr.statusText);
            });
        });
    }
});

// BOM Preview modal helpers
function prOpenBomPreview(){
  var el=document.getElementById('prBomPreviewModal');
  if(el){el.classList.add('open');}
}
function prCloseBomPreview(){
  var el=document.getElementById('prBomPreviewModal');
  if(el){el.classList.remove('open');}
}

// Sales Order rules: confirmation modal for Generate SO + BOM
function prOpenSoConfirm(){
  var modal=document.getElementById('prSoConfirmModal');
  var pre=document.getElementById('prSoConfirmText');
  if(!modal||!pre){ 
    // fallback: submit immediately
    var f=document.getElementById('prSoCreateForm'); if(f) f.submit();
    return;
  }
  var d=window.PR_SO_CONFIRM||{};
  // Fill confirm data from current form/selection (keep server-provided components)
  var f=document.getElementById('prSoCreateForm');
  if(f){
    var sell=f.querySelector('[name="sell_ref"]'); if(sell) d.sellRef = sell.value.trim();
    var qty=f.querySelector('[name="sell_qty"]'); if(qty) d.sellQty = parseFloat(qty.value)||0;
    var mat=f.querySelector('[name="material"]'); if(mat) d.material = mat.value.trim();
    var soc=f.querySelector('[name="socid"]'); 
    if(soc && soc.options && soc.selectedIndex>=0){
      d.customer = soc.options[soc.selectedIndex].text.trim();
    }
    var hid=f.querySelector('[name="so_ruleset_id"]'); if(hid && hid.value){
      var rs=document.querySelector('select[name="so_ruleset_id"]');
      if(rs && rs.options && rs.selectedIndex>=0) d.soRuleset = rs.options[rs.selectedIndex].text.trim();
    }
    var prs=document.querySelector('select[name="prod_ruleset_id"]');
    if(prs && prs.options && prs.selectedIndex>=0) d.prodRuleset = prs.options[prs.selectedIndex].text.trim();
  }
  var lines=[];
  lines.push('Generated by ProductionRules (Sales Order rules)');
  if(d.customer){ lines.push('Customer: '+d.customer); }
  if(d.sellRef){ lines.push('Sell: '+d.sellRef+'  Qty: '+(d.sellQty||1)); }
  if(d.soRuleset){ lines.push('Sales Order RuleSet: '+d.soRuleset); }
  if(d.prodRuleset){ lines.push('Production RuleSet: '+d.prodRuleset); }
  if(d.material){ 
    lines.push('');
    lines.push('Material packs:');
    // split by comma
    var packs=String(d.material).split(',').map(s=>s.trim()).filter(Boolean);
    if(packs.length){ packs.forEach(p=>lines.push('- '+p)); } else { lines.push('- (none)'); }
  }
  lines.push('');
  lines.push('Components:');
  var comps=d.components||[];
  if(comps && comps.length){
    comps.forEach(function(c){
      var ref=(c.comp_ref||c.compRef||'').toString().trim();
      var q=parseFloat(c.qty||c.comp_qty||c.compQty||1);
      if(!ref) return;
      if(!isFinite(q)) q=1;
      var tot=q*(parseFloat(d.sellQty||1)||1);
      var note=(c.note||c.comp_note||'');
      var l='- '+ref+' x '+q+'  (SO total: '+tot+')';
      if(note){ l += '  ('+note+')'; }
      lines.push(l);
    });
  } else {
    lines.push('- (none)');
  }
  pre.textContent=lines.join('\n');
  modal.classList.add('open');
}

function prCloseSoConfirm(){
  var modal=document.getElementById('prSoConfirmModal');
  if(modal) modal.classList.remove('open');
}

function prConfirmSoGenerate(){
  prCloseSoConfirm();
  var f=document.getElementById('prSoCreateForm');
  if(f){ f.submit(); }
}
