<?php
require '../../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/commande/class/commande.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';

dol_include_once('/productionrules/class/soruleset.class.php');
dol_include_once('/productionrules/class/ruleset.class.php');          // ProdRuleSet (production flow)
dol_include_once('/productionrules/class/productionrules.class.php');  // for BOM generation

$langs->load('productionrules@productionrules');

if (empty($user->rights->productionrules->read)) accessforbidden();

$form = new Form($db);

$action = GETPOST('action','aZ09');
$current_so_ruleset = (int) GETPOST('so_ruleset_id','int');
$ref_new = trim(GETPOST('new_so_ruleset_ref','alphanohtml'));

$comp_ref = trim(GETPOST('comp_ref','alphanohtml'));
$comp_qty = (float) GETPOST('comp_qty','int'); // keep simple int qty for now
$comp_note = trim(GETPOST('comp_note','alphanohtml'));

$customer_id = (int) GETPOST('socid','int');
$sell_ref = trim(GETPOST('sell_ref','alphanohtml'));
$sell_qty = (float) GETPOST('sell_qty','int');
$prod_ruleset_id = (int) GETPOST('prod_ruleset_id','int');
$material_packs = trim(GETPOST('material','alphanohtml'));
$job_number = trim(GETPOST('job_number','alphanohtml'));

$soObj = new ProdSoRuleSet($db);
$soRulesets = $soObj->fetchAllForUser($user);

if ($action === 'create_so_ruleset' && $ref_new !== '') {
    $newid = $soObj->create($user, $ref_new);
    if ($newid > 0) {
        $current_so_ruleset = (int) $newid;
        setEventMessages($langs->trans('RecordSaved'), null, 'mesgs');
    } else {
        setEventMessages($langs->trans('Error'), null, 'errors');
    }
    $soRulesets = $soObj->fetchAllForUser($user);
}

// Delete Sales Order RuleSet (hard delete + cascade)
if ($action === 'delete_so_ruleset' && $current_so_ruleset > 0) {
    $res = $soObj->deleteCascade($user, $current_so_ruleset);
    if ($res > 0) {
        setEventMessages($langs->trans('RecordDeleted'), null, 'mesgs');
        $current_so_ruleset = 0;
    } else {
        setEventMessages($langs->trans('Error'), null, 'errors');
    }
    $soRulesets = $soObj->fetchAllForUser($user);
}

if ($action === 'add_component' && $current_so_ruleset > 0 && $comp_ref !== '') {
    $qty = ($comp_qty > 0 ? $comp_qty : 1);
    $sqlp = "SELECT MAX(pos) as mp FROM ".MAIN_DB_PREFIX."prod_so_rules";
    // Note: getEntity() doesn't know about our custom SO tables. Use current entity id.
    $sqlp.= " WHERE fk_ruleset=".(int)$current_so_ruleset." AND entity=".(int)$conf->entity;
    $resp = $db->query($sqlp);
    $pos = 0;
    if ($resp && ($o=$db->fetch_object($resp))) $pos = (int)$o->mp + 10;

    $sql = "INSERT INTO ".MAIN_DB_PREFIX."prod_so_rules(entity,fk_ruleset,comp_ref,qty,pos,note,fk_user_creat,datec,active)";
    $sql.= " VALUES (".$conf->entity.", ".(int)$current_so_ruleset.", '".$db->escape($comp_ref)."', ".((float)$qty).", ".(int)$pos.", '".$db->escape($comp_note)."', ".(int)$user->id.", '".$db->idate(dol_now())."', 1)";
    if ($db->query($sql)) {
        setEventMessages($langs->trans('RecordSaved'), null, 'mesgs');
    } else {
        setEventMessages($db->lasterror(), null, 'errors');
    }
}

if ($action === 'delete_component' && $current_so_ruleset > 0) {
    $rid = (int) GETPOST('rid','int');
    if ($rid > 0) {
        $db->query("DELETE FROM ".MAIN_DB_PREFIX."prod_so_rules WHERE rowid=".(int)$rid." AND fk_ruleset=".(int)$current_so_ruleset." AND entity=".(int)$conf->entity);
        setEventMessages($langs->trans('RecordDeleted'), null, 'mesgs');
    }
}

function pr_get_components($db, $ruleset_id) {
    global $conf;
    $out=array();
    if ($ruleset_id<=0) return $out;
    $sql="SELECT rowid, comp_ref, qty, pos, note FROM ".MAIN_DB_PREFIX."prod_so_rules";
    // Note: getEntity() doesn't know about our custom SO tables. Use current entity.
    $sql.=" WHERE fk_ruleset=".(int)$ruleset_id." AND active=1 AND entity=".(int)$conf->entity;
    $sql.=" ORDER BY pos ASC, rowid ASC";
    $res=$db->query($sql);
    if ($res) while($o=$db->fetch_object($res)) $out[]=$o;
    return $out;
}

$token = newToken();
function pr_check_token_value($tok) {
    if (empty($tok)) return false;
    if (function_exists('checkToken')) {
        // Some Dolibarr versions support checkToken($token) or checkToken()
        try { return (bool) checkToken($tok); } catch (Exception $e) {}
        try { return (bool) checkToken(); } catch (Exception $e) {}
    }
    if (!empty($_SESSION['newtoken']) && $tok === $_SESSION['newtoken']) return true;
    if (!empty($_SESSION['token']) && $tok === $_SESSION['token']) return true;
    if (!empty($_SESSION['csrf_token']) && $tok === $_SESSION['csrf_token']) return true;
    return false;
}


/*
 * Action: CREATE SO + BOM (assembly)
 */
if ($action === 'preview_so_bom') {
    // Step 1/2: preview only (NO validation, NO creation)
    $tok = GETPOST('token','alphanohtml');
    if (!pr_check_token_value($tok)) accessforbidden('Bad token');

    $current_so_ruleset = (int) GETPOST('so_ruleset_id','int');
    $socid = (int) GETPOST('socid','int');
    $sell_ref_in = trim(GETPOST('sell_ref','alphanohtml'));
    $sell_qty_in = (float) GETPOST('sell_qty','alphanohtml');
    if ($sell_qty_in <= 0) $sell_qty_in = 1;
    $prod_ruleset_id_in = (int) GETPOST('prod_ruleset_id','int');
    $material_packs_in = trim(GETPOST('material','alphanohtml'));
    $job_number_in = trim(GETPOST('job_number','alphanohtml'));

    // Customer label
    $custLabel = '';
    if ($socid > 0) {
        $soc = new Societe($db);
        if ($soc->fetch($socid) > 0) {
            $custLabel = $soc->name;
        }
    }

    // Sell label
    $sellLabel = '';
    if ($sell_ref_in !== '') {
        $p = new Product($db);
        if ($p->fetch(0, $sell_ref_in) > 0) {
            $sellLabel = $p->label;
        }
    }

    // Production RuleSet label
    $prLabel = '';
    if ($prod_ruleset_id_in > 0) {
        $prs = new ProdRuleSet($db);
        if ($prs->fetch($prod_ruleset_id_in) > 0) {
            $prLabel = $prs->ref;
            if (!empty($prs->creator_name)) {
                $prLabel .= ' — '.$prs->creator_name;
            }
        }
    }

    // Components list
    $comps = pr_get_components($db, $current_so_ruleset);

    $preview  = '<div class="pr-preview">';
    $preview .= '<div><b>SO</b></div>';
    $preview .= '<div style="margin-top:6px">';
    $preview .= '<b>Customer:</b> '.dol_escape_htmltag($custLabel).'<br>';
    $preview .= '<b>Sell:</b> '.dol_escape_htmltag($sell_ref_in);
    if ($sellLabel !== '') $preview .= ' — '.dol_escape_htmltag($sellLabel);
    $preview .= '<br>';
    $preview .= '<b>Qty:</b> '.((float)$sell_qty_in).'<br>';
    $preview .= '<b>Job:</b> '.dol_escape_htmltag($job_number_in).'<br>';
    $preview .= '</div>';

    $preview .= '<div style="margin-top:10px"><b>Components:</b><br>';
    if (empty($comps)) {
        $preview .= '<span class="opacitymedium">(no components)</span>';
    } else {
        foreach ($comps as $c) {
            $qPer = (float) $c->qty;
            if ($qPer <= 0) $qPer = 1;
            $qTot = $qPer * ((float) $sell_qty_in);
            $preview .= '&bull; '.dol_escape_htmltag($c->comp_ref).' x '.$qPer.' <span class="opacitymedium">(SO total: '.$qTot.')</span><br>';
        }
    }
    $preview .= '</div>';

    $preview .= '<div style="margin-top:10px"><b>Production RuleSet:</b><br>';
    $preview .= dol_escape_htmltag($prLabel).'</div>';
    if ($material_packs_in !== '') {
        $preview .= '<div style="margin-top:6px"><b>Material packs:</b> '.dol_escape_htmltag($material_packs_in).'</div>';
    }

    $preview .= '</div>';

    // Save preview + payload for confirm
    $GLOBALS['pr_so_preview_html'] = $preview;
    $GLOBALS['pr_so_preview_payload'] = array(
        'so_ruleset_id' => $current_so_ruleset,
        'socid' => $socid,
        'sell_ref' => $sell_ref_in,
        'sell_qty' => $sell_qty_in,
        'prod_ruleset_id' => $prod_ruleset_id_in,
        'material' => $material_packs_in,
        'job_number' => $job_number_in,
    );
}

if ($action === 'create_so_bom') {
    $tok = GETPOST('token','alphanohtml');
    if (!pr_check_token_value($tok)) accessforbidden('Bad token');

    $confirm = (int) GETPOST('confirm','int');
    if (empty($confirm)) {
        // Safety: creation must be triggered only from the modal confirm button
        setEventMessages('Please confirm generation first.', null, 'warnings');
    } else {

    $current_so_ruleset = (int) GETPOST('so_ruleset_id','int');
    $sell_ref = trim(GETPOST('so_sell_ref','alphanohtml'));
    if ($sell_ref === '') $sell_ref = trim(GETPOST('sell_ref','alphanohtml'));
    $sell_qty = (float) GETPOST('so_sell_qty','alphanohtml');
    if (empty($sell_qty)) $sell_qty = (float) GETPOST('sell_qty','alphanohtml');
    $socid = (int) GETPOST('socid','int');

    if ($sell_qty <= 0) $sell_qty = 1;

    if ($socid <= 0) {
        setEventMessages('Customer is required', null, 'errors');
    } elseif ($sell_ref === '') {
        setEventMessages('Sell product ref is required', null, 'errors');
    } else {
        $sellProd = new Product($db);
        $resf = $sellProd->fetch(0, $sell_ref);
        if ($resf <= 0) {
            setEventMessages('Sell product not found: '.$sell_ref, null, 'errors');
        } else {
            // Create Sales Order
            $order = new Commande($db);
            $order->socid = $socid;
            $order->date = dol_now();
            // Public note on SO
            $order->note_public = "Generated by ProductionRules (Sales Order rules)";
            if (!empty($sell_ref)) {
                $order->note_public .= "\nSell: ".$sell_ref;
                $order->note_public .= "  Qty: ".((float) $sell_qty);
            }

            $db->begin();
            $orderid = $order->create($user);
            if ($orderid <= 0) {
                $db->rollback();
                setEventMessages($order->error, $order->errors, 'errors');
            } else {
                // Add main sell line
                $desc = $sellProd->label;
                $pu = (float) $sellProd->price;
                $tva = (float) $sellProd->tva_tx;
                $resline = $order->addline($desc, $pu, $sell_qty, $tva, 0, 0, $sellProd->id, 0);
                if ($resline <= 0) {
                    $db->rollback();
                    setEventMessages($order->error, $order->errors, 'errors');
                } else {
                    // Add assembly components as SO lines too (qty scaled by sell qty)
                    $assemblyNote = '';
                    if ($current_so_ruleset > 0) {
                        $comps = pr_get_components($db, $current_so_ruleset);
                        if (!empty($comps)) {
                            $assemblyNote .= "\n\nAssembly components:";
                            foreach ($comps as $c) {
                                $pref = trim((string) $c->comp_ref);
                                $pqty = (float) $c->qty;
                                if ($pref === '' || $pqty <= 0) continue;

                                $p = new Product($db);
                                $rf = $p->fetch(0, $pref);
                                if ($rf > 0) {
                                    $lineDesc = $p->label;
                                    $linePu = 0; // components are informational for assembly, pricing handled by main line
                                    $lineTva = (float) $p->tva_tx;
                                    $lineQty = $pqty * $sell_qty;
                                    $resCompLine = $order->addline($lineDesc, $linePu, $lineQty, $lineTva, 0, 0, $p->id, 0);
                                    if ($resCompLine <= 0) {
                                        // Do not block creation if a component line fails
                                        setEventMessages($order->error, $order->errors, 'warnings');
                                    }
                                    $assemblyNote .= "\n- ".$pref." x ".price2num($lineQty);
                                } else {
                                    $assemblyNote .= "\n- ".$pref." x ".price2num($pqty * $sell_qty)." (not found)";
                                }
                            }
                            $assemblyNote .= "\n";
                        }
                    }

                    // Create BOM (assembly) from SO ruleset components
                    $bomId = 0;
                    if ($current_so_ruleset > 0) {
                        require_once DOL_DOCUMENT_ROOT.'/bom/class/bom.class.php';
                        require_once DOL_DOCUMENT_ROOT.'/bom/class/bomline.class.php';

                        $bom = new BOM($db);
                        $bom->ref = $sellProd->ref;
                        $bom->label = 'Assembly for '.$sellProd->ref;
                        $bom->fk_product = $sellProd->id;
                        $bom->qty = 1;
                        $bom->status = 1;
                        // Public note on BOM
                        $bomNote = "Generated by ProductionRules (Sales Order rules)";
                        if (!empty($sell_ref)) {
                            $bomNote .= "\nSell: ".$sell_ref."  Qty: ".((float) $sell_qty);
                        }

                        // Add components summary (per unit and totals for the SO qty)
                        $compsForNote = pr_get_components($db, $current_so_ruleset);
                        if (!empty($compsForNote)) {
                            $bomNote .= "\n\nComponents:";
                            foreach ($compsForNote as $cNote) {
                                $qPer = (float) $cNote->qty;
                                if ($qPer <= 0) $qPer = 1;
                                $qTot = $qPer * ((float) $sell_qty);
                                $bomNote .= "\n- ".$cNote->comp_ref."  x ".$qPer."  (SO total: ".$qTot.")";
                                if (!empty($cNote->note)) {
                                    $bomNote .= "\n  Note: ".$cNote->note;
                                }
                            }
                        }

                        $bom->note_public = $bomNote;
                        $resbom = $bom->create($user);
                        if ($resbom > 0) {
                            $bomId = $bom->id;

                            $comps = pr_get_components($db, $current_so_ruleset);
                            foreach ($comps as $c) {
                                $p = new Product($db);
                                $rf = $p->fetch(0, $c->comp_ref);
                                if ($rf > 0) {
                                    $line = new BOMLine($db);
                                    $line->fk_bom = $bomId;
                                    $line->fk_product = $p->id;
                                    $line->qty = (float) $c->qty;
                                    $line->position = (int) $c->pos;
                                    $line->note_public = $c->note;
                                    $line->create($user);
                                }
                            }

                            // Link info into order note
                            $order->fetch($orderid);
                            $order->note_public .= "\nBOM: ".$bom->ref;
                            $order->note_public .= $assemblyNote;
                            $order->update($user);
                        } else {
                            // BOM errors should not block SO creation
                            setEventMessages($bom->error, $bom->errors, 'warnings');
                        }
                    }

                    // If we didn't create BOM, still add components list to note
                    if (empty($bomId) && $assemblyNote !== '') {
                        $order->fetch($order->id);
                        $order->note_public .= $assemblyNote;
                        $order->update($user);
                    }

                    $db->commit();
                    setEventMessages('Sales Order created'.($bomId?(' + BOM created'):'') , null, 'mesgs');
                }
            }
        }
    }
    }
}

llxHeader('', $langs->trans('Sales Order rules'));

// Reuse module CSS (modal overlay + basic helpers)
print '<link rel="stylesheet" type="text/css" href="'.dol_buildpath('/custom/productionrules/css/productionrules.css', 1).'">';

// Page title styled like other module pages
print load_fiche_titre($langs->trans('Sales Order rules'), '', 'order');

print '<div class="fichecenter"><div class="fichehalfleft">';

print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
print '<input type="hidden" name="token" value="'.$token.'">';
print '<input type="hidden" name="action" value="create_so_ruleset">';
print '<table class="border centpercent">';
print '<tr><td class="titlefield">'.$langs->trans('New RuleSet ref').'</td><td><input type="text" name="new_so_ruleset_ref" value="" id="so_new_ruleset_ref"> <input class="button" type="submit" value="'.$langs->trans('Create').'"></td></tr>';
print '</table>';
print '</form>';

print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
print '<input type="hidden" name="token" value="'.$token.'">';
print '<input type="hidden" name="action" value="select_so_ruleset">';
print '<table class="border centpercent">';
print '<tr><td class="titlefield">'.$langs->trans('Rule set').'</td><td>';
print '<select name="so_ruleset_id" onchange="this.form.submit()">';
print '<option value="0">&nbsp;</option>';
foreach($soRulesets as $id=>$o){
    // Keep label clean (no debug suffixes)
    $label = $o->ref;
    if (!empty($o->creator_name)) {
        $label .= ' — ' . $o->creator_name;
    }
    $sel = ($id==$current_so_ruleset?' selected':'');
    print '<option value="'.$id.'"'.$sel.'>'.dol_escape_htmltag($label).'</option>';
}
print '</select>';
print '</td></tr>';

if ($current_so_ruleset > 0) {
    print '<tr><td>'.$langs->trans('Delete').'</td><td>';
	    print '<button type="submit" name="action" value="delete_so_ruleset" class="button button-cancel" onclick="return confirm(\''
	        . dol_escape_js($langs->trans('ConfirmDelete'))
	        . '\');">'.$langs->trans('Delete').'</button>';
    print '</td></tr>';
}
print '</table>';
print '</form>';

print '<hr>';

print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
print '<input type="hidden" name="token" value="'.$token.'">';
print '<input type="hidden" name="action" value="preview_so_bom">';
print '<input type="hidden" name="so_ruleset_id" value="'.$current_so_ruleset.'">';

print '<table class="border centpercent">';
print '<tr><td class="titlefield">Customer</td><td>';
print $form->select_company($customer_id,'socid','',1,0,0,array(),0,'minwidth300');
print '</td></tr>';
print '<tr><td>Sell product ref (FG/SF)</td><td><input type="text" class="pr-autocomplete" name="sell_ref" value="'.dol_escape_htmltag($sell_ref).'" placeholder="FGxxxx or SFxxxx" id="so_sell_ref"></td></tr>';
print '<tr><td>Qty</td><td><input type="text" name="sell_qty" value="'.($sell_qty>0?(float)$sell_qty:1).'" size="6"></td></tr>';
print '<tr><td>Production RuleSet</td><td>';
$prSet = new ProdRuleSet($db);
$prSets = $prSet->fetchAllForUser($user);
print '<select name="prod_ruleset_id"><option value="0">&nbsp;</option>';
foreach($prSets as $id=>$o){
    $lab=$o->ref;
    if (!empty($o->creator_name)) {
        $lab .= ' — ' . $o->creator_name;
    }
    $sel=($id==$prod_ruleset_id?' selected':'');
    print '<option value="'.$id.'"'.$sel.'>'.dol_escape_htmltag($lab).'</option>';
}
print '</select>';
print '</td></tr>';

print '<tr><td>Material packs</td><td><input type="text" id="so_material_packs" class="pr-autocomplete" name="material" value="'.dol_escape_htmltag($material_packs).'" placeholder="62133, 61111"></td></tr>';
print '<tr><td>Job</td><td><input type="text" name="job_number" value="'.dol_escape_htmltag($job_number).'" size="10"></td></tr>';

print '</table>';
print '<div class="center" style="margin-top:10px">';
print '<input class="button button-save" type="submit" value="Generate SO + BOM">';
print '</div>';
print '</form>';

print '</div><div class="fichehalfright">';

print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
print '<input type="hidden" name="token" value="'.$token.'">';
print '<input type="hidden" name="action" value="add_component">';
print '<input type="hidden" name="so_ruleset_id" value="'.$current_so_ruleset.'">';
print '<table class="border centpercent">';
print '<tr><td colspan="2"><b>Assembly list editor</b></td></tr>';
print '<tr><td class="titlefield">Component ref</td><td><input type="text" class="pr-autocomplete" name="comp_ref" value="" placeholder="FGxxxx / parts" id="so_comp_ref"></td></tr>';
print '<tr><td>Qty</td><td><input type="text" name="comp_qty" value="1" size="6" id="so_comp_qty"></td></tr>';
print '<tr><td>Comment</td><td><input type="text" name="comp_note" value="" size="30" id="so_comp_note"></td></tr>';
print '<tr><td colspan="2" class="center"><input class="button" type="submit" value="Add component"></td></tr>';
print '</table>';
print '</form>';

$comps = pr_get_components($db, $current_so_ruleset);

print '<div style="margin-top:10px">';
print '<b>Assembly flow</b><br>';
if (empty($current_so_ruleset)) {
    print '<span class="opacitymedium">Create or select a Sales Order RuleSet first.</span>';
} elseif (empty($comps)) {
    print '<span class="opacitymedium">No components yet.</span>';
} else {
    print '<div class="pr-flow-wrap">';
    $first=true;
    foreach($comps as $c){
        if (!$first) print ' <span class="pr-diag-arrow">→</span> ';
        $first=false;
        print '<span class="pr-node pr-node-fg">'.dol_escape_htmltag($c->comp_ref).'</span>';
    }
    print '</div>';

    print '<table class="noborder centpercent" style="margin-top:10px">';
    print '<tr class="liste_titre"><td>Ref</td><td class="right">Qty</td><td>Note</td><td class="right">Action</td></tr>';
    foreach($comps as $c){
        print '<tr class="oddeven">';
        print '<td>'.dol_escape_htmltag($c->comp_ref).'</td>';
        print '<td class="right">'.((float)$c->qty).'</td>';
        print '<td>'.dol_escape_htmltag($c->note).'</td>';
        print '<td class="right"><a class="butActionDelete" href="'.$_SERVER["PHP_SELF"].'?action=delete_component&token='.$token.'&so_ruleset_id='.$current_so_ruleset.'&rid='.$c->rowid.'">Del</a></td>';
        print '</tr>';
    }
    print '</table>';
}
print '</div>';

print '</div></div>';

// SO + BOM PREVIEW (step 1/2) - render modal overlay when preview is ready
if (!empty($GLOBALS['pr_so_preview_html'])) {
    $payload = (!empty($GLOBALS['pr_so_preview_payload']) ? $GLOBALS['pr_so_preview_payload'] : array());
    print '<div id="prSoPreviewModal" class="pr-modal-overlay">';
    print '  <div class="pr-modal">';
    print '    <div class="pr-modal-header">';
    print '      <div class="pr-modal-title">Confirm SO + BOM</div>';
    print '      <button type="button" class="pr-modal-close" onclick="prCloseSoPreview()">×</button>';
    print '    </div>';
    print '    <div class="pr-modal-body">';
    print $GLOBALS['pr_so_preview_html'];
    print '    </div>';
    print '    <div class="pr-modal-footer" style="display:flex; gap:8px; justify-content:flex-end;">';
    print '      <button type="button" class="button button-cancel" onclick="prCloseSoPreview()">CANCEL</button>';
    print '      <form method="POST" action="'.$_SERVER['PHP_SELF'].'" style="margin:0;">';
    print '        <input type="hidden" name="token" value="'.newToken().'">';
    print '        <input type="hidden" name="action" value="create_so_bom">';
    print '        <input type="hidden" name="so_ruleset_id" value="'.((int) ($payload['so_ruleset_id'] ?? 0)).'">';
    print '        <input type="hidden" name="socid" value="'.((int) ($payload['socid'] ?? 0)).'">';
    print '        <input type="hidden" name="sell_ref" value="'.dol_escape_htmltag($payload['sell_ref'] ?? '').'">';
    print '        <input type="hidden" name="sell_qty" value="'.((float) ($payload['sell_qty'] ?? 1)).'">';
    print '        <input type="hidden" name="prod_ruleset_id" value="'.((int) ($payload['prod_ruleset_id'] ?? 0)).'">';
    print '        <input type="hidden" name="material" value="'.dol_escape_htmltag($payload['material'] ?? '').'">';
    print '        <input type="hidden" name="job_number" value="'.dol_escape_htmltag($payload['job_number'] ?? '').'">';
    print '        <input type="hidden" name="confirm" value="1">';
    print '        <input type="submit" class="button button-save" value="CONFIRM & GENERATE">';
    print '      </form>';
    print '    </div>';
    print '  </div>';
    print '</div>';
    print '<script>
function prOpenSoPreview(){var el=document.getElementById("prSoPreviewModal"); if(el){el.classList.add("open");}}
function prCloseSoPreview(){var el=document.getElementById("prSoPreviewModal"); if(el){el.classList.remove("open");}}
document.addEventListener("DOMContentLoaded",function(){prOpenSoPreview();});
</script>';
}

// JS config + UI helpers (autocomplete)
// IMPORTANT: Use real newlines in JS output ("\n" expanded by PHP), not the literal characters "\\n".
print "<script type=\"text/javascript\">\n";
print "window.PR_CONFIG = window.PR_CONFIG || {};\n";
print "window.PR_CONFIG.urls = window.PR_CONFIG.urls || {};\n";
print "window.PR_CONFIG.urls.getProducts = \"".dol_buildpath('/custom/productionrules/ajax/getproducts.php', 1)."\";\n";
print '</script>'; 
print '<script src="'.dol_buildpath('/custom/productionrules/js/productionrules_ui.js', 1).'"></script>';

llxFooter();
$db->close();