<?php
require '../../../main.inc.php';

global $db;

$term  = trim(GETPOST('term', 'alpha'));
$field = GETPOST('field', 'alpha');

$sql = "SELECT ref FROM ".MAIN_DB_PREFIX."product";
$sql.= " WHERE entity IN (".getEntity('product').")";

if ($term !== '') {
    if ($field == 'from_ref') {
        $upper = strtoupper($term);

        // Jeśli wpisujesz FG... albo SF...
        if (strpos($upper, 'FG') === 0 || strpos($upper, 'SF') === 0) {
            // tylko kody zaczynające się od FG/SF
            $sql .= " AND ref LIKE '".$db->escape($upper)."%'";
        }
        // Jeśli pierwszy znak jest cyfrą -> szukamy tylko numerów od początku
        elseif (ctype_digit($term[0])) {
            $sql .= " AND ref LIKE '".$db->escape($term)."%'";
        }
        // W innych przypadkach - standardowo
        else {
            $sql .= " AND ref LIKE '%".$db->escape($term)."%'";
        }
    } else {
        // to_ref, fg_ref – stare zachowanie
        $sql .= " AND ref LIKE '%".$db->escape($term)."%'";
    }
}

$sql .= " ORDER BY ref ASC LIMIT 30";

$res = $db->query($sql);

$out = array();
if ($res) {
    while ($obj = $db->fetch_object($res)) {
        $out[] = $obj->ref;
    }
}

header('Content-Type: application/json');
echo json_encode($out);
exit;
