<?php
require '../../main.inc.php';

require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formcompany.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/commande/class/commande.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

require_once __DIR__.'/class/productionrules.class.php';
require_once __DIR__.'/class/ruleset.class.php';

$langs->loadLangs(array("orders", "products", "mrp"));

if (empty($user->rights->productionrules->read)) accessforbidden();

$form = new Form($db);
$formcompany = new FormCompany($db);

$action = GETPOST('action', 'alpha');

llxHeader('', 'Sales Order rules', '');

print '<div class="productionrules-wrap">';
print '<h2>Sales Order rules</h2>';

$ruleSetObj = new RuleSet($db);
$rulesets = $ruleSetObj->fetchAllForUser($user);

if ($action === 'create_so') {
    $socid = (int) GETPOST('socid', 'int');
    $sell_ref = trim(GETPOST('sell_ref', 'alphanohtml'));
    $qty = (float) price2num(GETPOST('qty', 'alpha'));
    $fk_ruleset = (int) GETPOST('fk_ruleset', 'int');
    $material_packs = trim(GETPOST('material_packs', 'alphanohtml'));
    $job = trim(GETPOST('job', 'alphanohtml'));

    if ($socid <= 0 || $sell_ref === '' || $qty <= 0 || $fk_ruleset <= 0) {
        setEventMessages('Missing required fields (Customer, Product, Qty, RuleSet).', null, 'errors');
    } else {
        // Resolve product by ref
        $prod = new Product($db);
        $resP = $prod->fetch(0, $sell_ref);
        if ($resP <= 0) {
            setEventMessages('Product ref not found: '.$sell_ref, null, 'errors');
        } else {
            // Create SO draft
            $com = new Commande($db);
            $com->socid = $socid;
            $com->date = dol_now();
            $com->note_public = "Generated by ProductionRules (SO Rules)\nProduct: ".$sell_ref."\nQty: ".$qty."\n";
            $resCreate = $com->create($user);
            if ($resCreate <= 0) {
                setEventMessages('Error creating Sales Order: '.$com->error, $com->errors, 'errors');
            } else {
                $resAdd = $com->addline($prod->description, $prod->price, $qty, $prod->tva_tx, 0, 0, $prod->id);
                if ($resAdd <= 0) {
                    setEventMessages('Error adding SO line: '.$com->error, $com->errors, 'errors');
                } else {
                    // Generate BOM package (SF + downstream) using selected ruleset
                    $sf_ref = '';
                    foreach ($rulesets as $rs) { if ((int)$rs->id === $fk_ruleset) { $sf_ref = $rs->ref; break; } }
                    if ($sf_ref === '') {
                        setEventMessages('Ruleset not found for id '.$fk_ruleset, null, 'errors');
                    } else {
                        $pr = new ProductionRules($db);
                        $routing_stage_step = null; // auto inside current implementation or null
                        $resBom = $pr->generateBomForRuleset($user, $fk_ruleset, $sf_ref, $qty, $job !== '' ? $job : null, $material_packs !== '' ? $material_packs : null, $routing_stage_step);
                        if ($resBom <= 0) {
                            setEventMessages('Error generating BOM package: '.$pr->error, $pr->errors, 'errors');
                        } else {
                            setEventMessages('Sales Order created (draft) and BOM package generated.', null, 'mesgs');
                        }
                    }
                }
            }
        }
    }
}

// Form
print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
print '<input type="hidden" name="token" value="'.newToken().'">';
print '<input type="hidden" name="action" value="create_so">';

print '<div class="pr-grid pr-grid-2">';

print '<div class="pr-card">';
print '<h3>Sales order</h3>';

print '<div class="pr-row"><label>Customer</label>';
print $formcompany->select_company(GETPOST('socid','int'), 'socid', '', 1, 0, 0, array(), 0, 'minwidth200');
print '</div>';

print '<div class="pr-row"><label>Product (FG or SF) ref</label>';
print '<input type="text" id="sell_ref" name="sell_ref" value="'.dol_escape_htmltag(GETPOST('sell_ref','alphanohtml')).'" class="minwidth200">';
print '</div>';

print '<div class="pr-row"><label>Qty</label>';
print '<input type="text" name="qty" value="'.dol_escape_htmltag(GETPOST('qty','alphanohtml') ?: '1').'" class="maxwidth100">';
print '</div>';

print '</div>';

print '<div class="pr-card">';
print '<h3>Production rules</h3>';

print '<div class="pr-row"><label>RuleSet</label>';
print '<select name="fk_ruleset" class="minwidth200">';
print '<option value="0">-- select --</option>';
foreach ($rulesets as $rs) {
    $sel = ((int)GETPOST('fk_ruleset','int') === (int)$rs->id) ? ' selected' : '';
    $label = $rs->ref;
    if (!empty($rs->creator_login)) $label .= ' ['.$rs->creator_login.']';
    print '<option value="'.(int)$rs->id.'"'.$sel.'>'.dol_escape_htmltag($label).'</option>';
}
print '</select>';
print '</div>';

print '<div class="pr-row"><label>Material packs</label>';
print '<input type="text" id="material_packs" name="material_packs" value="'.dol_escape_htmltag(GETPOST('material_packs','alphanohtml')).'" class="minwidth300" placeholder="e.g. 62133, 61111">';
print '</div>';

print '<div class="pr-row"><label>Job (optional)</label>';
print '<input type="text" name="job" value="'.dol_escape_htmltag(GETPOST('job','alphanohtml')).'" class="minwidth200">';
print '</div>';

print '</div>';

print '</div>';

print '<div class="pr-actions">';
print '<button class="button button-save" type="submit">Create SO + BOM</button>';
print '</div>';

print '</form>';
print '</div>';

print '<script src="'.dol_buildpath('/productionrules/js/productionrules_ui.js', 1).'"></script>';
print '<script>document.addEventListener("DOMContentLoaded", function(){ if (typeof prInitProductAutocomplete==="function"){ prInitProductAutocomplete("sell_ref"); } });</script>';

llxFooter();
$db->close();
