    <?php
    require '../../main.inc.php';

    require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
    require_once DOL_DOCUMENT_ROOT.'/core/class/html.formcompany.class.php';
    require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
    require_once DOL_DOCUMENT_ROOT.'/commande/class/commande.class.php';

    require_once __DIR__.'/class/productionrules.class.php';
    require_once __DIR__.'/class/ruleset.class.php';

    if (empty($user->rights->productionrules->read)) accessforbidden();

    $action = GETPOST('action','aZ09');
    $socid  = (int) GETPOST('socid','int');
    $sell_ref = trim(GETPOST('sell_ref','alphanohtml'));
    $qty = (float) price2num(GETPOST('qty','alpha'));
    $fk_ruleset = (int) GETPOST('fk_ruleset','int');
    $material_packs = trim(GETPOST('material','alphanohtml')); // optional packs list
    $job = trim(GETPOST('job_number','alphanohtml'));

    $form = new Form($db);
    $formcompany = new FormCompany($db);

    llxHeader('', 'Sales Order rules', '');

    print '<h2>Sales Order rules</h2>';

    $errors = array();
    $created = array();

    if ($action === 'create_so_package') {
        if ($socid <= 0) $errors[] = 'Select customer';
        if ($sell_ref === '') $errors[] = 'Select product ref (FG or SF)';
        if ($fk_ruleset <= 0) $errors[] = 'Select ruleset';
        if ($qty <= 0) $qty = 1;

        $prod = new Product($db);
        if (empty($errors)) {
            $res = $prod->fetch(0, $sell_ref);
            if ($res <= 0 || empty($prod->id)) $errors[] = 'Product not found: '.$sell_ref;
        }

        if (empty($errors)) {
            $db->begin();

            // 1) Create Sales Order (draft)
            $cmd = new Commande($db);
            $cmd->socid = $socid;
            $cmd->date_commande = dol_now();
            $cmd->note_public = 'Generated by ProductionRules (SO Rules)';
            $resCreate = $cmd->create($user);
            if ($resCreate <= 0) {
                $errors[] = $cmd->error;
            } else {
                // Add line with product using product price (HT) and VAT
                $desc = $prod->description ? $prod->description : $prod->label;
                $pu = (float) $prod->price;
                $tva = (float) $prod->tva_tx;

                $resLine = $cmd->addline($desc, $pu, $qty, $tva, 0, 0, $prod->id, 0);
                if ($resLine <= 0) {
                    $errors[] = $cmd->error;
                } else {
                    $created['so_id'] = $cmd->id;
                }
            }

            // 2) Generate BOM package (SF base + downstream) using existing generator
            if (empty($errors)) {
                $ruleset = new RuleSet($db);
                $ruleset->fetch($fk_ruleset);
                $sf_ref = $ruleset->ref;

                if (empty($sf_ref)) {
                    $errors[] = 'Ruleset has empty ref';
                } else {
                    $prodRules = new ProductionRules($db);
                    $bomId = $prodRules->generateBomForRuleset($user, $fk_ruleset, $sf_ref, $qty, $job, $material_packs);
                    if ($bomId <= 0) {
                        $errors[] = $prodRules->error;
                    } else {
                        $created['bom_sf_id'] = $bomId;
                    }
                }
            }


// 3) Auto-create MO from SF BOM (best-effort; if not supported, we just skip)
if (empty($errors) && !empty($created['bom_sf_id']) && isModEnabled('mrp')) {
    $moCreatedId = 0;

    // Try Dolibarr MRP class (most installs)
    if (file_exists(DOL_DOCUMENT_ROOT.'/mrp/class/mo.class.php')) {
        require_once DOL_DOCUMENT_ROOT.'/mrp/class/mo.class.php';
        if (class_exists('Mo')) {
            $mo = new Mo($db);
            // Best-effort: try common method names
            if (method_exists($mo, 'createFromBom')) {
                $resMo = $mo->createFromBom($user, (int)$created['bom_sf_id'], $qty);
                if ($resMo > 0) $moCreatedId = (int) $mo->id;
            } elseif (method_exists($mo, 'create_from_bom')) {
                $resMo = $mo->create_from_bom($user, (int)$created['bom_sf_id'], $qty);
                if ($resMo > 0) $moCreatedId = (int) $mo->id;
            }
        }
    }

    if ($moCreatedId > 0) {
        $created['mo_id'] = $moCreatedId;
    } else {
        // Not fatal
        setEventMessages('MO auto-create not available on this Dolibarr install (skipped).', null, 'warnings');
    }
}


            if (!empty($errors)) {
                $db->rollback();
            } else {
                $db->commit();
            }
        }
    }

    if (!empty($errors)) {
        foreach ($errors as $e) setEventMessages($e, null, 'errors');
    }

    if (!empty($created)) {
        print '<div class="ok">';
        if (!empty($created['so_id'])) print 'Created SO ID: '.(int)$created['so_id'].'<br>';
        if (!empty($created['bom_sf_id'])) print 'Created SF BOM ID: '.(int)$created['bom_sf_id'].'<br>';
        if (!empty($created['mo_id'])) print 'Created MO ID: '.(int)$created['mo_id'].'<br>';
        print '</div>';
    }

    // Load rulesets: admin sees all, users see own (RuleSet class handles it)
    $rsObj = new RuleSet($db);
    $rulesets = $rsObj->fetchAllForUser($user);

    print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
    print '<input type="hidden" name="token" value="'.newToken().'">';
    print '<input type="hidden" name="action" value="create_so_package">';

    print '<table class="border centpercent">';
    print '<tr><td class="titlefield">Customer</td><td>';
    print $formcompany->select_company($socid, 'socid', '', 1);
    print '</td></tr>';

    print '<tr><td>Product (FG or SF)</td><td>';
    print '<input type="text" id="sell_ref" name="sell_ref" value="'.dol_escape_htmltag($sell_ref).'" size="20"> ';
    print '</td></tr>';

    print '<tr><td>Qty</td><td><input type="text" name="qty" value="'.dol_escape_htmltag($qty?$qty:1).'" size="6"></td></tr>';

    print '<tr><td>RuleSet</td><td><select name="fk_ruleset">';
    print '<option value="0"></option>';
    foreach ($rulesets as $id=>$o) {
        $label = $o->ref;
        if (!empty($o->creator_login) && $user->admin) $label .= ' ['.$o->creator_login.']';
        $sel = ($fk_ruleset == $id) ? ' selected' : '';
        print '<option value="'.(int)$id.'"'.$sel.'>'.dol_escape_htmltag($label).'</option>';
    }
    print '</select></td></tr>';

    print '<tr><td>Material packs</td><td><input type="text" name="material" value="'.dol_escape_htmltag($material_packs).'" size="40"></td></tr>';
    print '<tr><td>Job number (optional)</td><td><input type="text" name="job_number" value="'.dol_escape_htmltag($job).'" size="10"></td></tr>';

    print '</table>';

    print '<div class="center"><input class="button" type="submit" value="Create SO + BOM + MO"></div>';
    print '</form>';

    // Attach existing autocomplete (product ref)
    print '<script>';
    print 'window.PR_CONFIG = window.PR_CONFIG || {};';
    print 'window.PR_CONFIG.ajax_product = "'.dol_buildpath('/productionrules/ajax/product_autocomplete.php', 1).'";';
    print '</script>';
    print '<script src="'.dol_buildpath('/productionrules/js/productionrules_ui.js', 1).'"></script>';
    print '<script>$(function(){ if (typeof attachProductAutocomplete==="function") attachProductAutocomplete("sell_ref"); });</script>';

    llxFooter();
    $db->close();
