<?php

// Ajax: add new step_order value to module constant

// z ajax/ -> ../ (productionrules) -> ../ (custom) -> ../ (htdocs)
// WYŁĄCZAMY CSRF/TOKEN DLA TEGO JEDNEGO PLIKU AJAX:
define('NOCSRFCHECK', 1);
define('NOTOKENRENEWAL', 1);
require '../../../main.inc.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';

header('Content-Type: application/json');

// -----------------------------------------------------------------------------
// 1. Uprawnienia: musi być zalogowany AND (admin OR prawo config do modułu)
// -----------------------------------------------------------------------------
if (empty($user->id) || (!$user->admin && empty($user->rights->productionrules->config))) {
    echo json_encode(array(
        'success' => false,
        'message' => 'Access denied (rights)'
    ));
    exit;
}

// -----------------------------------------------------------------------------
// 2. (opcjonalnie) token – na razie NIE blokujemy, żeby nie robić 403
// -----------------------------------------------------------------------------
// $token = GETPOST('token', 'alpha');
// if (!empty($token) && !dol_verifyToken($token)) {
//     echo json_encode(array(
//         'success' => false,
//         'message' => 'Invalid token'
//     ));
//     exit;
// }

// -----------------------------------------------------------------------------
// 3. Nowa wartość ze zgłoszenia
// -----------------------------------------------------------------------------
$value = GETPOST('value', 'int');
if (empty($value)) {
    echo json_encode(array(
        'success' => false,
        'message' => 'Missing value'
    ));
    exit;
}

// -----------------------------------------------------------------------------
// 4. Aktualna lista z konfiguracji
// -----------------------------------------------------------------------------
$steporder_list = getDolGlobalString('PRODUCTIONRULES_STEPORDER_LIST', '10,20,30,40,50');

$steporder_options = array();
foreach (explode(',', $steporder_list) as $v) {
    $v = trim($v);
    if ($v === '') continue;
    if (!is_numeric($v)) continue;
    $steporder_options[] = (int) $v;
}
if (empty($steporder_options)) {
    $steporder_options = array(10, 20, 30, 40, 50);
}

// -----------------------------------------------------------------------------
// 5. Dodajemy nową wartość, jeśli jeszcze jej nie ma
// -----------------------------------------------------------------------------
if (!in_array($value, $steporder_options, true)) {
    $steporder_options[] = (int) $value;
}

sort($steporder_options, SORT_NUMERIC);
$newlist        = implode(',', $steporder_options);
$max_steporder  = max($steporder_options);

// -----------------------------------------------------------------------------
// 6. Zapisujemy stałą
// -----------------------------------------------------------------------------
$res = dolibarr_set_const(
    $db,
    'PRODUCTIONRULES_STEPORDER_LIST',
    $newlist,
    'chaine',
    0,
    '',
    $conf->entity
);

if (!($res > 0)) {
    echo json_encode(array(
        'success' => false,
        'message' => 'Error saving constant: ' . $db->lasterror()
    ));
    exit;
}

// -----------------------------------------------------------------------------
// 7. Sukces
// -----------------------------------------------------------------------------
echo json_encode(array(
    'success'       => true,
    'message'       => 'OK',
    'list'          => $newlist,
    'max_steporder' => $max_steporder
));
exit;
