<?php
// Sales Order rules - Assembly flow editor (simple)
require '../../main.inc.php';

if (!$user->rights->productionrules->read) accessforbidden();

$langs->loadLangs(array('productionrules@productionrules','orders'));

require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';

dol_include_once('/productionrules/class/ruleset.class.php'); // existing
// Simple SO ruleset class lives in this file (no dedicated class yet)

// Actions
$action = GETPOST('action','aZ09');
$token = GETPOST('token','alphanohtml');

$form = new Form($db);

function pr_so_ruleset_create($db, $ref, $user) {
    $ref = trim($ref);
    if ($ref === '') return array(-1, 'Ref is empty');
    $sql = "INSERT INTO ".MAIN_DB_PREFIX."prod_so_ruleset(ref, status, datec, tms, fk_user_creat, entity)
            VALUES ('".$db->escape($ref)."', 1, '".$db->idate(dol_now())."', '".$db->idate(dol_now())."', ".((int)$user->id).", ".((int) $user->entity).")";
    $res = $db->query($sql);
    if (!$res) return array(-1, $db->lasterror());
    return array((int)$db->last_insert_id(MAIN_DB_PREFIX."prod_so_ruleset"), '');
}

function pr_so_rule_add($db, $fk_ruleset, $ref, $qty, $note, $user) {
    $ref = trim($ref);
    if ($ref === '') return array(-1, 'Component ref is empty');
    $qty = (float) $qty;
    if ($qty <= 0) $qty = 1;

    $sql = "INSERT INTO ".MAIN_DB_PREFIX."prod_so_rules(from_ref, to_ref, fk_ruleset, qty, note, tms, fk_user_creat, entity)
            VALUES ('SO', '".$db->escape($ref)."', ".((int)$fk_ruleset).", ".$qty.", ".($note!==''?("'".$db->escape($note)."'"):'NULL').", '".$db->idate(dol_now())."', ".((int)$user->id).", ".((int) $user->entity).")";
    $res = $db->query($sql);
    if (!$res) return array(-1, $db->lasterror());
    return array((int)$db->last_insert_id(MAIN_DB_PREFIX."prod_so_rules"), '');
}

// Selected SO ruleset
$so_ruleset_id = (int) GETPOST('so_ruleset_id','int');

if ($action === 'create_so_ruleset') {
    if (!formConfirmToken()) accessforbidden('Bad token');
    $ref = GETPOST('new_so_ruleset_ref','alphanohtml');
    list($newid, $err) = pr_so_ruleset_create($db, $ref, $user);
    if ($newid > 0) $so_ruleset_id = $newid;
    else setEventMessages($err, null, 'errors');
}

if ($action === 'add_component') {
    if (!formConfirmToken()) accessforbidden('Bad token');
    $so_ruleset_id = (int) GETPOST('so_ruleset_id','int');
    $cref = GETPOST('component_ref','alphanohtml');
    $qty  = GETPOST('component_qty','alphanohtml');
    $note = GETPOST('component_note','restricthtml'); // small comment
    list($newid, $err) = pr_so_rule_add($db, $so_ruleset_id, $cref, $qty, $note, $user);
    if ($newid <= 0) setEventMessages($err, null, 'errors');
}

if ($action === 'delete_component') {
    if (!formConfirmToken()) accessforbidden('Bad token');
    $rowid = (int) GETPOST('rowid','int');
    $so_ruleset_id = (int) GETPOST('so_ruleset_id','int');
    if ($rowid > 0) {
        $db->query("DELETE FROM ".MAIN_DB_PREFIX."prod_so_rules WHERE rowid=".$rowid." AND entity=".(int)$user->entity);
    }
}

// Load SO rulesets list
$so_rulesets = array();
$sql = "SELECT rowid, ref, fk_user_creat FROM ".MAIN_DB_PREFIX."prod_so_ruleset
        WHERE entity=".(int)$user->entity." ORDER BY rowid DESC";
$res = $db->query($sql);
if ($res) {
    while ($obj = $db->fetch_object($res)) $so_rulesets[] = $obj;
}

// Load components for selected ruleset
$components = array();
if ($so_ruleset_id > 0) {
    $sql = "SELECT rowid, to_ref, qty, note FROM ".MAIN_DB_PREFIX."prod_so_rules
            WHERE fk_ruleset=".$so_ruleset_id." AND entity=".(int)$user->entity."
            ORDER BY rowid ASC";
    $res = $db->query($sql);
    if ($res) while ($o=$db->fetch_object($res)) $components[]=$o;
}

llxHeader('', 'Sales Order rules');

print '<div class="pr-wrap">';
print '<div class="pr-col pr-col-left">';
print '<h2>Sales Order rules</h2>';

// Create/select SO ruleset
print '<form method="POST" action="'.dol_escape_htmltag($_SERVER["PHP_SELF"]).'">';
print '<input type="hidden" name="token" value="'.newToken().'">';
print '<input type="hidden" name="action" value="create_so_ruleset">';
print '<div class="pr-row">';
print '<label>New RuleSet ref</label> ';
print '<input type="text" name="new_so_ruleset_ref" value="" class="minwidth200"> ';
print '<button class="button" type="submit">CREATE</button>';
print '</div>';
print '</form>';

print '<form method="GET" action="'.dol_escape_htmltag($_SERVER["PHP_SELF"]).'">';
print '<div class="pr-row">';
print '<label>Rule set</label> ';
print '<select name="so_ruleset_id" class="minwidth200">';
print '<option value="0"></option>';
foreach($so_rulesets as $rs){
    $sel = ($so_ruleset_id == $rs->rowid) ? ' selected="selected"' : '';
    print '<option value="'.$rs->rowid.'"'.$sel.'>'.dol_escape_htmltag($rs->ref).'</option>';
}
print '</select> ';
print '<button class="button" type="submit">SELECT</button>';
print '</div>';
print '</form>';

print '</div>'; // left

print '<div class="pr-col pr-col-right">';
print '<h3>Assembly list editor</h3>';

if ($so_ruleset_id <= 0) {
    print '<div class="opacitymedium">Create or select a Sales Order RuleSet first.</div>';
} else {
    print '<form method="POST" action="'.dol_escape_htmltag($_SERVER["PHP_SELF"]).'">';
    print '<input type="hidden" name="token" value="'.newToken().'">';
    print '<input type="hidden" name="action" value="add_component">';
    print '<input type="hidden" name="so_ruleset_id" value="'.$so_ruleset_id.'">';

    print '<div class="pr-grid">';
    print '<div><label>Component ref</label><input type="text" name="component_ref" value="" placeholder="FGxxxx / parts" class="minwidth200"></div>';
    print '<div><label>Qty</label><input type="text" name="component_qty" value="1" class="minwidth100"></div>';
    print '<div style="grid-column:1 / span 2;"><label>Comment</label><input type="text" name="component_note" value="" class="minwidth300"></div>';
    print '</div>';
    print '<div class="pr-row"><button class="button" type="submit">ADD COMPONENT</button></div>';
    print '</form>';

    print '<h3 style="margin-top:18px;">Assembly flow</h3>';
    if (empty($components)) {
        print '<div class="opacitymedium">No components in this RuleSet.</div>';
    } else {
        // Simple flow: component1 -> component2 -> ...
        print '<div class="pr-flow">';
        $first = true;
        foreach($components as $c){
            if (!$first) print '<span class="pr-arrow">→</span>';
            $first=false;
            print '<span class="pr-node">'.dol_escape_htmltag($c->to_ref).' <span class="pr-qty">x '.((float)$c->qty).'</span></span>';
        }
        print '</div>';

        // Table list with delete
        print '<table class="noborder" style="margin-top:10px; width:100%;">';
        print '<tr class="liste_titre"><th>Component</th><th style="width:80px;">Qty</th><th>Comment</th><th style="width:60px;"></th></tr>';
        foreach($components as $c){
            print '<tr>';
            print '<td>'.dol_escape_htmltag($c->to_ref).'</td>';
            print '<td>'.((float)$c->qty).'</td>';
            print '<td>'.dol_escape_htmltag($c->note).'</td>';
            print '<td>';
            print '<form method="POST" action="'.dol_escape_htmltag($_SERVER["PHP_SELF"]).'" style="display:inline">';
            print '<input type="hidden" name="token" value="'.newToken().'">';
            print '<input type="hidden" name="action" value="delete_component">';
            print '<input type="hidden" name="so_ruleset_id" value="'.$so_ruleset_id.'">';
            print '<input type="hidden" name="rowid" value="'.$c->rowid.'">';
            print '<button class="button button-delete" type="submit">Del</button>';
            print '</form>';
            print '</td>';
            print '</tr>';
        }
        print '</table>';
    }
}
print '</div>'; // right
print '</div>'; // wrap

// Minimal CSS (reuse module styles if any)
print '<style>
.pr-wrap{display:flex; gap:30px; padding:10px;}
.pr-col{flex:1; min-width:0;}
.pr-row{margin:10px 0;}
.pr-grid{display:grid; grid-template-columns: 1fr 120px; gap:10px; align-items:end;}
.pr-flow{padding:10px; border:1px solid rgba(255,255,255,0.15); border-radius:6px; background:rgba(255,255,255,0.04);}
.pr-node{display:inline-block; padding:6px 10px; border:1px solid rgba(120,255,120,0.35); border-radius:4px; margin:2px 0;}
.pr-qty{opacity:0.85; margin-left:6px;}
.pr-arrow{margin:0 8px; opacity:0.7;}
</style>';

llxFooter();
$db->close();
