# Changelog

## v0.1.2 – Rule Engine Refinement (in progress)
### Business logic foundation
- Finalized architecture for automotive-style flow:

Rules → BOM → MO

- Defined reference behavior:
- Product references permanent (SF/FG)
- Job number stored only in BOM
- Added multi-output handling requirements:
- Single SF may generate multiple FG parts

### Planned enhancements
- Add routing operations:
- FORMING / TRIMMING / WASH / PACKING
- Add workstation assignment and routing graph
- Add scrap/overproduction parameters
- Add rule import/export
- Add rule preview & validation

---

## Backlog Items
- Revision support per rule + per BOM
- Automatic MO creation from BOM
- Warnings for inconsistent rules
- Batch processing for multi-job BOM generation
- Filtering and grouping rules in UI
- Multi-stage BOM visualization
- Logging + audit trail for manufacturing traceability
- Unit tests & code coverage

---

## v0.1.1 – Menu + MRP Integration
### Menu architecture
- Integrated module into MRP menu section
- Correct fk_menu logic for left menu:
  - `MRP → Production rules`
- Removed dependency on manual menu editing

### Visual improvements
- Added icon support using `$this->picto` + prefix
- Selected icon consistent with MRP/MO visual style

### Usability enhancements
- Installed menu under proper module group (MRP)
- Simplified module flow for future extensions

---

## v0.1.0 – Module foundation
### Module bootstrap
- Created custom Dolibarr module under `/htdocs/custom/productionrules`
- Implemented module descriptor `modProductionRules.class.php`
- Added metadata: module id, version, dependencies, subversion flags
- Implemented proper init/remove methods aligned with Dolibarr module lifecycle

### Core functionality
- Implemented SQL table for storing production rules
  - Columns for from_ref, to_ref, operation, qty_per_from, workstation, step_order, flags
  - Support for multi-output from a single input
  - Support for revision and job-specific BOM logic
- Added rule persistence:
  - Insert rule
  - Delete rule
  - Delete all rules
  - List rules

### UI integration
- Created custom UI page `productionrules_rules.php`
  - Rule add form
  - Rule listing table
  - Rule deletion controls
- Added backend logic for validation and sanitize user input

### BOM generator core
- Implemented rule engine to compute:
  - Consumption matrix
  - Multi-step transformations (material→SF→FG)
- Implemented BOM generator using Dolibarr BOM API:
  - Generated BOMs inherit job number in reference
  - Designed to avoid product duplication

### Infrastructure
- Support for multi-line operations
- Stateless UI workflow (no JS dependencies)
- Standardized function/class naming aligned with Dolibarr architecture
