<?php
/* Copyright ...
 * Module ProductionRules
 */

include_once DOL_DOCUMENT_ROOT . '/core/modules/DolibarrModules.class.php';

class modProductionRules extends DolibarrModules
{
    public function __construct($db)
    {
        global $langs;

        $this->db = $db;

        $this->numero = 120000;  // dowolny, ale unikalny w Twojej instancji
        $this->rights_class = 'productionrules';

//        $this->family = "production";
        $this->family = 'products';
        $this->name = 'productionrules';
        $this->description = "Production rules and automatic BOM generator";
        $this->descriptionlong = "Manage production rules (from_ref/to_ref/operation) and generate BOM structures automatically.";
        $this->editor_name = 'Marcin Flaumenhaft';
//        $this->editor_url = 'https://your-company.example';
        $this->version = '0.1.2';
        $this->const_name = 'MAIN_MODULE_PRODUCTIONRULES';
        $this->picto = 'mrp';

        $this->module_parts = array(
            'triggers' => 0,
            'login'    => 0,
            'substitutions' => 0,
            'menus'    => 1, // we define menus below
            'tpl'      => 0,
            'hooks'    => 0
        );

        $this->dirs = array(
            '/productionrules'
        );

        $this->config_page_url = array('/custom/productionrules/admin/productionrules_setup.php');
$this->depends = array('modBom', 'modProduct'); // i opcjonalnie 'modMrp'
        $this->requiredby = array();
        $this->phpmin = array(7,0);
        $this->langfiles = array('productionrules@productionrules');

        // Rights
        $this->rights = array();
        $r=0;

        $this->rights[$r][0] = 120001;
        $this->rights[$r][1] = 'Read production rules';
        $this->rights[$r][2] = 'r';
        $this->rights[$r][3] = 1;
        $this->rights[$r][4] = 'read';
        $r++;

        $this->rights[$r][0] = 120002;
        $this->rights[$r][1] = 'Create/update production rules';
        $this->rights[$r][2] = 'w';
        $this->rights[$r][3] = 0;
        $this->rights[$r][4] = 'write';
        $r++;

        $this->rights[$r][0] = 120003;
        $this->rights[$r][1] = 'Generate BOM from rules';
        $this->rights[$r][2] = 'w';
        $this->rights[$r][3] = 0;
        $this->rights[$r][4] = 'generate_bom';
        $r++;

        $this->rights[$r][0] = 120004;                      // ID prawa (unikalne w module)
        $this->rights[$r][1] = 'Configure production rules';// Label
        $this->rights[$r][2] = 'w';
        $this->rights[$r][3] = 0;                           // 0 = domyślnie wyłączone
        $this->rights[$r][4] = 'config';                    // => $user->rights->productionrules->config
        $r++;

        // Menus
        $this->menu = array();
        $r = 0;

        // Główne menu w Manufacturing
        $this->menu[$r++] = array(
            'fk_menu'   => 'fk_mainmenu=mrp',     // ← TYLKO to, bez fk_leftmenu
            'type'      => 'left',
            'titre'     => 'Production rules',
//            'prefix'    => img_picto('','productionrules@productionrules'),
            'mainmenu'  => 'mrp',
            'leftmenu'  => 'productionrules',    // kod tego wpisu, może być dowolny unikalny
            'url'       => '/custom/productionrules/productionrules_rules.php',
            'langs'     => '',
            'prefix' => img_picto('', $this->picto, 'class="pictofixedwidth paddingright"'),
            'position'  => 1000 + $r,            // kolejnosc pod MRP, może być 10, 20 itd.
            'enabled'   => 'isModEnabled("productionrules")',
            'perms'     => '$user->rights->productionrules->read',
            'target'    => '',
            'user'      => 2                     // 0=internal,1=external,2=both
        );
        
// Submenu: Sales Order rules
$this->menu[$r++] = array(
    'fk_menu'   => 'fk_mainmenu=mrp,fk_leftmenu=productionrules',
    'type'      => 'left',
    'titre'     => 'Sales Order rules',
    'mainmenu'  => 'mrp',
    'leftmenu'  => 'productionrules_salesorder_rules',
    'url'       => '/custom/productionrules/productionrules_salesorder_rules.php',
    'langs'     => '',
    'prefix'    => img_picto('', 'order', 'class="pictofixedwidth paddingright"'),
    'position'  => 1000 + $r,
    'enabled'   => 'isModEnabled("productionrules")',
    'perms'     => '$user->rights->productionrules->read',
    'target'    => '',
    'user'      => 2
);
        $r++;
    }

    public function init($options = '')
    {
        // Załaduj definicje tabel z katalogu /productionrules/sql/
        $result = $this->_load_tables('/productionrules/sql/');

        // Standardowa inicjalizacja modułu (prawa, const, menu itd.)
        return ($this->_init(array(), $options) && $result >= 0) ? 1 : -1;
    }

    public function remove($options = '')
    {
        // Standardowe usuwanie (usuwa prawa, const itp., ale NIE tabele)
        return $this->_remove(array(), $options);
    }
}
