<?php

require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class ProdRuleSet extends CommonObject
{
    public $element       = 'prod_ruleset';
    public $table_element = 'prod_ruleset';

    /** @var DoliDB */
    public $db;

    public $id;
    public $ref;
    public $description;
    public $status;
    public $fk_user_creat;
    public $entity;
    public $creator_name;

    public function __construct($db)
    {
        $this->db = $db;
    }

    /**
     * Fetch RuleSet by rowid.
     *
     * We keep it lightweight because Sales Order preview needs a single label.
     *
     * @param int $id
     * @return int 1 if found, 0 if not found, <0 on error
     */
    public function fetch($id)
    {
        $id = (int) $id;
        if ($id <= 0) return 0;

        $sql  = "SELECT rs.rowid, rs.ref, rs.fk_user_creat, rs.entity";
        $sql .= ", u.firstname, u.lastname, u.login";
        $sql .= " FROM ".MAIN_DB_PREFIX."prod_ruleset AS rs";
        $sql .= " LEFT JOIN ".MAIN_DB_PREFIX."user AS u ON u.rowid = rs.fk_user_creat";
        $sql .= " WHERE rs.rowid = ".$id;
        $sql .= " AND rs.entity IN (".getEntity('prod_ruleset').")";

        $res = $this->db->query($sql);
        if (!$res) {
            $this->error = $this->db->lasterror();
            return -1;
        }

        if ($this->db->num_rows($res) == 0) return 0;

        $obj = $this->db->fetch_object($res);
        $this->id = (int) $obj->rowid;
        $this->ref = (string) $obj->ref;
        $this->fk_user_creat = (int) $obj->fk_user_creat;
        $this->entity = (int) $obj->entity;

        $name = trim((string) $obj->firstname.' '.(string) $obj->lastname);
        if ($name === '') $name = (string) $obj->login;
        $this->creator_name = $name;

        return 1;
    }

    /**
     * Create minimal RuleSet (ref)
     */
    public function createMinimal($user, $ref, $description = '')
    {
        global $conf;

        $now = $this->db->idate(dol_now());

        // Jeśli istnieje już taki ref dla tego usera, dodaj sufiks -2, -3, ...
        $baseRef = $ref;
        $i = 1;
        while (1) {
            $sql = "SELECT rowid FROM ".MAIN_DB_PREFIX."prod_ruleset";
            $sql .= " WHERE ref = '".$this->db->escape($ref)."'";
            $sql .= " AND fk_user_creat = ".(int) $user->id;
            $sql .= " AND entity IN (".getEntity('prod_ruleset').")";
            $res = $this->db->query($sql);
            if (!$res) break; // jak błąd, i tak wejdziemy w insert i zobaczymy error
            if ($this->db->num_rows($res) == 0) {
                break; // wolny ref
            }
            $i++;
            $ref = $baseRef.'-'.$i;
        }

        $sql  = "INSERT INTO " . MAIN_DB_PREFIX . "prod_ruleset(";
        $sql .= "ref, description, status, datec, fk_user_creat, entity";
        $sql .= ") VALUES (";
        $sql .= "'" . $this->db->escape($ref) . "',";
        if (!empty($description)) {
            $sql .= "'" . $this->db->escape($description) . "',";
        } else {
            $sql .= "NULL,";
        }
        $sql .= "1,";
        $sql .= "'" . $this->db->escape($now) . "',";
        $sql .= (int) $user->id . ",";
        $sql .= (int) $conf->entity;
        $sql .= ")";

        if (!$this->db->query($sql)) {
            $this->error = $this->db->lasterror();
            return -1;
        }

        $this->id = $this->db->last_insert_id(MAIN_DB_PREFIX . "prod_ruleset");
        $this->ref = $ref;
        return $this->id;
    }

    /**
     * List RuleSets for current entity & (opcjonalnie) user
     */
    public function fetchAllForUser($user = null)
    {
        // By default: user sees only own RuleSets.
        // Admin or users with permission productionrules->viewallrulesets can see all.
        $canSeeAll = false;
        if ($user) {
            $canSeeAll = (!empty($user->admin) || !empty($user->rights->productionrules->viewallrulesets));
        }

        $sql  = "SELECT rs.rowid, rs.ref, rs.fk_user_creat";
        $sql .= ", u.firstname, u.lastname, u.login";
        $sql .= " FROM " . MAIN_DB_PREFIX . "prod_ruleset AS rs";
        $sql .= " LEFT JOIN " . MAIN_DB_PREFIX . "user AS u ON u.rowid = rs.fk_user_creat";
        $sql .= " WHERE rs.entity IN (" . getEntity('prod_ruleset') . ")";
        $sql .= " AND rs.status = 1";

        if ($user && !$canSeeAll) {
            $sql .= " AND rs.fk_user_creat = " . (int) $user->id;
        }

        $sql .= " ORDER BY rs.rowid";

        $res = $this->db->query($sql);
        if (!$res) return array();

        $out = array();
        while ($obj = $this->db->fetch_object($res)) {
            // Build nice creator label: "Firstname Lastname" or fallback to login
            $name = trim((string) $obj->firstname . ' ' . (string) $obj->lastname);
            if ($name === '') $name = (string) $obj->login;
            $obj->creator_name = $name;
            $out[$obj->rowid] = $obj;
        }
        return $out;
    }
}
