# Dolibarr Module: Production Rules (MRP Extension)

## Overview
Production Rules is a custom Dolibarr module that adds missing MRP functionality:
defining process rules for transforming raw material → semi-finished → final products,
including multi-output operations and BOM generation per job number.

Designed for real manufacturing use (automotive/aerospace).

## Features
- Custom menu entry under **MRP → Production rules**
- Custom SQL table to store production rules
- UI for adding/editing/deleting rules
- Multi-output rules (example: 1 SF → multiple FG)
- Operation chain (e.g. FORMING → TRIMMING → WASH → PACKING)
- Workstation support (FM, CNC, LASER etc.)
- Generate BOM from rules
- BOM per **job number**, not per product ref
- Works with standard Dolibarr BOM module
- Icons and UI integrated into standard MRP menu

## Architecture (MRP logic)
The module works with standard Dolibarr MRP components:

Production Rules → BOM → Manufacturing Orders


Production Rules define how product is created.
BOM is generated automatically from rules.
Later MO can consume the generated BOM.

## Requirements
- Dolibarr 22+
- PHP 8+
- Folder structure:
  `htdocs/custom/productionrules/`

## Installation
1. Copy module to:
   `htdocs/custom/productionrules/`
2. Activate in Dolibarr:
   `Setup → Modules → Production Rules`
3. Open module via:
   `MRP → Production rules`

## File structure

custom/productionrules/
core/modules/modProductionRules.class.php
productionrules_rules.php
class/productionrules.class.php
img/object_productionrules.png
sql/


## Usage
### 1. Define rules
Example:
- From 62011 (material) → SF2001-00 (FORMING)
- SF2001-00 → FG2001-00 (TRIMMING)
- SF2001-00 → FG2002-00 (TRIMMING)

### 2. Generate BOM
Enter:
- Product ref (SF or FG)
- Job number
- Quantity

The module creates BOM like:
`BOM-FG2001-00-1011202`

## TODO / Planned Features
- Routing editor
- Scrap % and oversize production
- Automatic MO generation from BOM
- Multi-operation preview
- Import/Export rules
