<?php

require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class ProdRuleSet extends CommonObject
{
    public $element       = 'prod_ruleset';
    public $table_element = 'prod_ruleset';

    /** @var DoliDB */
    public $db;

    public $id;
    public $ref;
    public $description;
    public $status;
    public $fk_user_creat;
    public $entity;

    public function __construct($db)
    {
        $this->db = $db;
    }

    /**
     * Create minimal RuleSet (ref)
     */
    public function createMinimal($user, $ref, $description = '')
    {
        global $conf;

        $now = $this->db->idate(dol_now());

        // Jeśli istnieje już taki ref dla tego usera, dodaj sufiks -2, -3, ...
        $baseRef = $ref;
        $i = 1;
        while (1) {
            $sql = "SELECT rowid FROM ".MAIN_DB_PREFIX."prod_ruleset";
            $sql .= " WHERE ref = '".$this->db->escape($ref)."'";
            $sql .= " AND fk_user_creat = ".(int) $user->id;
            $sql .= " AND entity IN (".getEntity('prod_ruleset').")";
            $res = $this->db->query($sql);
            if (!$res) break; // jak błąd, i tak wejdziemy w insert i zobaczymy error
            if ($this->db->num_rows($res) == 0) {
                break; // wolny ref
            }
            $i++;
            $ref = $baseRef.'-'.$i;
        }

        $sql  = "INSERT INTO " . MAIN_DB_PREFIX . "prod_ruleset(";
        $sql .= "ref, description, status, datec, fk_user_creat, entity";
        $sql .= ") VALUES (";
        $sql .= "'" . $this->db->escape($ref) . "',";
        if (!empty($description)) {
            $sql .= "'" . $this->db->escape($description) . "',";
        } else {
            $sql .= "NULL,";
        }
        $sql .= "1,";
        $sql .= "'" . $this->db->escape($now) . "',";
        $sql .= (int) $user->id . ",";
        $sql .= (int) $conf->entity;
        $sql .= ")";

        if (!$this->db->query($sql)) {
            $this->error = $this->db->lasterror();
            return -1;
        }

        $this->id = $this->db->last_insert_id(MAIN_DB_PREFIX . "prod_ruleset");
        $this->ref = $ref;
        return $this->id;
    }

    /**
     * List RuleSets for current entity & (opcjonalnie) user
     */
    public function fetchAllForUser($user = null)
    {
        $sql  = "SELECT rowid, ref";
        $sql .= " FROM " . MAIN_DB_PREFIX . "prod_ruleset";
        $sql .= " WHERE entity IN (" . getEntity('prod_ruleset') . ")";
        $sql .= " AND status = 1";

        if ($user) {
            $sql .= " AND fk_user_creat = " . (int) $user->id;   // ⬅️ tu jest filtr
        }

        $sql .= " ORDER BY rowid";

        $res = $this->db->query($sql);
        if (!$res) return array();

        $out = array();
        while ($obj = $this->db->fetch_object($res)) {
            $out[$obj->rowid] = $obj;
        }
        return $out;
    }
}
