<?php
//  Admin page for ProductionRules

require '../../../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';

$langs->load("admin");
$langs->load("other");

// Security: tylko admin
if (!$user->admin) accessforbidden();

// Nazwa modułu (tak jak rights_class)
$module = 'productionrules';

// Przetwarzanie formularza
$action = GETPOST('action','alpha');

if ($action == 'set_const' && !empty($_POST['token'])) {
    $res = 0;

    // Tryb używania job number (ON/OFF)
    $res += dolibarr_set_const(
        $db,
        'PRODUCTIONRULES_USE_JOB_NUMBER',
        GETPOST('PRODUCTIONRULES_USE_JOB_NUMBER','alpha'),
        'chaine',
        0,
        '',
        $conf->entity
    );

    // Domyślny prefiks BOM (np. BOM-)
    $res += dolibarr_set_const(
        $db,
        'PRODUCTIONRULES_BOM_PREFIX',
        GETPOST('PRODUCTIONRULES_BOM_PREFIX','alpha'),
        'chaine',
        0,
        '',
        $conf->entity
    );

    // Lista dostępnych step_order (np. 10,20,30,40,50)
    $res += dolibarr_set_const(
        $db,
        'PRODUCTIONRULES_STEPORDER_LIST',
        GETPOST('PRODUCTIONRULES_STEPORDER_LIST','alpha'),
        'chaine',
        0,
        '',
        $conf->entity
    );

    if ($res >= 0) {
        setEventMessage($langs->trans("SetupSaved"), 'mesgs');
    } else {
        setEventMessage("Error", 'errors');
    }
}

// Pobierz aktualne wartości
$use_job       = getDolGlobalString('PRODUCTIONRULES_USE_JOB_NUMBER', 'yes');
$bom_prefix    = getDolGlobalString('PRODUCTIONRULES_BOM_PREFIX', 'BOM-');
$steporder_list = getDolGlobalString('PRODUCTIONRULES_STEPORDER_LIST', '10,20,30,40,50');

// ---------------------------------------------------------
// WIDOK
// ---------------------------------------------------------

llxHeader('', 'ProductionRules setup', '');

$linkback = '<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
print load_fiche_titre('ProductionRules setup', $linkback, 'mrp');

// Karta ustawień
print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
print '<input type="hidden" name="token" value="'.newToken().'">';
print '<input type="hidden" name="action" value="set_const">';

print '<table class="noborder centpercent">';
print '<tr class="liste_titre"><th colspan="3">General settings</th></tr>';

// Opcja 1: użycie job number
print '<tr class="oddeven">';
print '<td>Use job number in BOM generator</td>';
print '<td>';
print '<select name="PRODUCTIONRULES_USE_JOB_NUMBER">';
print '<option value="yes"'.($use_job=='yes'?' selected':'').'>Yes</option>';
print '<option value="no"'.($use_job=='no'?' selected':'').'>No</option>';
print '</select>';
print '</td>';
print '<td class="right">'.$langs->trans("UsedToControlJobFieldVisibility").'</td>';
print '</tr>';

// Opcja 2: prefiks BOM
print '<tr class="oddeven">';
print '<td>Default BOM ref prefix</td>';
print '<td><input type="text" name="PRODUCTIONRULES_BOM_PREFIX" value="'.dol_escape_htmltag($bom_prefix).'" size="20"></td>';
print '<td class="right">Prefix used when auto-creating BOM refs</td>';
print '</tr>';

// Opcja 3: lista dostępnych step_order
print '<tr class="oddeven">';
print '<td>Available step_order values</td>';
print '<td><input type="text" name="PRODUCTIONRULES_STEPORDER_LIST" value="'.dol_escape_htmltag($steporder_list).'" size="40"></td>';
print '<td class="right">Comma-separated list, e.g. 10,20,30,40,50</td>';
print '</tr>';

print '</table>';

print '<div class="center">';
print '<input type="submit" class="button" value="'.$langs->trans("Save").'">';
print '</div>';

print '</form>';

llxFooter();
$db->close();
