<?php
class ProdSoRuleSet
{
    public $db;
    public $id = 0;
    public $ref = '';

    public function __construct($db){ $this->db=$db; }

    public function fetchAllForUser($user)
    {
        $sql = "SELECT rowid, ref, fk_user_creat";
        $sql.= " FROM ".MAIN_DB_PREFIX."prod_so_ruleset";
        $sql.= " WHERE entity IN (".getEntity('prod_so_ruleset').")";
        if (empty($user->admin)) {
            $sql.= " AND fk_user_creat=".(int)$user->id;
        }
        $sql.= " AND active=1";
        $sql.= " ORDER BY ref ASC";
        $res = $this->db->query($sql);
        $out = array();
        if ($res) {
            while ($obj=$this->db->fetch_object($res)) $out[$obj->rowid]=$obj;
        }
        return $out;
    }

    public function create($user, $ref)
    {
        global $conf;
        $ref = trim($ref);
        if ($ref==='') return -1;
        $sql = "INSERT INTO ".MAIN_DB_PREFIX."prod_so_ruleset(entity, ref, fk_user_creat, datec, active)";
        $sql.= " VALUES (".(int) $conf->entity.", '".$this->db->escape($ref)."', ".(int)$user->id.", '".$this->db->idate(dol_now())."', 1)";
        return $this->db->query($sql) ? $this->db->last_insert_id(MAIN_DB_PREFIX."prod_so_ruleset") : -1;
    }

    /**
     * Soft-delete a Sales Order RuleSet and all its component rows.
     * We set active=0 instead of hard delete.
     */
    public function disable($user, $id)
    {
        $id = (int) $id;
        if ($id <= 0) return -1;

        $this->db->begin();

        // Disable component rows
        $sql = "UPDATE ".MAIN_DB_PREFIX."prod_so_rules SET active=0 WHERE fk_ruleset=".$id;
        if (!$this->db->query($sql)) {
            $this->db->rollback();
            return -1;
        }

        // Disable ruleset
        $sql = "UPDATE ".MAIN_DB_PREFIX."prod_so_ruleset SET active=0 WHERE rowid=".$id;
        if (!$this->db->query($sql)) {
            $this->db->rollback();
            return -1;
        }

        $this->db->commit();
        return 1;
    }

    /**
     * Hard delete a Sales Order RuleSet and all its component rows.
     *
     * @param User $user
     * @param int  $id
     * @return int >0 on success, <0 on error
     */
    public function deleteCascade($user, $id)
    {
        $id = (int) $id;
        if ($id <= 0) return -1;

        $this->db->begin();

        $sql = "DELETE FROM ".MAIN_DB_PREFIX."prod_so_rules WHERE fk_ruleset=".$id;
        if (!$this->db->query($sql)) {
            $this->db->rollback();
            return -1;
        }

        $sql = "DELETE FROM ".MAIN_DB_PREFIX."prod_so_ruleset WHERE rowid=".$id;
        if (!$this->db->query($sql)) {
            $this->db->rollback();
            return -1;
        }

        $this->db->commit();
        return 1;
    }
}
