<?php
/**
 * AssemblySet: holds assembly component list for a sold product (ref).
 */
class ProdAssemblySet
{
    public $db;
    public $id = 0;
    public $ref = '';
    public $description = '';
    public $fk_user_creat = 0;
    public $entity = 1;

    public function __construct($db)
    {
        $this->db = $db;
    }

    public function fetchByRef($ref)
    {
        global $conf;
        $this->entity = (int) $conf->entity;
        $sql = "SELECT rowid, ref, description, fk_user_creat, entity";
        $sql.= " FROM ".MAIN_DB_PREFIX."prod_assemblyset";
        $sql.= " WHERE ref='".$this->db->escape($ref)."' AND entity=".$this->entity;
        $res = $this->db->query($sql);
        if (!$res) return -1;
        if ($obj = $this->db->fetch_object($res)) {
            $this->id = (int) $obj->rowid;
            $this->ref = $obj->ref;
            $this->description = $obj->description;
            $this->fk_user_creat = (int) $obj->fk_user_creat;
            return 1;
        }
        return 0;
    }

    public function create($ref, $user)
    {
        global $conf;
        $this->entity = (int) $conf->entity;
        $now = dol_now();
        $sql = "INSERT INTO ".MAIN_DB_PREFIX."prod_assemblyset(ref, description, fk_user_creat, entity, datec, tms, status)";
        $sql.= " VALUES(";
        $sql.= " '".$this->db->escape($ref)."', NULL, ".((int)$user->id).", ".$this->entity.", '".$this->db->idate($now)."', '".$this->db->idate($now)."', 1)";
        $res = $this->db->query($sql);
        if (!$res) return -1;
        $this->id = (int) $this->db->last_insert_id(MAIN_DB_PREFIX."prod_assemblyset");
        $this->ref = $ref;
        $this->fk_user_creat = (int) $user->id;
        return $this->id;
    }

    public function getList($onlyMine = false)
    {
        global $conf, $user;
        $entity = (int) $conf->entity;
        $sql = "SELECT rowid, ref, fk_user_creat FROM ".MAIN_DB_PREFIX."prod_assemblyset WHERE entity=".$entity;
        if ($onlyMine) $sql .= " AND fk_user_creat=".(int)$user->id;
        $sql .= " ORDER BY ref ASC";
        $res = $this->db->query($sql);
        if (!$res) return array();
        $out=array();
        while($obj=$this->db->fetch_object($res)) {
            $out[]=$obj;
        }
        return $out;
    }
}
