<?php
require '../../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/commande/class/commande.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

dol_include_once('/productionrules/class/soruleset.class.php');
dol_include_once('/productionrules/class/ruleset.class.php');          // ProdRuleSet (production flow)
dol_include_once('/productionrules/class/productionrules.class.php');  // for BOM generation

$langs->load('productionrules@productionrules');

if (empty($user->rights->productionrules->read)) accessforbidden();

$action = GETPOST('action','aZ09');
$current_so_ruleset = (int) GETPOST('so_ruleset_id','int');
$ref_new = trim(GETPOST('new_so_ruleset_ref','alphanohtml'));

$comp_ref = trim(GETPOST('comp_ref','alphanohtml'));
$comp_qty = (float) GETPOST('comp_qty','int'); // keep simple int qty for now
$comp_note = trim(GETPOST('comp_note','alphanohtml'));

$customer_id = (int) GETPOST('socid','int');
$sell_ref = trim(GETPOST('sell_ref','alphanohtml'));
$sell_qty = (float) GETPOST('sell_qty','int');
$prod_ruleset_id = (int) GETPOST('prod_ruleset_id','int');
$material_packs = trim(GETPOST('material','alphanohtml'));
$job_number = trim(GETPOST('job_number','alphanohtml'));

$soObj = new ProdSoRuleSet($db);
$soRulesets = $soObj->fetchAllForUser($user);

if ($action === 'create_so_ruleset' && $ref_new !== '') {
    $newid = $soObj->create($user, $ref_new);
    if ($newid > 0) {
        $current_so_ruleset = (int) $newid;
        setEventMessages($langs->trans('RecordSaved'), null, 'mesgs');
    } else {
        setEventMessages($langs->trans('Error'), null, 'errors');
    }
    $soRulesets = $soObj->fetchAllForUser($user);
}

// Delete Sales Order RuleSet (hard delete + cascade)
if ($action === 'delete_so_ruleset' && $current_so_ruleset > 0) {
    $res = $soObj->deleteCascade($user, $current_so_ruleset);
    if ($res > 0) {
        setEventMessages($langs->trans('RecordDeleted'), null, 'mesgs');
        $current_so_ruleset = 0;
    } else {
        setEventMessages($langs->trans('Error'), null, 'errors');
    }
    $soRulesets = $soObj->fetchAllForUser($user);
}

if ($action === 'add_component' && $current_so_ruleset > 0 && $comp_ref !== '') {
    $qty = ($comp_qty > 0 ? $comp_qty : 1);
    $sqlp = "SELECT MAX(pos) as mp FROM ".MAIN_DB_PREFIX."prod_so_rules";
    $sqlp.= " WHERE fk_ruleset=".(int)$current_so_ruleset." AND entity IN (".getEntity('prod_so_rules').")";
    $resp = $db->query($sqlp);
    $pos = 0;
    if ($resp && ($o=$db->fetch_object($resp))) $pos = (int)$o->mp + 10;

    $sql = "INSERT INTO ".MAIN_DB_PREFIX."prod_so_rules(entity,fk_ruleset,comp_ref,qty,pos,note,fk_user_creat,datec,active)";
    $sql.= " VALUES (".$conf->entity.", ".(int)$current_so_ruleset.", '".$db->escape($comp_ref)."', ".((float)$qty).", ".(int)$pos.", '".$db->escape($comp_note)."', ".(int)$user->id.", '".$db->idate(dol_now())."', 1)";
    if ($db->query($sql)) {
        setEventMessages($langs->trans('RecordSaved'), null, 'mesgs');
    } else {
        setEventMessages($db->lasterror(), null, 'errors');
    }
}

if ($action === 'delete_component' && $current_so_ruleset > 0) {
    $rid = (int) GETPOST('rid','int');
    if ($rid > 0) {
        $db->query("DELETE FROM ".MAIN_DB_PREFIX."prod_so_rules WHERE rowid=".(int)$rid." AND fk_ruleset=".(int)$current_so_ruleset);
        setEventMessages($langs->trans('RecordDeleted'), null, 'mesgs');
    }
}

function pr_get_components($db, $ruleset_id) {
    $out=array();
    if ($ruleset_id<=0) return $out;
    $sql="SELECT rowid, comp_ref, qty, pos, note FROM ".MAIN_DB_PREFIX."prod_so_rules";
    $sql.=" WHERE fk_ruleset=".(int)$ruleset_id." AND active=1 AND entity IN (".getEntity('prod_so_rules').")";
    $sql.=" ORDER BY pos ASC, rowid ASC";
    $res=$db->query($sql);
    if ($res) while($o=$db->fetch_object($res)) $out[]=$o;
    return $out;
}

$token = newToken();

llxHeader('', $langs->trans('Sales Order rules'));

print '<div class="titre">'.$langs->trans('Sales Order rules').'</div>';

print '<div class="fichecenter"><div class="fichehalfleft">';

print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
print '<input type="hidden" name="token" value="'.$token.'">';
print '<input type="hidden" name="action" value="create_so_ruleset">';
print '<table class="border centpercent">';
print '<tr><td class="titlefield">'.$langs->trans('New RuleSet ref').'</td><td><input type="text" name="new_so_ruleset_ref" value="" id="so_new_ruleset_ref"> <input class="button" type="submit" value="'.$langs->trans('Create').'"></td></tr>';
print '</table>';
print '</form>';

print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
print '<input type="hidden" name="token" value="'.$token.'">';
print '<input type="hidden" name="action" value="select_so_ruleset">';
print '<table class="border centpercent">';
print '<tr><td class="titlefield">'.$langs->trans('Rule set').'</td><td>';
print '<select name="so_ruleset_id" onchange="this.form.submit()">';
print '<option value="0">&nbsp;</option>';
foreach($soRulesets as $id=>$o){
    // Keep label clean (no debug suffixes)
    $label = $o->ref;
    if (!empty($o->creator_name)) {
        $label .= ' — ' . $o->creator_name;
    }
    $sel = ($id==$current_so_ruleset?' selected':'');
    print '<option value="'.$id.'"'.$sel.'>'.dol_escape_htmltag($label).'</option>';
}
print '</select>';
print '</td></tr>';

if ($current_so_ruleset > 0) {
    print '<tr><td>'.$langs->trans('Delete').'</td><td>';
	    print '<button type="submit" name="action" value="delete_so_ruleset" class="button button-cancel" onclick="return confirm(\''
	        . dol_escape_js($langs->trans('ConfirmDelete'))
	        . '\');">'.$langs->trans('Delete').'</button>';
    print '</td></tr>';
}
print '</table>';
print '</form>';

print '<hr>';

print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
print '<input type="hidden" name="token" value="'.$token.'">';
print '<input type="hidden" name="action" value="create_so_bom">';
print '<input type="hidden" name="so_ruleset_id" value="'.$current_so_ruleset.'">';

print '<table class="border centpercent">';
print '<tr><td class="titlefield">Customer</td><td>';
print $form->select_company($customer_id,'socid','',1,0,0,array(),0,'minwidth300');
print '</td></tr>';
print '<tr><td>Sell product ref (FG/SF)</td><td><input type="text" class="pr-autocomplete" name="sell_ref" value="'.dol_escape_htmltag($sell_ref).'" placeholder="FGxxxx or SFxxxx" id="so_sell_ref"></td></tr>';
print '<tr><td>Qty</td><td><input type="text" name="sell_qty" value="'.($sell_qty>0?(int)$sell_qty:1).'" size="6"></td></tr>';

print '<tr><td>Production RuleSet</td><td>';
$prSet = new ProdRuleSet($db);
$prSets = $prSet->fetchAllForUser($user);
print '<select name="prod_ruleset_id"><option value="0">&nbsp;</option>';
foreach($prSets as $id=>$o){
    $lab=$o->ref;
    if (!empty($o->creator_name)) {
        $lab .= ' — ' . $o->creator_name;
    }
    $sel=($id==$prod_ruleset_id?' selected':'');
    print '<option value="'.$id.'"'.$sel.'>'.dol_escape_htmltag($lab).'</option>';
}
print '</select>';
print '</td></tr>';

print '<tr><td>Material packs</td><td><input type="text" id="so_material_packs" class="pr-autocomplete" name="material" value="'.dol_escape_htmltag($material_packs).'" placeholder="62133, 61111"></td></tr>';
print '<tr><td>Job</td><td><input type="text" name="job_number" value="'.dol_escape_htmltag($job_number).'" size="10"></td></tr>';

print '</table>';
print '<div class="center" style="margin-top:10px">';
print '<input class="button button-save" type="submit" value="Generate SO + BOM">';
print '</div>';
print '</form>';

print '</div><div class="fichehalfright">';

print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
print '<input type="hidden" name="token" value="'.newToken().'">';
print '<input type="hidden" name="action" value="add_component">';
print '<input type="hidden" name="so_ruleset_id" value="'.$current_so_ruleset.'">';
print '<table class="border centpercent">';
print '<tr><td colspan="2"><b>Assembly list editor</b></td></tr>';
print '<tr><td class="titlefield">Component ref</td><td><input type="text" class="pr-autocomplete" name="comp_ref" value="" placeholder="FGxxxx / parts" id="so_comp_ref"></td></tr>';
print '<tr><td>Qty</td><td><input type="text" name="comp_qty" value="1" size="6" id="so_comp_qty"></td></tr>';
print '<tr><td>Comment</td><td><input type="text" name="comp_note" value="" size="30" id="so_comp_note"></td></tr>';
print '<tr><td colspan="2" class="center"><input class="button" type="submit" value="Add component"></td></tr>';
print '</table>';
print '</form>';

$comps = pr_get_components($db, $current_so_ruleset);

print '<div style="margin-top:10px">';
print '<b>Assembly flow</b><br>';
if (empty($current_so_ruleset)) {
    print '<span class="opacitymedium">Create or select a Sales Order RuleSet first.</span>';
} elseif (empty($comps)) {
    print '<span class="opacitymedium">No components yet.</span>';
} else {
    print '<div class="pr-flow-wrap">';
    $first=true;
    foreach($comps as $c){
        if (!$first) print ' <span class="pr-diag-arrow">→</span> ';
        $first=false;
        print '<span class="pr-node pr-node-fg">'.dol_escape_htmltag($c->comp_ref).'</span>';
    }
    print '</div>';

    print '<table class="noborder centpercent" style="margin-top:10px">';
    print '<tr class="liste_titre"><td>Ref</td><td class="right">Qty</td><td>Note</td><td class="right">Action</td></tr>';
    foreach($comps as $c){
        print '<tr class="oddeven">';
        print '<td>'.dol_escape_htmltag($c->comp_ref).'</td>';
        print '<td class="right">'.((float)$c->qty).'</td>';
        print '<td>'.dol_escape_htmltag($c->note).'</td>';
        print '<td class="right"><a class="butActionDelete" href="'.$_SERVER["PHP_SELF"].'?action=delete_component&token='.$token.'&so_ruleset_id='.$current_so_ruleset.'&rid='.$c->rowid.'">Del</a></td>';
        print '</tr>';
    }
    print '</table>';
}
print '</div>';

print '</div></div>';

// JS config + UI helpers (autocomplete)
// IMPORTANT: Use real newlines in JS output ("\n" expanded by PHP), not the literal characters "\\n".
print "<script type=\"text/javascript\">\n";
print "window.PR_CONFIG = window.PR_CONFIG || {};\n";
print "window.PR_CONFIG.urls = window.PR_CONFIG.urls || {};\n";
print "window.PR_CONFIG.urls.getProducts = \"".dol_buildpath('/custom/productionrules/ajax/getproducts.php', 1)."\";\n";
print '</script>'; 
print '<script src="'.dol_buildpath('/custom/productionrules/js/productionrules_ui.js', 1).'"></script>';

llxFooter();
$db->close();
