<?php
require '../../main.inc.php';

require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

if (empty($user->rights->planning->read)) accessforbidden();

$langs->loadLangs(array("main", "mrp"));

$action = GETPOST('action', 'aZ09');
$stationFilter = trim(GETPOST('station', 'alphanohtml'));
$statusFilter  = GETPOST('status', 'int'); // opcjonalnie

$pagetitle = "Planning";
llxHeader('', $pagetitle);

// ---- Pobranie danych (MO + extrafields + product)
global $db, $conf;

// ---- Load workstation dictionary (optional)
// If extrafield working_station stores an ID, we can display a human-friendly name.
// We try common Dolibarr tables/columns and fall back to the raw value if not found.
$workstationMap = array();
$wsTables = array(
    MAIN_DB_PREFIX.'workstation',
    MAIN_DB_PREFIX.'mrp_workstation'
);

foreach ($wsTables as $wsTable) {
    // Try a few common column combinations
    $tries = array(
        "SELECT rowid, ref, label FROM ".$wsTable,
        "SELECT rowid, ref, name  FROM ".$wsTable,
        "SELECT rowid, label      FROM ".$wsTable,
        "SELECT rowid, name       FROM ".$wsTable,
    );

    foreach ($tries as $q) {
        $resWs = $db->query($q);
        if ($resWs) {
            while ($ws = $db->fetch_object($resWs)) {
                $id = (string) $ws->rowid;
                $ref = isset($ws->ref) ? trim((string) $ws->ref) : '';
                $label = '';
                if (isset($ws->label)) $label = trim((string) $ws->label);
                if ($label === '' && isset($ws->name)) $label = trim((string) $ws->name);

                $display = $label;
                if ($ref !== '' && $label !== '') $display = $ref.' - '.$label;
                if ($display === '' && $ref !== '') $display = $ref;

                if ($display !== '') $workstationMap[$id] = $display;
            }
            // We successfully queried one table; no need to try other variants for this table.
            break;
        }
    }

    // If we loaded any workstation, stop here.
    if (!empty($workstationMap)) break;
}

$sql = "SELECT
            mo.rowid,
            mo.ref,
            mo.status,
            mo.qty,
            mo.fk_product,
            mo.date_start_planned,
            mo.date_end_planned,
            mo.date_start_planned,
            mo.date_end_planned,
            p.ref as prod_ref,
            p.label as prod_label,
            ef.job_number,
            ef.working_station
        FROM ".MAIN_DB_PREFIX."mrp_mo as mo
        LEFT JOIN ".MAIN_DB_PREFIX."mrp_mo_extrafields as ef ON ef.fk_object = mo.rowid
        LEFT JOIN ".MAIN_DB_PREFIX."product as p ON p.rowid = mo.fk_product
        WHERE mo.entity IN (".getEntity('mrp_mo').") ";

if ($stationFilter !== '') {
    $sql .= " AND ef.working_station = '".$db->escape($stationFilter)."' ";
}
if (!empty($statusFilter)) {
    $sql .= " AND mo.status = ".((int) $statusFilter)." ";
}

// sensowne sortowanie do “planning”
$sql .= " ORDER BY ef.working_station ASC, ef.job_number ASC, mo.date_start_planned ASC ";

$res = $db->query($sql);
if (!$res) {
    print '<div class="error">'.$db->lasterror().'</div>';
    llxFooter();
    exit;
}

// ---- Grupowanie po working_station
$stations = array();

while ($obj = $db->fetch_object($res)) {
    $station = trim((string) $obj->working_station);
    if ($station === '') $station = '(no working_station)';

    if (!isset($stations[$station])) $stations[$station] = array();

    // daty: planned vs made (jeśli masz realne wypełniane)
    $start = $obj->date_start_made ?: $obj->date_start_planned;
    $end   = $obj->date_end_made   ?: $obj->date_end_planned;

    $stations[$station][] = array(
        'rowid'      => (int) $obj->rowid,
        'ref'        => $obj->ref,
        'status'     => (int) $obj->status,
        'qty'        => $obj->qty,
        'job_number' => $obj->job_number,
        'prod_ref'   => $obj->prod_ref,
        'prod_label' => $obj->prod_label,
        'start'      => $start,
        'end'        => $end,
    );
}

// ---- Filtry (proste)
print '<div class="fichecenter">';
print '<form method="GET" action="'.dol_escape_htmltag($_SERVER["PHP_SELF"]).'">';
print '<div class="inline-block" style="margin-right:10px;">';
print '<label>Working station</label> ';
print '<input type="text" name="station" value="'.dol_escape_htmltag($stationFilter).'" class="minwidth200" />';
print '</div>';

print '<div class="inline-block" style="margin-right:10px;">';
print '<label>Status</label> ';
print '<input type="number" name="status" value="'.dol_escape_htmltag((string)$statusFilter).'" class="width75" />';
print '</div>';

print '<button class="butAction" type="submit">Filter</button>';
print '</form>';
print '</div>';

print '<div class="clearboth"></div><br>';

// ---- Render grup
foreach ($stations as $station => $jobs) {
    print '<div class="fiche">';

    // Nagłówek grupy
    $stationDisplay = $station;
    if ($station !== '' && $station !== '(no working_station)') {
        // Map numeric/string id to friendly name if available
        if (isset($workstationMap[$station])) {
            $stationDisplay = $workstationMap[$station];
        } elseif (ctype_digit((string) $station) && isset($workstationMap[(string) ((int) $station)])) {
            $stationDisplay = $workstationMap[(string) ((int) $station)];
        }
    }
    print '<div class="titre">'.$langs->trans("WorkingStation").': '.dol_escape_htmltag($stationDisplay).' ('.count($jobs).')</div>';

    print '<div class="div-table-responsive-no-min">';
    print '<table class="liste centpercent">';
    print '<tr class="liste_titre">';
    print '<th>Job #</th>';
    print '<th>MO</th>';
    print '<th>Product</th>';
    print '<th class="right">Qty</th>';
    print '<th>Start</th>';
    print '<th>End</th>';
    print '<th>Duration</th>';
    print '<th>Status</th>';
    print '</tr>';

    foreach ($jobs as $j) {
        $moUrl = DOL_URL_ROOT.'/mrp/mo_card.php?id='.$j['rowid'];

        $startTxt = $j['start'] ? dol_print_date($j['start'], 'dayhour') : '';
        $endTxt   = $j['end']   ? dol_print_date($j['end'], 'dayhour')   : '';

        $duration = '';
        if (!empty($j['start']) && !empty($j['end'])) {
            $seconds = ((int)$j['end']) - ((int)$j['start']);
            if ($seconds > 0) $duration = convertSecondToTime($seconds, 'allhourmin');
        }

        print '<tr>';
        print '<td>'.dol_escape_htmltag($j['job_number']).'</td>';
        print '<td><a href="'.dol_escape_htmltag($moUrl).'">'.dol_escape_htmltag($j['ref']).'</a></td>';
        print '<td>';
        print dol_escape_htmltag($j['prod_ref']);
        if (!empty($j['prod_label'])) print ' - '.dol_escape_htmltag($j['prod_label']);
        print '</td>';
        print '<td class="right">'.dol_escape_htmltag((string)$j['qty']).'</td>';
        print '<td>'.$startTxt.'</td>';
        print '<td>'.$endTxt.'</td>';
        print '<td>'.$duration.'</td>';
        print '<td class="nowrap">'.dol_escape_htmltag((string)$j['status']).'</td>';
        print '</tr>';
    }

    print '</table>';
    print '</div>';

    print '</div><br>';
}

llxFooter();
