<?php
require '../../main.inc.php';

require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

if (empty($user->rights->planning->read)) accessforbidden();

$langs->loadLangs(array("main", "mrp"));


// PLANNING_STATUS_MAP
// Match Dolibarr standard wording/colors for MRP/MO statuses
$statusMap = array(
  0 => array('label' => 'Draft',      'class' => 'pl-status-draft'),
  1 => array('label' => 'Validated',  'class' => 'pl-status-validated'),
  2 => array('label' => 'In progress','class' => 'pl-status-inprogress'),
  3 => array('label' => 'Produced',   'class' => 'pl-status-produced'),
  9 => array('label' => 'Cancelled',  'class' => 'pl-status-cancelled'),
);

$action = GETPOST('action', 'aZ09');
$view = 'completed';
$stationFilter = trim(GETPOST('station', 'alphanohtml'));
$statusFilterRaw = GETPOST('status', 'alphanohtml'); // optional
$showDraft = 0;
$statusFilter = ($statusFilterRaw === '' ? '' : (int) $statusFilterRaw);

$pagetitle = "Planning - Completed";
$arrayofcss = array('/custom/planning/css/planning.css');
llxHeader('', $pagetitle, '', '', 0, 0, array(), $arrayofcss);
print '<div class="planning-page">';

// ---- Planning table column alignment (keep columns aligned between working stations)
print '<style>';
print '.planning-table{table-layout:fixed;width:100%;}';
print '.pl-col-job{width:110px;}';
print '.pl-col-mo{width:140px;}';
print '.pl-col-product{width:auto;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;}';
print '.pl-col-qty{width:60px;text-align:right;}';
print '.pl-col-start{width:150px;}';
print '.pl-col-end{width:150px;}';
print '.pl-col-duration{width:110px;}';
print '.pl-col-status{width:120px;}';
print '</style>';

// ---- Status labels (MRP MO)
// Option C requested: 0=Draft, 1=Released, 2=In production, 3=Finished
$statusLabels = array(
    0 => 'Draft',
    1 => 'Released',
    2 => 'In production',
    3 => 'Finished',
);

// ---- Pobranie danych (MO + extrafields + product)
global $db, $conf;

// Build workstation name map (ID => label)
$wsNameById = array();
$wsTables = array(MAIN_DB_PREFIX.'workstation_workstation', MAIN_DB_PREFIX.'workstation', MAIN_DB_PREFIX.'mrp_workstation');
foreach ($wsTables as $wst) {
    // Detect table existence
    $chk = $db->query("SHOW TABLES LIKE '".$db->escape($wst)."'");
    if ($chk && $db->num_rows($chk) > 0) {
        $sqlws = "SELECT rowid, ref, label, NULL as name FROM ".$wst;
        $resws = $db->query($sqlws);
        if ($resws) {
            while ($w = $db->fetch_object($resws)) {
                $lbl = '';
                if (!empty($w->label)) $lbl = $w->label;
                elseif (!empty($w->name)) $lbl = $w->name;
                elseif (!empty($w->ref)) $lbl = $w->ref;
                if ($lbl !== '') $wsNameById[(string)$w->rowid] = $lbl;
            }
        }
        break; // use first existing table
    }
}

// Helper to display working station
function planning_station_label($raw, $wsNameById)
{
    $k = trim((string)$raw);
    if ($k === '') return '(no working_station)';
    if (ctype_digit($k) && isset($wsNameById[$k])) return $wsNameById[$k];
    return $k;
}



// Build list of available stations for combobox (JOIN to get LABEL; fallback to raw)
$availableStations = array(); // raw => label

// Detect workstation table using information_schema (avoids LIKE '_' wildcard issues)
$wsTable = '';
$candidates = array(MAIN_DB_PREFIX.'workstation_workstation', MAIN_DB_PREFIX.'mrp_workstation', MAIN_DB_PREFIX.'workstation');
foreach ($candidates as $cand) {
    $sqlchk = "SELECT 1 as ok FROM information_schema.TABLES
               WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = '".$db->escape($cand)."'";
    $reschk = $db->query($sqlchk);
    if ($reschk && ($objchk = $db->fetch_object($reschk)) && !empty($objchk->ok)) {
        $wsTable = $cand;
        break;
    }
}

// Always get distinct working stations from extrafields
$sqlst = "SELECT DISTINCT ef.working_station as ws_raw
          FROM ".MAIN_DB_PREFIX."mrp_mo mo
          LEFT JOIN ".MAIN_DB_PREFIX."mrp_mo_extrafields ef ON ef.fk_object = mo.rowid
          WHERE mo.entity IN (".getEntity('mrp_mo').")
            AND ef.working_station IS NOT NULL
            AND ef.working_station <> ''
          ORDER BY ef.working_station ASC";
$resst = $db->query($sqlst);
if ($resst) {
    $raws = array();
    while ($s = $db->fetch_object($resst)) {
        $raw = (string) $s->ws_raw;
        $raws[] = $raw;
    }

    // If workstation table exists, try to enrich labels in one query
    $labelsById = array();
    if (!empty($wsTable) && !empty($raws)) {
        $ids = array();
        foreach ($raws as $r) {
            if (ctype_digit((string)$r)) $ids[] = (int) $r;
        }
        $ids = array_values(array_unique($ids));
        if (!empty($ids)) {
            $sqlws = "SELECT rowid, COALESCE(label, name, ref) as ws_label
                      FROM ".$wsTable."
                      WHERE rowid IN (".implode(',', $ids).")";
            $resws = $db->query($sqlws);
            if ($resws) {
                while ($w = $db->fetch_object($resws)) {
                    if (!empty($w->ws_label)) $labelsById[(string)$w->rowid] = $w->ws_label;
                }
            }
        }
    }

    foreach ($raws as $raw) {
        $lbl = '';
        if (ctype_digit((string)$raw) && isset($labelsById[(string)$raw])) {
            $lbl = $labelsById[(string)$raw];
        } else {
            $lbl = planning_station_label($raw, $wsNameById);
        }
        $availableStations[(string)$raw] = $lbl;
    }

    // Sort by label for nicer combobox
    asort($availableStations, SORT_NATURAL | SORT_FLAG_CASE);
}


// Try mrp_workstation first, fallback to workstation
$wsTable = '';
$chk = $db->query("SHOW TABLES LIKE '".MAIN_DB_PREFIX."mrp_workstation'");
if ($chk && $db->num_rows($chk) > 0) {
    $wsTable = MAIN_DB_PREFIX.'mrp_workstation';
} else {
    $chk = $db->query("SHOW TABLES LIKE '".MAIN_DB_PREFIX."workstation'");
    if ($chk && $db->num_rows($chk) > 0) {
        $wsTable = MAIN_DB_PREFIX.'workstation';
    }
}

if (!empty($wsTable)) {
    $sqlst = "SELECT DISTINCT ef.working_station as ws_id,
                      COALESCE(w.label, w.name, w.ref) as ws_label
              FROM ".MAIN_DB_PREFIX."mrp_mo mo
              LEFT JOIN ".MAIN_DB_PREFIX."mrp_mo_extrafields ef ON ef.fk_object = mo.rowid
              LEFT JOIN ".$wsTable." w ON w.rowid = ef.working_station
              WHERE mo.entity IN (".getEntity('mrp_mo').")
                AND ef.working_station IS NOT NULL
                AND ef.working_station <> ''
              ORDER BY ws_label ASC";
    $resst = $db->query($sqlst);
    if ($resst) {
        while ($s = $db->fetch_object($resst)) {
            if (!empty($s->ws_label)) {
                $availableStations[(string)$s->ws_id] = $s->ws_label;
            }
        }
    }
}


// ---- Load workstation dictionary (optional)
// If extrafield working_station stores an ID, we can display a human-friendly name.
// We try common Dolibarr tables/columns and fall back to the raw value if not found.
$workstationMap = array();
$workstationRefMap = array();
$wsTables = array(MAIN_DB_PREFIX.'workstation_workstation', MAIN_DB_PREFIX.'workstation', MAIN_DB_PREFIX.'mrp_workstation');

foreach ($wsTables as $wsTable) {
    // Try a few common column combinations
    $tries = array(
        "SELECT rowid, ref, label FROM ".$wsTable,
        "SELECT rowid, ref, name  FROM ".$wsTable,
        "SELECT rowid, label      FROM ".$wsTable,
        "SELECT rowid, name       FROM ".$wsTable,
    );

    foreach ($tries as $q) {
        $resWs = $db->query($q);
        if ($resWs) {
            while ($ws = $db->fetch_object($resWs)) {
                $id = (string) $ws->rowid;
                $ref = isset($ws->ref) ? trim((string) $ws->ref) : '';
                $label = '';
                if (isset($ws->label)) $label = trim((string) $ws->label);
                if ($label === '' && isset($ws->name)) $label = trim((string) $ws->name);

                $display = $label;
                if ($ref !== '' && $label !== '') $display = $ref.' - '.$label;
                if ($display === '' && $ref !== '') $display = $ref;

                if ($display !== '') $workstationRefMap[$id] = $ref;
                $workstationMap[$id] = $display;
            }
            // We successfully queried one table; no need to try other variants for this table.
            break;
        }
    }

    // If we loaded any workstation, stop here.
    if (!empty($workstationMap)) break;
}

$sql = "SELECT
            mo.rowid,
            mo.ref,
            mo.status,
            mo.qty,
            (SELECT COALESCE(SUM(CASE WHEN sm.value > 0 THEN sm.value ELSE 0 END),0)
             FROM ".MAIN_DB_PREFIX."stock_mouvement sm
             WHERE sm.origintype IN ('mo','mrp_mo')
               AND sm.fk_origin = mo.rowid
               AND sm.type_mouvement IN (2,3)
            ) as qty_done,
            mo.fk_product,
            mo.date_start_planned,
            mo.date_end_planned,
            mo.date_start_planned,
            mo.date_end_planned,
            p.ref as prod_ref,
            p.label as prod_label,
            ef.job_number,
            ef.working_station
        FROM ".MAIN_DB_PREFIX."mrp_mo as mo
        LEFT JOIN ".MAIN_DB_PREFIX."mrp_mo_extrafields as ef ON ef.fk_object = mo.rowid
        LEFT JOIN ".MAIN_DB_PREFIX."product as p ON p.rowid = mo.fk_product
        WHERE mo.entity IN (".getEntity('mrp_mo').") ";

/* BASE_STATUS_FILTER */
// If user selected a specific status, we respect it. Otherwise apply view defaults.
if ($statusFilterRaw === '') {
    if ($view === 'live') {
        $sql .= " AND mo.status IN (1,2".($showDraft ? ",0" : "").") ";
    } elseif ($view === 'completed') {
        $sql .= " AND mo.status IN (3) ";
    }
}


if ($stationFilter !== '') {
    $sql .= " AND ef.working_station = '".$db->escape($stationFilter)."' ";
}
if ($statusFilterRaw !== '') {
    $sql .= " AND mo.status = ".((int) $statusFilter)." ";
}

// sensowne sortowanie do “planning”
$sql .= " ORDER BY ef.working_station ASC, ef.job_number ASC, mo.date_start_planned ASC ";

$res = $db->query($sql);
if (!$res) {
    print '<div class="error">'.$db->lasterror().'</div>';
    print '</div>'; // planning-page
llxFooter();
    exit;
}

// ---- Grupowanie po working_station
$stations = array();

while ($obj = $db->fetch_object($res)) {
    $station = trim((string) $obj->working_station);
    if ($station === '') $station = '(no working_station)';

    if (!isset($stations[$station])) $stations[$station] = array();

    // daty: planned vs made (jeśli masz realne wypełniane)
    $start = !empty($obj->date_start_made) ? $db->jdate($obj->date_start_made) : $db->jdate($obj->date_start_planned);
    $end   = !empty($obj->date_end_made)   ? $db->jdate($obj->date_end_made)   : $db->jdate($obj->date_end_planned);

    $stations[$station][] = array(
        'rowid'      => (int) $obj->rowid,
        'ref'        => $obj->ref,
        'status'     => (int) $obj->status,
        'qty'        => $obj->qty,
        'qty_done'   => $obj->qty_done,
        'job_number' => $obj->job_number,
        'prod_ref'   => $obj->prod_ref,
        'prod_label' => $obj->prod_label,
        'start'      => $start,
        'end'        => $end,
    );
}

// ---- Filtry (proste)
print '<div class="fichecenter">';
print '<form method="GET" action="'.dol_escape_htmltag($_SERVER["PHP_SELF"]).'">';
print '<div class="inline-block" style="margin-right:10px;">';
print '<label>Working station</label> ';
print '<select name="station" class="minwidth200">';
print '<option value="">'.$langs->trans("All").'</option>';
foreach ($availableStations as $raw => $lbl) {
  $sel = ($stationFilter !== '' && (string)$stationFilter === (string)$raw) ? ' selected' : '';
  $show = planning_station_label($raw, $wsNameById);
  print '<option value="'.dol_escape_htmltag($raw).'"'.$sel.'>'.dol_escape_htmltag($show).'</option>';
}
print '</select>';
print '</div>';

print '<div class="inline-block" style="margin-right:10px;">';
print '<label>Status</label> ';
print '<select name="status" class="minwidth150">';
print '<option value="">'.$langs->trans("All").'</option>';
$statusOptions = array(0=>'Draft (0)',1=>'Validated (1)',2=>'In progress (2)',3=>'Produced (3)',9=>'Cancelled (9)');
foreach ($statusOptions as $k => $lbl) {
  $sel = ($statusFilterRaw !== '' && (int)$statusFilter === (int)$k) ? ' selected' : '';
  print '<option value="'.((int)$k).'"'.$sel.'>'.dol_escape_htmltag($lbl).'</option>';
}
print '</select>';
print '</div>';

print '<button class="butAction" type="submit">Filter</button>';
print '</form>';
print '</div>';

print '<div class="clearboth"></div><br>';

// ---- Render grup
foreach ($stations as $station => $jobs) {
    print '<div class="fiche">';

    // Nagłówek grupy
    $stationDisplay = $station;
    if ($station !== '' && $station !== '(no working_station)') {
        // Map numeric/string id to friendly name if available
        if (isset($workstationMap[$station])) {
            $stationDisplay = $workstationMap[$station];
        } elseif (ctype_digit((string) $station) && isset($workstationMap[(string) ((int) $station)])) {
            $stationDisplay = $workstationMap[(string) ((int) $station)];
        }
    }
//    $wsRef = '';
    if ($station !== '' && ctype_digit((string)$station) && isset($workstationRefMap[(int)$station])) {
        $wsRef = $workstationRefMap[(int)$station];
    }
    if ($wsRef === '') {
        // fallback: try to extract ref from display "REF - Label" if available
        if (strpos($stationDisplay, ' - ') !== false) $wsRef = trim(dol_string_nospecial(strstr($stationDisplay, ' - ', true)));
    }
    if ($wsRef === '') $wsRef = $stationDisplay;
    print '<div class="titre">'.dol_escape_htmltag($wsRef).': Jobs ('.count($jobs).')</div>';
print '<div class="div-table-responsive-no-min">';
    print '<table class="liste centpercent planning-table">';
    print '<tr class="liste_titre">';
    print '<th class="pl-col-job">Job #</th>';
    print '<th class="pl-col-mo">MO</th>';
    print '<th class="pl-col-product">Product</th>';
    print '<th class="pl-col-qty right">Qty</th>';
    print '<th class="pl-col-qty right">Done</th>';
    print '<th class="pl-col-qty right">Left</th>';
    print '<th class="pl-col-start">Start</th>';
    print '<th class="pl-col-end">End</th>';
    print '<th class="pl-col-duration">Duration</th>';
    print '<th class="pl-col-status">Status</th>';
    print '</tr>';

    foreach ($jobs as $j) {
        $moUrl = DOL_URL_ROOT.'/mrp/mo_card.php?id='.$j['rowid'];

        $startTxt = $j['start'] ? dol_print_date($j['start'], 'dayhour') : '';
        $endTxt   = $j['end']   ? dol_print_date($j['end'], 'dayhour')   : '';

        $duration = '';
        if (!empty($j['start']) && !empty($j['end'])) {
            $seconds = ((int) $j['end']) - ((int) $j['start']);
            if ($seconds > 0) $duration = convertSecondToTime($seconds, 'allhourmin');
        } elseif (!empty($j['start']) && (int)$j['status'] === 2) {
            // In progress: show elapsed time since start
            $seconds = time() - ((int) $j['start']);
            if ($seconds > 0) $duration = convertSecondToTime($seconds, 'allhourmin');
        }


        print '<tr>';
        print '<td class="pl-col-job">'.dol_escape_htmltag($j['job_number']).'</td>';
        print '<td class="pl-col-mo"><a href="'.dol_escape_htmltag($moUrl).'">'.dol_escape_htmltag($j['ref']).'</a></td>';
        print '<td class="pl-col-product">';
        print dol_escape_htmltag($j['prod_ref']);
        if (!empty($j['prod_label'])) print ' - '.dol_escape_htmltag($j['prod_label']);
        print '</td>';
        $qty = (float) $j['qty'];
        $done = (float) $j['qty_done'];
        $left = max(0, $qty - $done);
        print '<td class="pl-col-qty right">'.dol_escape_htmltag((string)$qty).'</td>';
        print '<td class="pl-col-qty right">'.dol_escape_htmltag((string)$done).'</td>';
        print '<td class="pl-col-qty right">'.dol_escape_htmltag((string)$left).'</td>';
        print '<td class="pl-col-start">'.$startTxt.'</td>';
        print '<td class="pl-col-end">'.$endTxt.'</td>';
        print '<td class="pl-col-duration">'.$duration.'</td>';
        $statusCode = (int) $j['status'];
        if (isset($statusMap[$statusCode])) {
            $s = $statusMap[$statusCode];
            $statusHtml = '<span class="pl-status '.$s['class'].'">'.dol_escape_htmltag($s['label']).'</span>';
        } else {
            $statusHtml = '<span class="pl-status pl-status-unknown">Unknown ('.((int)$statusCode).')</span>';
        }
        print '<td class="pl-col-status nowrap">'.$statusHtml.'</td>';
        print '</tr>';
    }

    print '</table>';
    print '</div>';

    print '</div><br>';
}

print '</div>'; // planning-page
llxFooter();
