<?php
/* Copyright ...
 * Dolibarr module descriptor
 */

include_once DOL_DOCUMENT_ROOT.'/core/modules/DolibarrModules.class.php';

class modPlanning extends DolibarrModules
{
    public function __construct($db)
    {
        global $conf;

        $this->db = $db;

        $this->numero          = 999999; // ustaw coś wolnego
        $this->rights_class    = 'planning';
        $this->family          = "neos";  // możesz zmienić
        $this->name            = preg_replace('/^mod/i', '', get_class($this));
        $this->description     = "MO Planning view grouped by working station";
        $this->version         = '1.0.0';
        $this->picto           = 'calendar'; // ikona modułu (w managerze modułów)

        $this->module_parts = array(
            // 'triggers' => 1,
        );

        $this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
        $this->special    = 0;

        $this->dirs = array();

        $this->config_page_url = array();

        // Uprawnienia (proste)
        $this->rights = array();
        $r = 0;
        $this->rights[$r][0] = 9999991;
        $this->rights[$r][1] = 'Read planning';
        $this->rights[$r][4] = 'read';
        $this->rights[$r][5] = 1;
        $r++;

        $this->menu = array();

        // TOP MENU
        $this->menu[] = array(
            'fk_menu'  => 0,
            'type'     => 'top',
            'titre'    => 'Planning',
            'mainmenu' => 'planning',
            'leftmenu' => 'planning',
            'url'      => '/custom/planning/planning.php',
            'langs'    => '',
            'position' => 100,
            'enabled'  => '$conf->planning->enabled',
            'perms'    => '$user->rights->planning->read',
            'target'   => '',
            'user'     => 2,
            // FontAwesome w nowoczesnych motywach:
            'fk_mainmenu' => '',
            'fk_leftmenu' => '',
        );

        // LEFT MENU (opcjonalnie – jak klikniesz TOP, masz też lewą sekcję)
        $this->menu[] = array(
            'fk_menu'  => 'fk_mainmenu=planning',
            'type'     => 'left',
            'titre'    => 'Planning',
            'mainmenu' => 'planning',
            'leftmenu' => 'planning',
            'url'      => '/custom/planning/planning.php',
            'langs'    => '',
            'position' => 1,
            'enabled'  => '$conf->planning->enabled',
            'perms'    => '$user->rights->planning->read',
            'target'   => '',
            'user'     => 2,
        );


// LEFT MENU - Completed
$this->menu[] = array(
    'fk_menu'  => 'fk_mainmenu=planning',
    'type'     => 'left',
    'titre'    => 'Completed',
    'mainmenu' => 'planning',
    'leftmenu' => 'planning_completed',
    'url'      => '/custom/planning/completed.php',
    'langs'    => '',
    'position' => 2,
    'enabled'  => '$conf->planning->enabled',
    'perms'    => '$user->rights->planning->read',
    'target'   => '',
    'user'     => 2,
);

    }

    public function init($options = '')
    {
        return $this->_init(array(), $options);
    }

    public function remove($options = '')
    {
        return $this->_remove(array(), $options);
    }
}
