function plSetBoardTheme(){
  try{
    var fs = !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
    document.body.classList.toggle('pl-board-dark', fs);
    document.body.classList.toggle('pl-board-light', !fs);
  }catch(e){}
}

(function () {
  'use strict';

  function $(id) { return document.getElementById(id); }

  function isFullscreen() {
    return !!(document.fullscreenElement ||
              document.webkitFullscreenElement ||
              document.mozFullScreenElement ||
              document.msFullscreenElement);
  }

  function requestFullscreen(el) {
    const fn = el.requestFullscreen ||
               el.webkitRequestFullscreen ||
               el.mozRequestFullScreen ||
               el.msRequestFullscreen;
    if (fn) fn.call(el);
  }

  function exitFullscreen() {
    const fn = document.exitFullscreen ||
               document.webkitExitFullscreen ||
               document.mozCancelFullScreen ||
               document.msExitFullscreen;
    if (fn) fn.call(document);
  }

  // Custom tooltip for AJAX-rendered cards (board_data.php).
  // We do NOT try to re-init Dolibarr/TipTip here because on this page it doesn't reliably re-bind after DOM replace.
  let ajaxTTBound = false;
  let ajaxTTEl = null;
  let ajaxTTRoot = null;
  let ajaxTTActive = null;

  function getTooltipRoot(){
    return (isFullscreen() && (document.fullscreenElement || document.webkitFullscreenElement)) || document.body;
  }

  function ensureAjaxTooltipEl(){
    const root = getTooltipRoot();
    if (ajaxTTEl && ajaxTTRoot === root) return;
    // If root changed (enter/exit fullscreen), recreate tooltip container in the new root.
    if (ajaxTTEl && ajaxTTEl.parentNode) ajaxTTEl.parentNode.removeChild(ajaxTTEl);
    ajaxTTEl = document.createElement('div');
    ajaxTTEl.id = 'plAjaxTooltip';
    ajaxTTEl.className = 'pl-ajax-tooltip-box';
    ajaxTTEl.style.display = 'none';
    root.appendChild(ajaxTTEl);
    ajaxTTRoot = root;
  }

  function decodeB64Utf8(b64){
    try{
      const bin = atob(String(b64 || ''));
      const bytes = Uint8Array.from(bin, c => c.charCodeAt(0));
      return new TextDecoder('utf-8').decode(bytes);
    }catch(e){
      try{ return atob(String(b64 || '')); }catch(e2){ return ''; }
    }
  }

  function positionTooltip(clientX, clientY){
    if (!ajaxTTEl) return;
    const pad = 12;
    let x = clientX + pad;
    let y = clientY + pad;
    // Keep within viewport
    const rect = ajaxTTEl.getBoundingClientRect();
    const vw = window.innerWidth || document.documentElement.clientWidth;
    const vh = window.innerHeight || document.documentElement.clientHeight;
    if (x + rect.width + 8 > vw) x = Math.max(8, clientX - rect.width - pad);
    if (y + rect.height + 8 > vh) y = Math.max(8, clientY - rect.height - pad);
    ajaxTTEl.style.left = x + 'px';
    ajaxTTEl.style.top = y + 'px';
  }

  function showAjaxTooltip(el, evt){
    ensureAjaxTooltipEl();
    const payload = el.getAttribute('data-pl-tooltip');
    if (!payload) return;
    const html = decodeB64Utf8(payload);
    if (!html) return;
    ajaxTTEl.innerHTML = html;
    ajaxTTEl.style.display = 'block';
    ajaxTTActive = el;
    if (evt) positionTooltip(evt.clientX, evt.clientY);
  }

  function hideAjaxTooltip(){
    if (!ajaxTTEl) return;
    ajaxTTEl.style.display = 'none';
    ajaxTTEl.innerHTML = '';
    ajaxTTActive = null;
  }

  function initTooltips() {
    if (ajaxTTBound) return;
    ajaxTTBound = true;
    document.addEventListener('mouseover', function(e){
      const a = e.target && e.target.closest ? e.target.closest('a.pl-ajax-tooltip[data-pl-tooltip]') : null;
      if (!a) return;
      showAjaxTooltip(a, e);
    });
    document.addEventListener('mousemove', function(e){
      if (!ajaxTTEl || ajaxTTEl.style.display === 'none') return;
      positionTooltip(e.clientX, e.clientY);
    });
    document.addEventListener('mouseout', function(e){
      if (!ajaxTTActive) return;
      // If leaving the active element (or its children), hide.
      const rel = e.relatedTarget;
      if (rel && ajaxTTActive.contains && ajaxTTActive.contains(rel)) return;
      hideAjaxTooltip();
    });
  }

  let hideTimer = null;
let hotzoneEl = null;
function ensureHotzone(){
  if(hotzoneEl) return;
  hotzoneEl = document.createElement('div');
  hotzoneEl.id = 'plTopHotzone';
  document.body.appendChild(hotzoneEl);

  function reveal(){
    document.body.classList.remove('pl-top-hidden');
    scheduleHideTopbar();
  }

  hotzoneEl.addEventListener('mouseenter', reveal);
  hotzoneEl.addEventListener('mousemove', reveal);
  hotzoneEl.addEventListener('touchstart', reveal, {passive:true});

  document.addEventListener('mousemove', function(e){
    if(isFullscreen() && e.clientY <= 6) reveal();
  });
  document.addEventListener('touchstart', function(e){
    if(!isFullscreen()) return;
    const t = e.touches && e.touches[0];
    if(t && t.clientY <= 20) reveal();
  }, {passive:true});
}


  function scheduleHideTopbar() {
    clearTimeout(hideTimer);
    hideTimer = setTimeout(function () {
      if (isFullscreen()) document.body.classList.add('pl-top-hidden');
    }, 5000);
  }

  function onFullscreenChange() {
    plSetBoardTheme();
    
    try{ document.body.classList.toggle('pl-fullscreen', isFullscreen()); }catch(e){}
ensureHotzone();
    if (isFullscreen()) scheduleHideTopbar();
    else document.body.classList.remove('pl-top-hidden');
    initTooltips();
  }

  let refreshInterval = 0;
  let countdown = 0;
  let tickTimer = null;

  function startAutoRefresh() {
    const secEl = $('plRefreshSeconds');
    if (!secEl) return;
    refreshInterval = parseInt(secEl.textContent, 10) || 0;
    if (refreshInterval <= 0) return;

    countdown = refreshInterval;
    updateCountdown();

    clearInterval(tickTimer);
    tickTimer = setInterval(function () {
      countdown--;
      if (countdown <= 0) {
        countdown = refreshInterval;
        refreshBoard();
      }
      updateCountdown();
    }, 1000);
  }

  function updateCountdown() {
    const el = $('plRefreshCountdown');
    if (el) el.textContent = String(countdown);
  }

  function refreshBoard() {
    const candidates = [];
    try{ candidates.push(new URL('board_data.php', window.location.href).toString()); }catch(e){}

    const url = new URL(window.location.href);
    url.searchParams.set('ajax', '1');
    url.searchParams.set('_ts', Date.now());
    candidates.push(url.toString());

    function tryFetch(i){
      if(i>=candidates.length){
        const lu = $('plLastUpdate');
        if (lu) lu.textContent = 'Last update: ERROR';
        return;
      }
      fetch(candidates[i], { cache: 'no-store', credentials: 'same-origin' })
        .then(r => r.json())
        .then(data => {
          if (data && data.html) {
            const grid = $('plBoardGrid');
            if (grid) grid.outerHTML = data.html;
          }
          const lu = $('plLastUpdate');
          if (lu) lu.textContent = 'Last update: ' + (data.clock || data.server_time || '-');
          initTooltips();
        })
        .catch(() => tryFetch(i+1));
    }

    tryFetch(0);
    return;

    // legacy below

    url.searchParams.set('ajax', '1');
    url.searchParams.set('_ts', Date.now());

    }

  function init() {
  try{ document.body.classList.toggle('pl-fullscreen', isFullscreen()); }catch(e){}

    // ensure hotzone style
(function(){
  if(document.getElementById('plTopHotzoneStyle')) return;
  const st=document.createElement('style');
  st.id='plTopHotzoneStyle';
  st.textContent = '#plTopHotzone{position:fixed;top:0;left:0;right:0;height:14px;z-index:10050;} body:not(.pl-top-hidden) #plTopHotzone{display:none;}';
  document.head.appendChild(st);
})();

    ensureHotzone();
    initTooltips();
    startAutoRefresh();

    const fsBtn = $('plFullscreen');
    if (fsBtn) {
      fsBtn.addEventListener('click', function () {
        const page = $('plBoardPage') || document.documentElement;
        if (!isFullscreen()) requestFullscreen(page);
        else exitFullscreen();
      });
    }

    document.addEventListener('fullscreenchange', onFullscreenChange);
    document.addEventListener('webkitfullscreenchange', onFullscreenChange);
  }

  if (document.readyState === 'loading')
    document.addEventListener('DOMContentLoaded', function(){ plSetBoardTheme(); init(); });
  else init();
})();
