function plSetBoardTheme(){
  try{
    var fs = !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
    document.body.classList.toggle('pl-board-dark', fs);
    document.body.classList.toggle('pl-board-light', !fs);
  }catch(e){}
}

(function () {
  'use strict';

  function $(id) { return document.getElementById(id); }

  function isFullscreen() {
    return !!(document.fullscreenElement ||
              document.webkitFullscreenElement ||
              document.mozFullScreenElement ||
              document.msFullscreenElement);
  }

  function requestFullscreen(el) {
    const fn = el.requestFullscreen ||
               el.webkitRequestFullscreen ||
               el.mozRequestFullScreen ||
               el.msRequestFullscreen;
    if (fn) fn.call(el);
  }

  function exitFullscreen() {
    const fn = document.exitFullscreen ||
               document.webkitExitFullscreen ||
               document.mozCancelFullScreen ||
               document.msExitFullscreen;
    if (fn) fn.call(document);
  }

  function initTooltips() {
    const appendTarget = (isFullscreen() && (document.fullscreenElement || document.webkitFullscreenElement || document.documentElement)) || document.body;

    if (!window.jQuery || !jQuery.fn || !jQuery.fn.tooltip) return;

    const $default = jQuery('.classfortooltip').not('.pl-job-tooltip');
    if ($default.length) {
      $default.each(function(){
        try{
          var $el = jQuery(this);
          var inst = $el.tooltip('instance');
          if (inst) { $el.tooltip('destroy'); }
        }catch(e){}
      });
      $default.tooltip({ appendTo: appendTarget });
    }

    const $job = jQuery('.pl-job-tooltip.classfortooltip');
    if ($job.length) {
      $job.each(function(){
        try{
          var $el = jQuery(this);
          var inst = $el.tooltip('instance');
          if (inst) { $el.tooltip('destroy'); }
        }catch(e){}
      });
      $job.tooltip({
        content: function () {
          const t = jQuery(this).attr('title') || '';
          return String(t).replace(/\n|&#10;/g, '<br>');
        },
        position: { my: 'left top+15', at: 'left bottom', collision: 'flipfit' },
          appendTo: appendTarget
      });
    }
  }

  let hideTimer = null;
let hotzoneEl = null;
function ensureHotzone(){
  if(hotzoneEl) return;
  hotzoneEl = document.createElement('div');
  hotzoneEl.id = 'plTopHotzone';
  document.body.appendChild(hotzoneEl);

  function reveal(){
    document.body.classList.remove('pl-top-hidden');
    scheduleHideTopbar();
  }

  hotzoneEl.addEventListener('mouseenter', reveal);
  hotzoneEl.addEventListener('mousemove', reveal);
  hotzoneEl.addEventListener('touchstart', reveal, {passive:true});

  document.addEventListener('mousemove', function(e){
    if(isFullscreen() && e.clientY <= 6) reveal();
  });
  document.addEventListener('touchstart', function(e){
    if(!isFullscreen()) return;
    const t = e.touches && e.touches[0];
    if(t && t.clientY <= 20) reveal();
  }, {passive:true});
}


  function scheduleHideTopbar() {
    clearTimeout(hideTimer);
    hideTimer = setTimeout(function () {
      if (isFullscreen()) document.body.classList.add('pl-top-hidden');
    }, 5000);
  }

  function onFullscreenChange() {
    plSetBoardTheme();
    
    try{ document.body.classList.toggle('pl-fullscreen', isFullscreen()); }catch(e){}
ensureHotzone();
    if (isFullscreen()) scheduleHideTopbar();
    else document.body.classList.remove('pl-top-hidden');
    initTooltips();
  }

  let refreshInterval = 0;
  let countdown = 0;
  let tickTimer = null;

  function startAutoRefresh() {
    const secEl = $('plRefreshSeconds');
    if (!secEl) return;
    refreshInterval = parseInt(secEl.textContent, 10) || 0;
    if (refreshInterval <= 0) return;

    countdown = refreshInterval;
    updateCountdown();

    clearInterval(tickTimer);
    tickTimer = setInterval(function () {
      countdown--;
      if (countdown <= 0) {
        countdown = refreshInterval;
        refreshBoard();
      }
      updateCountdown();
    }, 1000);
  }

  function updateCountdown() {
    const el = $('plRefreshCountdown');
    if (el) el.textContent = String(countdown);
  }

  function refreshBoard() {
    const candidates = [];
    try{ candidates.push(new URL('board_data.php', window.location.href).toString()); }catch(e){}

    const url = new URL(window.location.href);
    url.searchParams.set('ajax', '1');
    url.searchParams.set('_ts', Date.now());
    candidates.push(url.toString());

    function tryFetch(i){
      if(i>=candidates.length){
        const lu = $('plLastUpdate');
        if (lu) lu.textContent = 'Last update: ERROR';
        return;
      }
      fetch(candidates[i], { cache: 'no-store', credentials: 'same-origin' })
        .then(r => r.json())
        .then(data => {
          if (data && data.html) {
            const grid = $('plBoardGrid');
            if (grid) grid.outerHTML = data.html;
          }
          const lu = $('plLastUpdate');
          if (lu) lu.textContent = 'Last update: ' + (data.clock || data.server_time || '-');
          initTooltips();
        })
        .catch(() => tryFetch(i+1));
    }

    tryFetch(0);
    return;

    // legacy below

    url.searchParams.set('ajax', '1');
    url.searchParams.set('_ts', Date.now());

    }

  function init() {
  try{ document.body.classList.toggle('pl-fullscreen', isFullscreen()); }catch(e){}

    // ensure hotzone style
(function(){
  if(document.getElementById('plTopHotzoneStyle')) return;
  const st=document.createElement('style');
  st.id='plTopHotzoneStyle';
  st.textContent = '#plTopHotzone{position:fixed;top:0;left:0;right:0;height:14px;z-index:10050;} body:not(.pl-top-hidden) #plTopHotzone{display:none;}';
  document.head.appendChild(st);
})();

    ensureHotzone();
    initTooltips();
    startAutoRefresh();

    const fsBtn = $('plFullscreen');
    if (fsBtn) {
      fsBtn.addEventListener('click', function () {
        const page = $('plBoardPage') || document.documentElement;
        if (!isFullscreen()) requestFullscreen(page);
        else exitFullscreen();
      });
    }

    document.addEventListener('fullscreenchange', onFullscreenChange);
    document.addEventListener('webkitfullscreenchange', onFullscreenChange);
  }

  if (document.readyState === 'loading')
    document.addEventListener('DOMContentLoaded', function(){ plSetBoardTheme(); init(); });
  else init();
})();
