function plSetBoardTheme(){
  try{
    var fs = !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
    document.body.classList.toggle('pl-board-dark', fs);
    document.body.classList.toggle('pl-board-light', !fs);
  }catch(e){}
}

(function () {
  'use strict';

  function $(id) { return document.getElementById(id); }

  function isFullscreen() {
    return !!(document.fullscreenElement ||
              document.webkitFullscreenElement ||
              document.mozFullScreenElement ||
              document.msFullscreenElement);
  }

  function requestFullscreen(el) {
    const fn = el.requestFullscreen ||
               el.webkitRequestFullscreen ||
               el.mozRequestFullScreen ||
               el.msRequestFullscreen;
    if (fn) fn.call(el);
  }

  function exitFullscreen() {
    const fn = document.exitFullscreen ||
               document.webkitExitFullscreen ||
               document.mozCancelFullScreen ||
               document.msExitFullscreen;
    if (fn) fn.call(document);
  }

  function initTooltips() {
    // 1) Preferred: TipTip (Dolibarr). This is the only way to get the same
    // tooltip rendering as a manual refresh (HTML with <br>, etc.).
    try {
      var jq = null;
      if (window.$j && window.$j.fn && window.$j.fn.tipTip) jq = window.$j;
      else if (window.jQuery && window.jQuery.fn && window.jQuery.fn.tipTip) jq = window.jQuery;
      if (jq) {
        jq(".tiptip_holder").remove();
        jq(".classfortooltip, .classfortooltipfixed, .pl-job-tooltip").tipTip({
          maxWidth: "auto",
          edgeOffset: 8,
          delay: 50,
          keepAlive: false
        });
        return;
      }
    } catch (e) {}

    // 2) Last resort fallback: lightweight HTML tooltip.
    // This is ONLY used if TipTip isn't available on the page after AJAX refresh.
    try {
      const nodes = document.querySelectorAll('.classfortooltip, .classfortooltipfixed, .pl-job-tooltip');
      if (!nodes || !nodes.length) return;

      // Create tooltip container once
      let tip = document.getElementById('plHtmlTooltip');
      if (!tip) {
        tip = document.createElement('div');
        tip.id = 'plHtmlTooltip';
        tip.style.position = 'fixed';
        tip.style.zIndex = '10080';
        tip.style.display = 'none';
        tip.style.maxWidth = '520px';
        tip.style.padding = '8px 10px';
        tip.style.borderRadius = '8px';
        tip.style.boxShadow = '0 6px 20px rgba(0,0,0,.25)';
        tip.style.fontSize = '12px';
        tip.style.lineHeight = '1.25';
        tip.style.pointerEvents = 'none';
        // Theme-aware background
        tip.style.background = 'rgba(30,30,30,.92)';
        tip.style.color = '#fff';
        document.body.appendChild(tip);
      }

      function getHtml(el) {
        return el.getAttribute('data-pl-tt')
          || el.getAttribute('data-original-title')
          || el.getAttribute('title')
          || '';
      }

      function storeAndDisableNative(el) {
        if (el.getAttribute('data-pl-tt')) return;
        const html = getHtml(el);
        if (!html) return;
        el.setAttribute('data-pl-tt', html);
        // Prevent native browser tooltip
        if (el.hasAttribute('title')) el.removeAttribute('title');
      }

      function showTip(el, ev) {
        const html = getHtml(el);
        if (!html) return;
        tip.innerHTML = html;
        tip.style.display = 'block';
        moveTip(ev);
      }

      function hideTip() {
        tip.style.display = 'none';
      }

      function moveTip(ev) {
        const pad = 12;
        const vw = window.innerWidth;
        const vh = window.innerHeight;
        const rect = tip.getBoundingClientRect();
        let x = ev.clientX + pad;
        let y = ev.clientY + pad;
        if (x + rect.width + pad > vw) x = Math.max(pad, vw - rect.width - pad);
        if (y + rect.height + pad > vh) y = Math.max(pad, vh - rect.height - pad);
        tip.style.left = x + 'px';
        tip.style.top = y + 'px';
      }

      nodes.forEach(function (el) {
        storeAndDisableNative(el);
        if (el.getAttribute('data-pl-tt-bound')) return;
        el.setAttribute('data-pl-tt-bound', '1');
        el.addEventListener('mouseenter', function (ev) { showTip(el, ev); });
        el.addEventListener('mousemove', function (ev) { moveTip(ev); });
        el.addEventListener('mouseleave', function () { hideTip(); });
      });
    } catch (e) {}
  }

  let hideTimer = null;
let hotzoneEl = null;
function ensureHotzone(){
  if(hotzoneEl) return;
  hotzoneEl = document.createElement('div');
  hotzoneEl.id = 'plTopHotzone';
  document.body.appendChild(hotzoneEl);

  function reveal(){
    document.body.classList.remove('pl-top-hidden');
    scheduleHideTopbar();
  }

  hotzoneEl.addEventListener('mouseenter', reveal);
  hotzoneEl.addEventListener('mousemove', reveal);
  hotzoneEl.addEventListener('touchstart', reveal, {passive:true});

  document.addEventListener('mousemove', function(e){
    if(isFullscreen() && e.clientY <= 6) reveal();
  });
  document.addEventListener('touchstart', function(e){
    if(!isFullscreen()) return;
    const t = e.touches && e.touches[0];
    if(t && t.clientY <= 20) reveal();
  }, {passive:true});
}


  function scheduleHideTopbar() {
    clearTimeout(hideTimer);
    hideTimer = setTimeout(function () {
      if (isFullscreen()) document.body.classList.add('pl-top-hidden');
    }, 5000);
  }

  function onFullscreenChange() {
    plSetBoardTheme();
    
    try{ document.body.classList.toggle('pl-fullscreen', isFullscreen()); }catch(e){}
ensureHotzone();
    if (isFullscreen()) scheduleHideTopbar();
    else document.body.classList.remove('pl-top-hidden');
    initTooltips();
  }

  let refreshInterval = 0;
  let countdown = 0;
  let tickTimer = null;

  function startAutoRefresh() {
    const secEl = $('plRefreshSeconds');
    if (!secEl) return;
    refreshInterval = parseInt(secEl.textContent, 10) || 0;
    if (refreshInterval <= 0) return;

    countdown = refreshInterval;
    updateCountdown();

    clearInterval(tickTimer);
    tickTimer = setInterval(function () {
      countdown--;
      if (countdown <= 0) {
        countdown = refreshInterval;
        refreshBoard();
      }
      updateCountdown();
    }, 1000);
  }

  function updateCountdown() {
    const el = $('plRefreshCountdown');
    if (el) el.textContent = String(countdown);
  }

  function refreshBoard() {
    // Fetch from the same page renderer (ajax=1) so the HTML/tooltip markup
    // is identical to a full manual refresh.
    const url = new URL(window.location.href);
    url.searchParams.set('ajax', '1');
    url.searchParams.set('_ts', Date.now());

    fetch(url.toString(), { cache: 'no-store', credentials: 'same-origin' })
      .then(r => r.json())
      .then(data => {
        if (data && data.html) {
          const grid = $('plBoardGrid');
          if (grid) grid.outerHTML = data.html;
        }
        const lu = $('plLastUpdate');
        if (lu) lu.textContent = 'Last update: ' + (data.clock || data.server_time || '-');
        setTimeout(initTooltips, 0);
      })
      .catch(() => {
        const lu = $('plLastUpdate');
        if (lu) lu.textContent = 'Last update: ERROR';
      });
  }

  function init() {
  try{ document.body.classList.toggle('pl-fullscreen', isFullscreen()); }catch(e){}

    // ensure hotzone style
(function(){
  if(document.getElementById('plTopHotzoneStyle')) return;
  const st=document.createElement('style');
  st.id='plTopHotzoneStyle';
  st.textContent = '#plTopHotzone{position:fixed;top:0;left:0;right:0;height:14px;z-index:10050;} body:not(.pl-top-hidden) #plTopHotzone{display:none;}';
  document.head.appendChild(st);
})();

    ensureHotzone();
    initTooltips();
    startAutoRefresh();

    const fsBtn = $('plFullscreen');
    if (fsBtn) {
      fsBtn.addEventListener('click', function () {
        const page = $('plBoardPage') || document.documentElement;
        if (!isFullscreen()) requestFullscreen(page);
        else exitFullscreen();
      });
    }

    document.addEventListener('fullscreenchange', onFullscreenChange);
    document.addEventListener('webkitfullscreenchange', onFullscreenChange);
  }

  if (document.readyState === 'loading')
    document.addEventListener('DOMContentLoaded', function(){ plSetBoardTheme(); init(); });
  else init();
})();
