function plSetBoardTheme(){
  try{
    var fs = !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
    document.body.classList.toggle('pl-board-dark', fs);
    document.body.classList.toggle('pl-board-light', !fs);
  }catch(e){}
}

(function () {
  'use strict';

  function $(id) { return document.getElementById(id); }

  function isFullscreen() {
    return !!(document.fullscreenElement ||
              document.webkitFullscreenElement ||
              document.mozFullScreenElement ||
              document.msFullscreenElement);
  }

  function requestFullscreen(el) {
    const fn = el.requestFullscreen ||
               el.webkitRequestFullscreen ||
               el.mozRequestFullScreen ||
               el.msRequestFullscreen;
    if (fn) fn.call(el);
  }

  function exitFullscreen() {
    const fn = document.exitFullscreen ||
               document.webkitExitFullscreen ||
               document.mozCancelFullScreen ||
               document.msExitFullscreen;
    if (fn) fn.call(document);
  }

  function initTooltips() {
    try {
      // Best: let Dolibarr initialize tooltips exactly like a full page load.
      if (typeof window.dol_init_tooltip === 'function') {
        window.dol_init_tooltip();
        return;
      }
    } catch (e) {}

    try {
      // Fallback: initialize TipTip directly (same CSS/markup as Dolibarr).
      var jq = null;
      if (window.$j && window.$j.fn && window.$j.fn.tipTip) jq = window.$j;
      else if (window.jQuery && window.jQuery.fn && window.jQuery.fn.tipTip) jq = window.jQuery;
      if (!jq) return;

      jq('.tiptip_holder').remove();
      jq('.classfortooltip, .classfortooltipfixed, .pl-job-tooltip').tipTip({
        maxWidth: 'auto',
        edgeOffset: 8,
        delay: 50,
        keepAlive: false
      });
    } catch (e) {}
  }

  function initAjaxTooltips() {
    try {
      var jq = null;
      if (window.$j && window.$j.fn) jq = window.$j;
      else if (window.jQuery && window.jQuery.fn) jq = window.jQuery;
      if (!jq) return;

      // Delegate handler so it survives DOM replacements on auto-refresh.
      jq(document)
        .off('mouseenter.pl_ajaxtt', 'a.classforajaxtooltip')
        .on('mouseenter.pl_ajaxtt', 'a.classforajaxtooltip', function () {
          var a = this;
          try {
            if (a.getAttribute('data-pl-ttloaded') === '1') return;

            // Remove placeholder title like "tocomplete" that becomes a native browser tooltip.
            a.setAttribute('title', '');

            var paramsRaw = a.getAttribute('data-params') || '{}';
            var params = {};
            try { params = JSON.parse(paramsRaw); } catch (e) { params = {}; }
            if (!params || typeof params !== 'object') params = {};

            // CSRF token is required by Dolibarr for ajax endpoints.
            function getDolToken() {
              try {
                if (typeof token !== 'undefined' && token) return String(token);
              } catch (e) {}
              try {
                if (window.DOL_TOKEN) return String(window.DOL_TOKEN);
                if (window.dolibarrToken) return String(window.dolibarrToken);
              } catch (e) {}
              try {
                var inp = document.querySelector('input[name="token"]');
                if (inp && inp.value) return String(inp.value);
              } catch (e) {}
              try {
                var meta = document.querySelector('meta[name="anti-csrf-newtoken"],meta[name="anti-csrf-token"]');
                if (meta && meta.content) return String(meta.content);
              } catch (e) {}
              return '';
            }

            // Dolibarr core endpoint for ajax tooltips.
            var url = '/core/ajax/ajaxtooltip.php';
            var usp = new URLSearchParams();
            Object.keys(params).forEach(function (k) {
              if (params[k] === null || typeof params[k] === 'undefined') return;
              usp.append(k, String(params[k]));
            });

            // Dolibarr expects an action and CSRF token.
            if (!usp.has('action')) usp.append('action', 'fetch');
            var t = getDolToken();
            if (t && !usp.has('token')) usp.append('token', t);

            fetch(url, {
              method: 'POST',
              headers: { 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8' },
              body: usp.toString(),
              credentials: 'same-origin',
              cache: 'no-store'
            })
              .then(function (r) { return r.text(); })
              .then(function (txt) {
                // Dolibarr may return JSON or raw HTML. Try JSON first.
                var html = txt;
                try {
                  var o = JSON.parse(txt);
                  if (o && (o.value || o.html)) html = o.value || o.html;
                } catch (e) {}

                if (!html) return;

                // Do not put HTML into the title attribute (browser tooltip will show raw tags).
                // Keep title empty and feed HTML directly into TipTip content.
                a.setAttribute('title', '');
                a.setAttribute('data-pl-ttloaded', '1');

                var jqq = (window.$j && window.$j.fn && window.$j.fn.tipTip) ? window.$j
                          : (window.jQuery && window.jQuery.fn && window.jQuery.fn.tipTip) ? window.jQuery
                          : null;
                if (jqq) {
                  // Remove any previous handler/instance on this element then attach with HTML content.
                  try { jqq(a).data('tiptip', null); } catch (e) {}
                  jqq(a).tipTip({
                    content: html,
                    maxWidth: 'auto',
                    edgeOffset: 8,
                    delay: 50,
                    keepAlive: false
                  });
                  jqq(a).trigger('mouseenter');
                }
              })
              .catch(function () { /* ignore */ });
          } catch (e) { /* ignore */ }
        });
    } catch (e) { /* ignore */ }
  }

  let hideTimer = null;
let hotzoneEl = null;
function ensureHotzone(){
  if(hotzoneEl) return;
  hotzoneEl = document.createElement('div');
  hotzoneEl.id = 'plTopHotzone';
  document.body.appendChild(hotzoneEl);

  function reveal(){
    document.body.classList.remove('pl-top-hidden');
    scheduleHideTopbar();
  }

  hotzoneEl.addEventListener('mouseenter', reveal);
  hotzoneEl.addEventListener('mousemove', reveal);
  hotzoneEl.addEventListener('touchstart', reveal, {passive:true});

  document.addEventListener('mousemove', function(e){
    if(isFullscreen() && e.clientY <= 6) reveal();
  });
  document.addEventListener('touchstart', function(e){
    if(!isFullscreen()) return;
    const t = e.touches && e.touches[0];
    if(t && t.clientY <= 20) reveal();
  }, {passive:true});
}


  function scheduleHideTopbar() {
    clearTimeout(hideTimer);
    hideTimer = setTimeout(function () {
      if (isFullscreen()) document.body.classList.add('pl-top-hidden');
    }, 5000);
  }

  function onFullscreenChange() {
    plSetBoardTheme();
    
    try{ document.body.classList.toggle('pl-fullscreen', isFullscreen()); }catch(e){}
ensureHotzone();
    if (isFullscreen()) scheduleHideTopbar();
    else document.body.classList.remove('pl-top-hidden');
    initTooltips();
    initAjaxTooltips();
  }

  let refreshInterval = 0;
  let countdown = 0;
  let tickTimer = null;

  function startAutoRefresh() {
    const secEl = $('plRefreshSeconds');
    if (!secEl) return;
    refreshInterval = parseInt(secEl.textContent, 10) || 0;
    if (refreshInterval <= 0) return;

    countdown = refreshInterval;
    updateCountdown();

    clearInterval(tickTimer);
    tickTimer = setInterval(function () {
      countdown--;
      if (countdown <= 0) {
        countdown = refreshInterval;
        refreshBoard();
      }
      updateCountdown();
    }, 1000);
  }

  function updateCountdown() {
    const el = $('plRefreshCountdown');
    if (el) el.textContent = String(countdown);
  }

  function refreshBoard() {
    // Fetch from the same page renderer (ajax=1) so the HTML/tooltip markup
    // is identical to a full manual refresh.
    const url = new URL(window.location.href);
    url.searchParams.set('ajax', '1');
    url.searchParams.set('_ts', Date.now());

    fetch(url.toString(), { cache: 'no-store', credentials: 'same-origin' })
      .then(r => r.json())
      .then(data => {
        if (data && data.html) {
          const grid = $('plBoardGrid');
          if (grid) grid.outerHTML = data.html;
        }
        const lu = $('plLastUpdate');
        if (lu) lu.textContent = 'Last update: ' + (data.clock || data.server_time || '-');
        setTimeout(function(){ initTooltips(); initAjaxTooltips(); }, 0);
      })
      .catch(() => {
        const lu = $('plLastUpdate');
        if (lu) lu.textContent = 'Last update: ERROR';
      });
  }

  function init() {
  try{ document.body.classList.toggle('pl-fullscreen', isFullscreen()); }catch(e){}

    // ensure hotzone style
(function(){
  if(document.getElementById('plTopHotzoneStyle')) return;
  const st=document.createElement('style');
  st.id='plTopHotzoneStyle';
  st.textContent = '#plTopHotzone{position:fixed;top:0;left:0;right:0;height:14px;z-index:10050;} body:not(.pl-top-hidden) #plTopHotzone{display:none;}';
  document.head.appendChild(st);
})();

    ensureHotzone();
    initTooltips();
    initAjaxTooltips();
    startAutoRefresh();

    const fsBtn = $('plFullscreen');
    if (fsBtn) {
      fsBtn.addEventListener('click', function () {
        const page = $('plBoardPage') || document.documentElement;
        if (!isFullscreen()) requestFullscreen(page);
        else exitFullscreen();
      });
    }

    document.addEventListener('fullscreenchange', onFullscreenChange);
    document.addEventListener('webkitfullscreenchange', onFullscreenChange);
  }

  if (document.readyState === 'loading')
    document.addEventListener('DOMContentLoaded', function(){ plSetBoardTheme(); init(); });
  else init();
})();
