function plSetBoardTheme(){
  try{
    var fs = !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
    document.body.classList.toggle('pl-board-dark', fs);
    document.body.classList.toggle('pl-board-light', !fs);
  }catch(e){}
}

(function () {
  'use strict';

  function $(id) { return document.getElementById(id); }

  function isFullscreen() {
    return !!(document.fullscreenElement ||
              document.webkitFullscreenElement ||
              document.mozFullScreenElement ||
              document.msFullscreenElement);
  }

  function requestFullscreen(el) {
    const fn = el.requestFullscreen ||
               el.webkitRequestFullscreen ||
               el.mozRequestFullScreen ||
               el.msRequestFullscreen;
    if (fn) fn.call(el);
  }

  function exitFullscreen() {
    const fn = document.exitFullscreen ||
               document.webkitExitFullscreen ||
               document.mozCancelFullScreen ||
               document.msExitFullscreen;
    if (fn) fn.call(document);
  }

  function initTooltips() {
    // Use Dolibarr's own tooltip system (TipTip) so HTML (<br>, icons, etc.)
    // behaves the same after AJAX refresh as on a full page load.
    try {
      if (typeof window.dol_init_tooltip === 'function') {
        window.dol_init_tooltip();
        return;
      }
      if (typeof window.dol_init_tooltip_onmouseover === 'function') {
        window.dol_init_tooltip_onmouseover();
        return;
      }
      if (typeof window.initTipTip === 'function') {
        window.initTipTip();
        return;
      }
    } catch (e) {}

    // Fallback: initialize TipTip directly if present
    try {
      if (window.jQuery && jQuery.fn && jQuery.fn.tipTip) {
        // remove any orphan holders from previous DOM
        jQuery('.tiptip_holder').remove();
        jQuery('.classfortooltip').tipTip({ maxWidth: 'auto', edgeOffset: 8, delay: 50 });
      }
    } catch (e) {}
  }

  let hideTimer = null;
let hotzoneEl = null;
function ensureHotzone(){
  if(hotzoneEl) return;
  hotzoneEl = document.createElement('div');
  hotzoneEl.id = 'plTopHotzone';
  document.body.appendChild(hotzoneEl);

  function reveal(){
    document.body.classList.remove('pl-top-hidden');
    scheduleHideTopbar();
  }

  hotzoneEl.addEventListener('mouseenter', reveal);
  hotzoneEl.addEventListener('mousemove', reveal);
  hotzoneEl.addEventListener('touchstart', reveal, {passive:true});

  document.addEventListener('mousemove', function(e){
    if(isFullscreen() && e.clientY <= 6) reveal();
  });
  document.addEventListener('touchstart', function(e){
    if(!isFullscreen()) return;
    const t = e.touches && e.touches[0];
    if(t && t.clientY <= 20) reveal();
  }, {passive:true});
}


  function scheduleHideTopbar() {
    clearTimeout(hideTimer);
    hideTimer = setTimeout(function () {
      if (isFullscreen()) document.body.classList.add('pl-top-hidden');
    }, 5000);
  }

  function onFullscreenChange() {
    plSetBoardTheme();
    
    try{ document.body.classList.toggle('pl-fullscreen', isFullscreen()); }catch(e){}
ensureHotzone();
    if (isFullscreen()) scheduleHideTopbar();
    else document.body.classList.remove('pl-top-hidden');
    initTooltips();
  }

  let refreshInterval = 0;
  let countdown = 0;
  let tickTimer = null;

  function startAutoRefresh() {
    const secEl = $('plRefreshSeconds');
    if (!secEl) return;
    refreshInterval = parseInt(secEl.textContent, 10) || 0;
    if (refreshInterval <= 0) return;

    countdown = refreshInterval;
    updateCountdown();

    clearInterval(tickTimer);
    tickTimer = setInterval(function () {
      countdown--;
      if (countdown <= 0) {
        countdown = refreshInterval;
        refreshBoard();
      }
      updateCountdown();
    }, 1000);
  }

  function updateCountdown() {
    const el = $('plRefreshCountdown');
    if (el) el.textContent = String(countdown);
  }

  function refreshBoard() {
    // Fetch from the same page renderer (ajax=1) so the HTML/tooltip markup
    // is identical to a full manual refresh.
    const url = new URL(window.location.href);
    url.searchParams.set('ajax', '1');
    url.searchParams.set('_ts', Date.now());

    fetch(url.toString(), { cache: 'no-store', credentials: 'same-origin' })
      .then(r => r.json())
      .then(data => {
        if (data && data.html) {
          const grid = $('plBoardGrid');
          if (grid) grid.outerHTML = data.html;
        }
        const lu = $('plLastUpdate');
        if (lu) lu.textContent = 'Last update: ' + (data.clock || data.server_time || '-');
        setTimeout(initTooltips, 0);
      })
      .catch(() => {
        const lu = $('plLastUpdate');
        if (lu) lu.textContent = 'Last update: ERROR';
      });
  }

  function init() {
  try{ document.body.classList.toggle('pl-fullscreen', isFullscreen()); }catch(e){}

    // ensure hotzone style
(function(){
  if(document.getElementById('plTopHotzoneStyle')) return;
  const st=document.createElement('style');
  st.id='plTopHotzoneStyle';
  st.textContent = '#plTopHotzone{position:fixed;top:0;left:0;right:0;height:14px;z-index:10050;} body:not(.pl-top-hidden) #plTopHotzone{display:none;}';
  document.head.appendChild(st);
})();

    ensureHotzone();
    initTooltips();
    startAutoRefresh();

    const fsBtn = $('plFullscreen');
    if (fsBtn) {
      fsBtn.addEventListener('click', function () {
        const page = $('plBoardPage') || document.documentElement;
        if (!isFullscreen()) requestFullscreen(page);
        else exitFullscreen();
      });
    }

    document.addEventListener('fullscreenchange', onFullscreenChange);
    document.addEventListener('webkitfullscreenchange', onFullscreenChange);
  }

  if (document.readyState === 'loading')
    document.addEventListener('DOMContentLoaded', function(){ plSetBoardTheme(); init(); });
  else init();
})();
