<?php
// Planning Board - JSON data endpoint (no HTML wrapper)
define('NOREQUIREMENU', 1);
define('NOREQUIRETOP', 1);
define('NOREQUIREAJAX', 1);
define('NOREQUIREHTML', 1);

require '../../main.inc.php';

require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/mrp/class/mo.class.php';


header('Content-Type: application/json; charset=utf-8');

if (empty($user->rights->planning) || empty($user->rights->planning->read)) {
    http_response_code(403);
    print json_encode(array('error' => 'forbidden'));
    exit;
}

$stationFilter = trim(GETPOST('station', 'alphanohtml'));
$showDraft = (int) GETPOST('showdraft', 'int');

// Workstation maps (rowid -> ref/label)
$workstationMap = array();
$workstationRefMap = array();
$sqlws = "SELECT rowid, ref, label FROM ".MAIN_DB_PREFIX."workstation_workstation WHERE entity IN (".getEntity('workstation_workstation').")";
$resws = $db->query($sqlws);
if ($resws) {
    while ($o = $db->fetch_object($resws)) {
        $workstationMap[(int)$o->rowid] = $o->label;
        $workstationRefMap[(int)$o->rowid] = $o->ref;
    }
}

function ws_ref_label($raw, $workstationRefMap, $workstationMap) {
    $k = trim((string)$raw);
    if ($k === '' || $k === '(none)') return $k === '' ? '(none)' : $k;
    if (preg_match('/^[0-9]+$/', $k)) {
        $id = (int)$k;
        $ref = isset($workstationRefMap[$id]) ? $workstationRefMap[$id] : $k;
        $lbl = isset($workstationMap[$id]) ? $workstationMap[$id] : '';
        if ($lbl !== '') return $lbl;
        return $ref;
    }
    return $k;
}

function status_badge($status) {
    $map = array(
        0 => array('Draft','pl-status-draft'),
        1 => array('Validated','pl-status-validated'),
        2 => array('In progress','pl-status-inprogress'),
        3 => array('Produced','pl-status-produced'),
        9 => array('Cancelled','pl-status-cancelled'),
    );
    if (!isset($map[$status])) return '<span class="pl-status pl-status-unknown">?</span>';
    return '<span class="pl-status '.$map[$status][1].'">'.$map[$status][0].'</span>';
}

// Main SQL (Validated + In progress + optional Draft)
$sql = "SELECT
            mo.rowid,
            mo.ref,
            mo.status,
            mo.qty,
            mo.fk_product,
            mo.date_start_planned,
            mo.date_end_planned,
            (SELECT COALESCE(SUM(CASE WHEN sm.value > 0 THEN sm.value ELSE 0 END),0)
             FROM ".MAIN_DB_PREFIX."stock_mouvement sm
             WHERE sm.origintype IN ('mo','mrp_mo')
               AND sm.fk_origin = mo.rowid
               AND sm.type_mouvement IN (2,3)
            ) as qty_done,
            p.ref as prod_ref,
            p.label as prod_label,
            ef.job_number,
            ef.working_station,
            mo.fk_bom,
            b.note_public as bom_note_public
        FROM ".MAIN_DB_PREFIX."mrp_mo as mo
        LEFT JOIN ".MAIN_DB_PREFIX."mrp_mo_extrafields as ef ON ef.fk_object = mo.rowid
        LEFT JOIN ".MAIN_DB_PREFIX."product as p ON p.rowid = mo.fk_product
        LEFT JOIN ".MAIN_DB_PREFIX."bom_bom as b ON b.rowid = mo.fk_bom
        WHERE mo.entity IN (".getEntity('mrp_mo').")
          AND mo.status IN (1,2".($showDraft ? ",0" : "").")";

if ($stationFilter !== '') {
    $sql .= " AND ef.working_station = '".$db->escape($stationFilter)."' ";
}

$sql .= " ORDER BY ef.working_station ASC, mo.date_start_planned ASC, mo.ref ASC";

$res = $db->query($sql);
if (!$res) {
    http_response_code(500);
    print json_encode(array('error' => $db->lasterror()));
    exit;
}

$stations = array();
while ($obj = $db->fetch_object($res)) {
    $wsKey = trim((string) $obj->working_station);
    if ($wsKey === '') $wsKey = '(none)';
    if (!isset($stations[$wsKey])) $stations[$wsKey] = array();

    $start = $db->jdate($obj->date_start_planned);
    $end   = $db->jdate($obj->date_end_planned);

    $stations[$wsKey][] = array(
        'rowid' => (int) $obj->rowid,
        'ref' => $obj->ref,
        'status' => (int) $obj->status,
        'qty' => (float) $obj->qty,
        'qty_done' => (float) $obj->qty_done,
        'fk_product' => (int) $obj->fk_product,
        'prod_ref' => $obj->prod_ref,
        'prod_label' => $obj->prod_label,
        'start' => $start,
        'end' => $end,
        'job_number' => $obj->job_number,
        'fk_bom' => (int) $obj->fk_bom,
        'bom_note_public' => $obj->bom_note_public,
    );
}

// Render grid HTML (same as board)
ob_start();
print '<div class="pl-board-grid" id="plBoardGrid">';
foreach ($stations as $wsKey => $jobs) {
    $wsRef = ws_ref_label($wsKey, $workstationRefMap, $workstationMap);
    $count = count($jobs);

    print '<div class="pl-col">';
    print '<div class="pl-col-head">'.dol_escape_htmltag($wsRef).'<span class="pl-col-count">Jobs ('.$count.')</span></div>';

    foreach ($jobs as $j) {
        $qty = (float)$j['qty'];
        $done = (float)$j['qty_done'];
        $left = max(0, $qty - $done);
        $pct = ($qty > 0) ? min(100, max(0, ($done / $qty) * 100)) : 0;

        $startTxt = $j['start'] ? dol_print_date($j['start'], 'dayhour') : '';
        $endTxt   = $j['end'] ? dol_print_date($j['end'], 'dayhour') : '';
        $duration = '';
        if (!empty($j['start']) && !empty($j['end'])) {
            $seconds = ((int)$j['end']) - ((int)$j['start']);
            if ($seconds > 0) $duration = convertSecondToTime($seconds, 'allhourmin');
        } elseif (!empty($j['start']) && (int)$j['status'] === 2) {
            $seconds = time() - ((int)$j['start']);
            if ($seconds > 0) $duration = convertSecondToTime($seconds, 'allhourmin');
        }

        // MO link
        $moLink = '';
        $moObj = new Mo($db);
        if ($moObj->fetch((int)$j['rowid']) > 0) $moLink = $moObj->getNomUrl(1);
        if (empty($moLink)) {
            $moUrl = DOL_URL_ROOT.'/mrp/mo_card.php?id='.$j['rowid'];
            $moLink = '<a href="'.dol_escape_htmltag($moUrl).'">'.dol_escape_htmltag($j['ref']).'</a>';
        }

        // Product link (standard + label)
        $prodLink = dol_escape_htmltag($j['prod_ref']);
        if (!empty($j['fk_product'])) {
            $pobj = new Product($db);
            if ($pobj->fetch((int)$j['fk_product']) > 0) {
                $prodLink = $pobj->getNomUrl(1);
                if (!empty($pobj->label)) $prodLink .= ' - '.dol_escape_htmltag($pobj->label);
                elseif (!empty($j['prod_label'])) $prodLink .= ' - '.dol_escape_htmltag($j['prod_label']);
            }
        } else {
            if (!empty($j['prod_label'])) $prodLink .= ' - '.dol_escape_htmltag($j['prod_label']);
        }

        // Job link tooltip from BOM note (formatted)
        $jobTxt = (string)$j['job_number'];
        $jobLink = dol_escape_htmltag($jobTxt);
        $bomId = (int)$j['fk_bom'];
        if ($bomId > 0) {
            $noteRaw = (string)$j['bom_note_public'];
            $noteRaw = stripcslashes($noteRaw);
            $noteRaw = str_replace(array('\\r\\n','\\n','\\r'), "\n", $noteRaw);
            $noteRaw = str_replace(array("\r\n","\r"), "\n", $noteRaw);
            $noteRaw = trim($noteRaw);
            $titleHtml = dol_escape_htmltag($noteRaw);
            $titleHtml = str_replace(array('\\r\\n','\\n','\\r'), "<br>", $titleHtml);
            $titleHtml = str_replace(array("\r\n","\n","\r"), "<br>", $titleHtml);
            $urlNote = DOL_URL_ROOT.'/bom/bom_note.php?id='.$bomId;
            $jobLink = '<a href="'.dol_escape_htmltag($urlNote).'" class="classfortooltip pl-job-tooltip" data-html="true" title="'.$titleHtml.'">'.dol_escape_htmltag($jobTxt).'</a>';
        }

        print '<div class="pl-card">';
        print '<div class="pl-card-top">';
        print '<div class="pl-card-mo">'.$moLink.'</div>';
        print '<div class="pl-card-status">'.status_badge($j['status']).'</div>';
        print '</div>';

        print '<div class="pl-card-prod">'.$prodLink.'</div>';
        print '<div class="pl-card-job">Job: '.$jobLink.'</div>';

        print '<div class="pl-card-nums">';
        print '<div><span class="pl-k">Qty</span><span class="pl-v">'.dol_escape_htmltag((string)$qty).'</span></div>';
        print '<div><span class="pl-k">Done</span><span class="pl-v">'.dol_escape_htmltag((string)$done).'</span></div>';
        print '<div><span class="pl-k">Left</span><span class="pl-v">'.dol_escape_htmltag((string)$left).'</span></div>';
        print '</div>';

        print '<div class="pl-progress"><div class="pl-progress-bar" style="width:'.((int)$pct).'%"></div></div>';

        print '<div class="pl-card-times">';
        if ($startTxt) print '<span>'.$startTxt.'</span>';
        if ($endTxt) print '<span>→ '.$endTxt.'</span>';
        if ($duration) print '<span class="pl-card-dur">'.$duration.'</span>';
        print '</div>';

        print '</div>'; // card
    }

    print '</div>'; // col
}
print '</div>'; // grid
$gridHtml = ob_get_clean();

print json_encode(array(
    'clock' => dol_print_date(dol_now(), 'dayhoursec'),
    'html' => $gridHtml
));
exit;