# Planning (custom Dolibarr module snippet)

This package contains the **Planning Board** page + assets used in your Dolibarr `custom/planning/` directory.

## What this fix changes

- **Auto-refresh is handled in JavaScript only** (no PHP/meta refresh). The PHP file only provides the initial UI default.
- **Apply (filters / refresh interval)** keeps working and does not break fullscreen behaviour.
- **No duplicate "Auto-refresh" label**: the status line is rendered only by JS into `#plLastUpdate`.

## Install

From your Dolibarr custom directory:

```bash
cd /var/www/localhost/htdocs/dolibarr-dev/htdocs/custom
# backup if needed
cp -a planning planning.bak.$(date +%Y%m%d_%H%M%S)
# deploy
 tar -xzf planning_fixed_autorefresh_js_only.tgz
```

## Files

- `planning/board.php` – board page + `ajax=1` JSON endpoint
- `planning/js/board.js` – fullscreen + topbar + JS auto-refresh
- `planning/css/board.css` – board styling

## Notes

- Refresh interval is taken from the **Refresh** combobox (`select[name="refresh"]`).
- Countdown is rendered inline in the `#plLastUpdate` text.
