<?php
require '../../main.inc.php';

require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/mrp/class/mo.class.php';

if (empty($user->rights->planning->read)) accessforbidden();

$langs->loadLangs(array("main", "mrp"));

$pagetitle = "Planning Board";
$stationFilter = trim(GETPOST('station', 'alphanohtml'));
$showDraft = (int) GETPOST('showdraft', 'int');
$autorefresh = (int) GETPOST('refresh', 'int');
if ($autorefresh <= 0) $autorefresh = 60;

$arrayofcss = array();
$morecss = array('/custom/planning/css/board.css');
$morejs  = array('/custom/planning/js/board.js');
llxHeader('', 'Planning Board', '', '', 0, 0, $morejs, $morecss);
// --- Workstation map (rowid => ref/label)
$workstationMap = array();       // id => "REF - Label"
$workstationRefMap = array();    // id => "REF"
$wsTables = array(MAIN_DB_PREFIX.'workstation_workstation', MAIN_DB_PREFIX.'workstation', MAIN_DB_PREFIX.'mrp_workstation');
foreach ($wsTables as $wst) {
    // Detect table existence safely
    $sqlchk = "SELECT 1 as ok FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = '".$db->escape($wst)."'";
    $reschk = $db->query($sqlchk);
    $ok = ($reschk && ($o = $db->fetch_object($reschk)) && !empty($o->ok));
    if (!$ok) continue;

    $sqlws = "SELECT rowid, ref, label FROM ".$wst;
    $resws = $db->query($sqlws);
    if ($resws) {
        while ($ws = $db->fetch_object($resws)) {
            $id = (int) $ws->rowid;
            $ref = trim((string) $ws->ref);
            $label = trim((string) $ws->label);
            $workstationRefMap[$id] = $ref;
            $display = $ref;
            if ($label !== '') $display .= ' - '.$label;
            $workstationMap[$id] = $display;
        }
        break;
    }
}

// --- Build list of available stations (only live: Validated+In progress (+Draft if toggle))
$availableStations = array(); // raw => label
$sqlst = "SELECT DISTINCT ef.working_station as ws_raw
          FROM ".MAIN_DB_PREFIX."mrp_mo mo
          LEFT JOIN ".MAIN_DB_PREFIX."mrp_mo_extrafields ef ON ef.fk_object = mo.rowid
          WHERE mo.entity IN (".getEntity('mrp_mo').")
            AND ef.working_station IS NOT NULL
            AND ef.working_station <> ''
            AND mo.status IN (1,2".($showDraft ? ",0" : "").")
          ORDER BY ef.working_station ASC";
$resst = $db->query($sqlst);
if ($resst) {
    while ($s = $db->fetch_object($resst)) {
        $raw = (string) $s->ws_raw;
        $lbl = $raw;
        if (ctype_digit($raw)) {
            $id = (int) $raw;
            if (isset($workstationMap[$id])) $lbl = $workstationMap[$id];
        }
        $availableStations[$raw] = $lbl;
    }
    asort($availableStations, SORT_NATURAL | SORT_FLAG_CASE);
}

// --- Main SQL (live view only): statuses Validated + In progress (+ Draft via toggle)
$sql = "SELECT
            mo.rowid,
            mo.ref,
            mo.status,
            mo.qty,
            mo.fk_product,
            mo.date_start_planned,
            mo.date_end_planned,
            (SELECT COALESCE(SUM(CASE WHEN sm.value > 0 THEN sm.value ELSE 0 END),0)
             FROM ".MAIN_DB_PREFIX."stock_mouvement sm
             WHERE sm.origintype IN ('mo','mrp_mo')
               AND sm.fk_origin = mo.rowid
               AND sm.type_mouvement IN (2,3)
            ) as qty_done,
            p.ref as prod_ref,
            p.label as prod_label,
            ef.job_number,
            ef.working_station,
            mo.fk_bom,
            b.note_public as bom_note_public
        FROM ".MAIN_DB_PREFIX."mrp_mo as mo
        LEFT JOIN ".MAIN_DB_PREFIX."mrp_mo_extrafields as ef ON ef.fk_object = mo.rowid
        LEFT JOIN ".MAIN_DB_PREFIX."product as p ON p.rowid = mo.fk_product
        LEFT JOIN ".MAIN_DB_PREFIX."bom_bom as b ON b.rowid = mo.fk_bom
        WHERE mo.entity IN (".getEntity('mrp_mo').")
          AND mo.status IN (1,2".($showDraft ? ",0" : "").")";

if ($stationFilter !== '') {
    $sql .= " AND ef.working_station = '".$db->escape($stationFilter)."' ";
}

$sql .= " ORDER BY ef.working_station ASC, mo.date_start_planned ASC, mo.ref ASC";

$res = $db->query($sql);
if (!$res) {
    print '<div class="error">'.$db->lasterror().'</div>';
    llxFooter();
    exit;
}

// Group by station
$stations = array();
while ($obj = $db->fetch_object($res)) {
    $wsKey = trim((string) $obj->working_station);
    if ($wsKey === '') $wsKey = '(none)';
    if (!isset($stations[$wsKey])) $stations[$wsKey] = array();

    $start = $db->jdate($obj->date_start_planned);
    $end   = $db->jdate($obj->date_end_planned);

    $stations[$wsKey][] = array(
        'rowid' => (int) $obj->rowid,
        'ref' => $obj->ref,
        'status' => (int) $obj->status,
        'qty' => (float) $obj->qty,
        'qty_done' => (float) $obj->qty_done,
        'fk_product' => (int) $obj->fk_product,
        'prod_ref' => $obj->prod_ref,
        'prod_label' => $obj->prod_label,
        'start' => $start,
        'end' => $end,
        'job_number' => $obj->job_number,
        'fk_bom' => (int) $obj->fk_bom,
        'bom_note_public' => $obj->bom_note_public,
    );
}

function ws_ref_label($wsKey, $workstationRefMap, $workstationMap)
{
    $wsKey = (string) $wsKey;
    if (!empty($workstationMap[$wsKey]['label'])) return (string) $workstationMap[$wsKey]['label'];
    return $wsKey;
}

return $k;
}

function status_badge($status) {
    // Dolibarr-ish labels
    $map = array(
        0 => array('Draft','pl-status-draft'),
        1 => array('Validated','pl-status-validated'),
        2 => array('In progress','pl-status-inprogress'),
        3 => array('Produced','pl-status-produced'),
        9 => array('Cancelled','pl-status-cancelled'),
    );
    if (!isset($map[$status])) return '<span class="pl-status pl-status-unknown">?</span>';
    return '<span class="pl-status '.$map[$status][1].'">'.$map[$status][0].'</span>';
}

// --- AJAX refresh endpoint (returns JSON with refreshed board grid HTML) ---
$ajax = (int) GETPOST('ajax', 'int');
if ($ajax) {
    ob_start();
    print '<div class="pl-board-grid" id="plBoardGrid">';
    foreach ($stations as $wsKey => $jobs) {
        $wsRef = ws_ref_label($wsKey, $workstationRefMap, $workstationMap);
        $count = count($jobs);

        print '<div class="pl-col">';
        print '<div class="pl-col-head">'.dol_escape_htmltag($wsRef).'<span class="pl-col-count">Jobs ('.$count.')</span></div>';

        foreach ($jobs as $j) {
            $qty = (float)$j['qty'];
            $done = (float)$j['qty_done'];
            $left = max(0, $qty - $done);
            $pct = ($qty > 0) ? min(100, max(0, ($done / $qty) * 100)) : 0;

            $startTxt = $j['start'] ? dol_print_date($j['start'], 'dayhour') : '';
            $endTxt   = $j['end'] ? dol_print_date($j['end'], 'dayhour') : '';
            $duration = '';
            if (!empty($j['start']) && !empty($j['end'])) {
                $seconds = ((int)$j['end']) - ((int)$j['start']);
                if ($seconds > 0) $duration = convertSecondToTime($seconds, 'allhourmin');
            } elseif (!empty($j['start']) && (int)$j['status'] === 2) {
                $seconds = time() - ((int)$j['start']);
                if ($seconds > 0) $duration = convertSecondToTime($seconds, 'allhourmin');
            }

            // MO link
            $moLink = '';
            if (class_exists('Mo')) {
                $moObj = new Mo($db);
                if ($moObj->fetch((int)$j['rowid']) > 0) $moLink = $moObj->getNomUrl(1);
            }
            if (empty($moLink)) {
                $moUrl = DOL_URL_ROOT.'/mrp/mo_card.php?id='.$j['rowid'];
                $moLink = '<a href="'.dol_escape_htmltag($moUrl).'">'.dol_escape_htmltag($j['ref']).'</a>';
            }

            // Product link (standard + label)
            $prodLink = dol_escape_htmltag($j['prod_ref']);
            if (!empty($j['fk_product'])) {
                $pobj = new Product($db);
                if ($pobj->fetch((int)$j['fk_product']) > 0) {
                    $prodLink = $pobj->getNomUrl(1);
                    if (!empty($pobj->label)) $prodLink .= ' - '.dol_escape_htmltag($pobj->label);
                    elseif (!empty($j['prod_label'])) $prodLink .= ' - '.dol_escape_htmltag($j['prod_label']);
                }
            } else {
                if (!empty($j['prod_label'])) $prodLink .= ' - '.dol_escape_htmltag($j['prod_label']);
            }

            // Job link tooltip from BOM note (formatted)
            $jobTxt = (string)$j['job_number'];
            $jobLink = dol_escape_htmltag($jobTxt);
            $bomId = (int)$j['fk_bom'];
            if ($bomId > 0) {
                $noteRaw = (string)$j['bom_note_public'];
                $noteRaw = stripcslashes($noteRaw);
                $noteRaw = str_replace(array('\\r\\n','\\n','\\r'), "\n", $noteRaw);
                $noteRaw = str_replace(array("\r\n","\r"), "\n", $noteRaw);
                $noteRaw = trim($noteRaw);
                $titleHtml = dol_escape_htmltag($noteRaw);
                $titleHtml = str_replace(array('\\r\\n','\\n','\\r'), "<br>", $titleHtml);
                $titleHtml = str_replace(array("\r\n","\n","\r"), "<br>", $titleHtml);
                $urlNote = 'https://develop.for-our.info/bom/bom_note.php?id='.$bomId;
                $jobLink = '<a href="'.dol_escape_htmltag($urlNote).'" class="classfortooltip pl-job-tooltip" data-html="true" title="'.$titleHtml.'">'.dol_escape_htmltag($jobTxt).'</a>';
            }

            print '<div class="pl-card">';
            print '<div class="pl-card-top">';
            print '<div class="pl-card-mo">'.$moLink.'</div>';
            print '<div class="pl-card-status">'.status_badge($j['status']).'</div>';
            print '</div>';

            print '<div class="pl-card-prod">'.$prodLink.'</div>';
            print '<div class="pl-card-job">Job: '.$jobLink.'</div>';

            print '<div class="pl-card-nums">';
            print '<div><span class="pl-k">Qty</span><span class="pl-v">'.dol_escape_htmltag((string)$qty).'</span></div>';
            print '<div><span class="pl-k">Done</span><span class="pl-v">'.dol_escape_htmltag((string)$done).'</span></div>';
            print '<div><span class="pl-k">Left</span><span class="pl-v">'.dol_escape_htmltag((string)$left).'</span></div>';
            print '</div>';

            print '<div class="pl-progress"><div class="pl-progress-bar" style="width:'.((int)$pct).'%"></div></div>';

            print '<div class="pl-card-times">';
            if ($startTxt) print '<span>'.$startTxt.'</span>';
            if ($endTxt) print '<span>→ '.$endTxt.'</span>';
            if ($duration) print '<span class="pl-card-dur">'.$duration.'</span>';
            print '</div>';

            print '</div>'; // card
        }

        print '</div>'; // col
    }
    print '</div>'; // grid
    $gridHtml = ob_get_clean();

    $payload = array(
        'html' => $gridHtml,
        'clock' => dol_print_date(dol_now(), 'dayhoursec'),
    );
    header('Content-Type: application/json; charset=utf-8');
    print json_encode($payload);
    exit;
}

print '<div class="pl-board-page" id="plBoardPage">';

// Top bar
print '<div class="pl-board-top">';
print '<div class="pl-board-title">'.$pagetitle.'</div>';

print '<form class="pl-board-filters" method="GET" action="'.dol_escape_htmltag($_SERVER['PHP_SELF']).'">';
print '<select name="station" class="minwidth200">';
print '<option value="">All stations</option>';
foreach ($availableStations as $raw => $lbl) {
    $sel = ($stationFilter !== '' && (string)$stationFilter === (string)$raw) ? ' selected' : '';
    print '<option value="'.dol_escape_htmltag($raw).'"'.$sel.'>'.dol_escape_htmltag($lbl).'</option>';
}
print '</select>';

$chk = $showDraft ? ' checked' : '';
print '<label class="pl-board-check"><input type="checkbox" name="showdraft" value="1"'.$chk.'> Show Draft</label>';

print '<select name="refresh" class="minwidth100">';
foreach (array(0=>'Off',30=>'30s',60=>'60s',120=>'2m',300=>'5m') as $sec=>$txt) {
    $sel = ((int)$autorefresh === (int)$sec) ? ' selected' : '';
    print '<option value="'.((int)$sec).'"'.$sel.'>'.$txt.'</option>';
}
print '</select>';

print '<button class="butAction" type="submit">Apply</button>';
print '<button class="butAction" type="button" id="plFullscreen">Fullscreen</button>';
print '</form>';

print '<div class="pl-board-meta">';
print '<span id="plClock"></span>';
print '<span id="plLastUpdate" style="margin-left:10px;">Last update: -</span>';
print '<span style="margin-left:10px;">• Auto-refresh: '.((int)$autorefresh).'s (<span id="plRefreshCountdown">'.((int)$autorefresh).'</span>)</span>';
print '<span id="plRefreshSeconds" style="display:none;">'.((int)$autorefresh).'</span>';
print '</div>';
print '</div>';

// Board columns
print '<div class="pl-board-grid" id="plBoardGrid">';
foreach ($stations as $wsKey => $jobs) {
    $wsRef = ws_ref_label($wsKey, $workstationRefMap, $workstationMap);
    $count = count($jobs);

    print '<div class="pl-col">';
    print '<div class="pl-col-head">'.dol_escape_htmltag($wsRef).'<span class="pl-col-count">Jobs ('.$count.')</span></div>';

    foreach ($jobs as $j) {
        $qty = (float)$j['qty'];
        $done = (float)$j['qty_done'];
        $left = max(0, $qty - $done);
        $pct = ($qty > 0) ? min(100, max(0, ($done / $qty) * 100)) : 0;

        $startTxt = $j['start'] ? dol_print_date($j['start'], 'dayhour') : '';
        $endTxt   = $j['end'] ? dol_print_date($j['end'], 'dayhour') : '';
        $duration = '';
        if (!empty($j['start']) && !empty($j['end'])) {
            $sec = ((int)$j['end']) - ((int)$j['start']);
            if ($sec > 0) $duration = convertSecondToTime($sec, 'allhourmin');
        } elseif (!empty($j['start']) && (int)$j['status'] === 2) {
            $sec = time() - ((int)$j['start']);
            if ($sec > 0) $duration = convertSecondToTime($sec, 'allhourmin');
        }

        // MO tooltip (standard)
        $moLink = '';
        if (class_exists('Mo')) {
            $moObj = new Mo($db);
            if ($moObj->fetch((int)$j['rowid']) > 0) $moLink = $moObj->getNomUrl(1);
        }
        if (empty($moLink)) {
            $moUrl = DOL_URL_ROOT.'/mrp/mo_card.php?id='.$j['rowid'];
            $moLink = '<a href="'.dol_escape_htmltag($moUrl).'">'.dol_escape_htmltag($j['ref']).'</a>';
        }

        // Product link (standard + label)
        $prodLink = dol_escape_htmltag($j['prod_ref']);
        if (!empty($j['fk_product'])) {
            $pobj = new Product($db);
            if ($pobj->fetch((int)$j['fk_product']) > 0) {
                $prodLink = $pobj->getNomUrl(1);
                if (!empty($pobj->label)) $prodLink .= ' - '.dol_escape_htmltag($pobj->label);
                elseif (!empty($j['prod_label'])) $prodLink .= ' - '.dol_escape_htmltag($j['prod_label']);
            }
        } else {
            if (!empty($j['prod_label'])) $prodLink .= ' - '.dol_escape_htmltag($j['prod_label']);
        }

        // Job link tooltip from BOM note (formatted)
        $jobTxt = (string)$j['job_number'];
        $jobLink = dol_escape_htmltag($jobTxt);
        $bomId = (int)$j['fk_bom'];
        if ($bomId > 0) {
            $noteRaw = (string)$j['bom_note_public'];
            $noteRaw = stripcslashes($noteRaw);
            $noteRaw = str_replace(array('\\r\\n','\\n','\\r'), "\n", $noteRaw);
            $noteRaw = str_replace(array("\r\n","\r"), "\n", $noteRaw);
            $noteRaw = trim($noteRaw);
            $titleHtml = dol_escape_htmltag($noteRaw);
            $titleHtml = str_replace(array('\\r\\n','\\n','\\r'), "<br>", $titleHtml);
            $titleHtml = str_replace(array("\r\n","\n","\r"), "<br>", $titleHtml);
            $urlNote = 'https://develop.for-our.info/bom/bom_note.php?id='.$bomId;
            $jobLink = '<a href="'.dol_escape_htmltag($urlNote).'" class="classfortooltip pl-job-tooltip" data-html="true" title="'.$titleHtml.'">'.dol_escape_htmltag($jobTxt).'</a>';
        }

        print '<div class="pl-card">';
        print '<div class="pl-card-top">';
        print '<div class="pl-card-mo">'.$moLink.'</div>';
        print '<div class="pl-card-status">'.status_badge((int)$j['status']).'</div>';
        print '</div>';

        print '<div class="pl-card-prod">'.$prodLink.'</div>';
        print '<div class="pl-card-job">Job: '.$jobLink.'</div>';

        print '<div class="pl-card-nums">';
        print '<div><span class="pl-k">Qty</span><span class="pl-v">'.dol_escape_htmltag((string)$qty).'</span></div>';
        print '<div><span class="pl-k">Done</span><span class="pl-v">'.dol_escape_htmltag((string)$done).'</span></div>';
        print '<div><span class="pl-k">Left</span><span class="pl-v">'.dol_escape_htmltag((string)$left).'</span></div>';
        print '</div>';

        print '<div class="pl-progress"><div class="pl-progress-bar" style="width:'.((int)$pct).'%"></div></div>';

        print '<div class="pl-card-times">';
        if ($startTxt) print '<span>'.$startTxt.'</span>';
        if ($endTxt) print '<span>→ '.$endTxt.'</span>';
        if ($duration) print '<span class="pl-dur">'.$duration.'</span>';
        print '</div>';

        print '</div>'; // card
    }

    print '</div>'; // col
}
print '</div>'; // grid

print '</div>'; // page

print '';

print '';

llxFooter();
