document.addEventListener('DOMContentLoaded', function(){
(function(){
  function updateClock(){
    var d=new Date();
    var s=d.toLocaleString();
    var el=document.getElementById("plClock");
    if(el) el.textContent=s;
  }
  updateClock();
  setInterval(updateClock, 1000);

  var fsBtn = document.getElementById("plFullscreen");
var fsDenied = false;

function fsSupport(){
  var el = document.getElementById("plBoardPage") || document.documentElement;
  return !!(el.requestFullscreen || el.webkitRequestFullscreen || el.mozRequestFullScreen || el.msRequestFullscreen);
}
function isFullscreen(){
  return !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
}
function setUiModes(){
  var isFs = isFullscreen();
  document.body.classList.toggle("pl-fullscreen", isFs);
  // kiosk stays as-is
}
function updateFsButton(){
  if(!fsBtn) return;
  if(isFullscreen() || document.body.classList.contains("pl-kiosk")) fsBtn.textContent = "Exit";
  else fsBtn.textContent = (fsSupport() && !fsDenied) ? "Fullscreen" : "Kiosk";
}

if(fsBtn){
  updateFsButton();

  fsBtn.addEventListener("click", function(){
    // Prefer real Fullscreen; fallback to kiosk if blocked or unsupported
    if(fsSupport() && !fsDenied){
      var el = document.getElementById("plBoardPage") || document.documentElement;
      if(!isFullscreen()){
        var req = el.requestFullscreen || el.webkitRequestFullscreen || el.mozRequestFullScreen || el.msRequestFullscreen;
        try{
          var ret = req && req.call(el);
          if(ret && typeof ret.then === "function"){
            ret.catch(function(){
              fsDenied = true;
              document.body.classList.add("pl-kiosk");
              updateFsButton();
            });
          }
        }catch(e){
          fsDenied = true;
          document.body.classList.add("pl-kiosk");
        }
      } else {
        var exit = document.exitFullscreen || document.webkitExitFullscreen || document.mozCancelFullScreen || document.msExitFullscreen;
        try{ exit && exit.call(document); }catch(e){}
      }
    } else {
      document.body.classList.toggle("pl-kiosk");
    }
    setTimeout(function(){ setUiModes(); updateFsButton(); }, 200);
  });

  document.addEventListener("fullscreenchange", function(){ setUiModes(); updateFsButton(); });
  document.addEventListener("webkitfullscreenchange", function(){ setUiModes(); updateFsButton(); });
}

var refresh = '.((int)$autorefresh).';
var countdownEl = document.getElementById("plRefreshCountdown");
var refreshTimer = null;
var tickTimer = null;

function doAjaxRefresh(){
  try{
    var url = new URL(window.location.href);
    url.searchParams.set("ajax","1");
    // remove any fragment
    url.hash = "";
    fetch(url.toString(), {cache:"no-store", credentials:"same-origin"})
      .then(function(r){
        if(!r.ok) throw new Error("HTTP "+r.status);
        return r.json();
      })
      .then(function(data){
        if(data && data.html){
          var grid = document.getElementById("plBoardGrid");
          if(grid){
            grid.outerHTML = data.html;
          }
          // Re-init tooltips for new DOM
          if (window.jQuery && jQuery.fn && jQuery.fn.tooltip) {
            jQuery(".classfortooltip").tooltip({ position: { my: "left top+15", at: "left bottom", collision: "flipfit" } });
          }
        }
        var clk = document.getElementById("plClock");
        if(clk && data && data.clock) clk.textContent = data.clock;
      })
      .catch(function(err){
        // show small hint in console for debugging
        try{ console.warn("Planning Board refresh failed", err); }catch(e){}
      });
  }catch(e){
    try{ console.warn("Planning Board refresh exception", e); }catch(ex){}
  }
}

function startCountdown(){
  if(!(refresh > 0)) return;
  var remaining = refresh;
  if(countdownEl) countdownEl.textContent = remaining;
  if(tickTimer) clearInterval(tickTimer);
  tickTimer = setInterval(function(){
    remaining -= 1;
    if(remaining <= 0){
      remaining = refresh;
      doAjaxRefresh();
    }
    if(countdownEl) countdownEl.textContent = remaining;
  }, 1000);
}

if(refresh > 0){
  startCountdown();
}
})();

});

(function(){
  function qs(id){ return document.getElementById(id); }

  function fetchLastUpdate(){
    try{
      var qs = (window.location.search ? window.location.search.replace(/^\?/, '') : '');
                var sep = qs ? '&' : '';
                fetch('board_data.php?' + qs + sep + '_ts=' + Date.now(), {cache:'no-store', credentials:'same-origin'})
        .then(function(r){ return r.json(); })
        .then(function(j){
          var lu = qs('plLastUpdate');
          if(lu){
            if(j && (j.server_time || j.generated_at)) lu.textContent = 'Last update: ' + (j.server_time || j.generated_at);
            else lu.textContent = 'Last update: OK';
          }
        })
        .catch(function(){
          var lu = qs('plLastUpdate');
          if(lu) lu.textContent = 'Last update: ERROR';
        });
    }catch(e){
      var lu = qs('plLastUpdate');
      if(lu) lu.textContent = 'Last update: ERROR';
    }
  }

  function init(){
    var refreshEl = qs('plRefreshSeconds');
    var refresh = refreshEl ? parseInt((refreshEl.textContent||'0'),10) : 0;
    var cdEl = qs('plRefreshCountdown');
    if(!(refresh>0) || !cdEl) return;

    var remaining = refresh;
    cdEl.textContent = remaining;

    // initial ping
    fetchLastUpdate();

    setInterval(function(){
      remaining--;
      if(remaining <= 0){
        remaining = refresh;
        fetchLastUpdate();
      }
      cdEl.textContent = remaining;
    }, 1000);
  }

  if(document.readyState==='loading') document.addEventListener('DOMContentLoaded', init);
  else init();
})();
