<?php
// Planning Board - JSON endpoint (no HTML output)
define('NOREQUIREMENU', 1);
define('NOREQUIRETOP', 1);
define('NOREQUIREAJAX', 1);
define('NOREQUIREHTML', 1);

require '../../main.inc.php';

@ini_set('display_errors','0');
@error_reporting(0);

header('Content-Type: application/json; charset=utf-8');

$payload = array(
    'ok' => true,
    'server_time' => dol_print_date(dol_now(), 'dayhoursec'),
    'html' => ''
);

// Render board.php into buffer and extract only the grid HTML (keeps SQL identical to board.php)
ob_start();
include __DIR__.'/board.php';
$full = ob_get_clean();

// Try to extract the main grid container by id first
if (preg_match('/<div[^>]+id="plBoardGrid"[^>]*>.*?<\/div>/si', $full, $m)) {
    $payload['html'] = $m[0];
} elseif (preg_match('/<div[^>]+class="pl-board-grid"[^>]*>.*?<\/div>/si', $full, $m2)) {
    $payload['html'] = $m2[0];
}

print json_encode($payload);
exit;
