function plInitTooltips(){
  try{
    plInitTooltips();
catch(e){}
      jQuery(".classfortooltip").tooltip({
        position: { my: "left top+15", at: "left bottom", collision: "flipfit" }
      });
      // ensure tooltip is visible above cards/fullscreen layers
      try { jQuery(".ui-tooltip").css("z-index", 20000); } catch(e){}
    }
  }catch(e){}
}

document.addEventListener('DOMContentLoaded', function(){
(function(){
  function updateClock(){
    var d=new Date();
    var s=d.toLocaleString();
    var el=document.getElementById("plClock");
    if(el) el.textContent=s;
  }
  updateClock();
  setInterval(updateClock, 1000);

  var fsBtn = document.getElementById("plFullscreen");
var fsDenied = false;

function fsSupport(){
  var el = document.getElementById("plBoardPage") || document.documentElement;
  return !!(el.requestFullscreen || el.webkitRequestFullscreen || el.mozRequestFullScreen || el.msRequestFullscreen);
}
function isFullscreen(){
  return !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
}
function updateFsButton(){
  if(!fsBtn) return;
  if(isFullscreen() || document.body.classList.contains("pl-kiosk")) fsBtn.textContent = "EXIT";
  else fsBtn.textContent = (fsSupport() && !fsDenied) ? "FULLSCREEN" : "KIOSK";
}
function setUiModes(){
  document.body.classList.toggle("pl-fullscreen", isFullscreen());
}

if(fsBtn){
  updateFsButton();

  fsBtn.addEventListener("click", function(){
    if(fsSupport() && !fsDenied){
      var el = document.getElementById("plBoardPage") || document.documentElement;
      if(!isFullscreen()){
        var req = el.requestFullscreen || el.webkitRequestFullscreen || el.mozRequestFullScreen || el.msRequestFullscreen;
        try{
          var ret = req && req.call(el);
          if(ret && typeof ret.then === "function"){
            ret.catch(function(){
              fsDenied = true;
              document.body.classList.add("pl-kiosk");
              updateFsButton();
            });
          }
        }catch(e){
          fsDenied = true;
          document.body.classList.add("pl-kiosk");
        }
      } else {
        var exit = document.exitFullscreen || document.webkitExitFullscreen || document.mozCancelFullScreen || document.msExitFullscreen;
        try{ exit && exit.call(document); }catch(e){}
      }
    } else {
      document.body.classList.toggle("pl-kiosk");
    }
    setTimeout(function(){ setUiModes(); updateFsButton(); }, 200);
  });

  document.addEventListener("fullscreenchange", function(){ setUiModes(); updateFsButton(); });
  document.addEventListener("webkitfullscreenchange", function(){ setUiModes(); updateFsButton(); });

  // initialize
  setTimeout(function(){ setUiModes(); updateFsButton(); }, 50);
}

function fetchLastUpdate(){

    try{
      var qs = (window.location.search ? window.location.search.replace(/^\?/, '') : '');
                var sep = qs ? '&' : '';
                fetch('board_data.php?' + qs + sep + '_ts=' + Date.now(), {cache:'no-store', credentials:'same-origin'})
        .then(function(r){ return r.json(); })
        .then(function(j){
          var lu = plById('plLastUpdate');
          if(lu){
            if(j && (j.clock || j.server_time || j.generated_at)) lu.textContent = 'Last update: ' + (j.clock || j.server_time || j.generated_at);
            else lu.textContent = 'Last update: ' + (j.clock || j.server_time || j.generated_at || '');
          }
          if(j && j.html){ applyBoardHtml(j.html); }
        })
        .catch(function(){
          var lu = plById('plLastUpdate');
          if(lu) lu.textContent = 'Last update: ERROR';
        });
    }catch(e){
      var lu = plById('plLastUpdate');
      if(lu) lu.textContent = 'Last update: ERROR';
    }
  }

  function init(){
    var refreshEl = plById('plRefreshSeconds');
    var refresh = refreshEl ? parseInt((refreshEl.textContent||'0'),10) : 0;
    var cdEl = plById('plRefreshCountdown');
    if(!(refresh>0) || !cdEl) return;

    var remaining = refresh;
    cdEl.textContent = remaining;

    // initial ping
    fetchLastUpdate();

    setInterval(function(){
      remaining--;
      if(remaining <= 0){
        remaining = refresh;
        fetchLastUpdate();
      }
      cdEl.textContent = remaining;
    }, 1000);
  }

  if(document.readyState==='loading') document.addEventListener('DOMContentLoaded', init);
  else init();
})();


// Auto-hide top bar in fullscreen
(function(){
  var topBar = document.querySelector('.pl-board-top');
  if(!topBar) return;

  var hideTimer = null;
  var HIDE_DELAY = 10000;

  function hideTop(){
    topBar.classList.add('pl-top-hidden');
  }
  function showTop(){
    topBar.classList.remove('pl-top-hidden');
    resetTimer();
  }
  function resetTimer(){
    if(hideTimer) clearTimeout(hideTimer);
    hideTimer = setTimeout(hideTop, HIDE_DELAY);
  }

  document.addEventListener('fullscreenchange', function(){
    if(document.fullscreenElement){
      resetTimer();
    } else {
      showTop();
    }
  });

  document.addEventListener('mousemove', function(e){
    if(!document.fullscreenElement) return;
    if(e.clientY < 10){
      showTop();
    }
  });
})();

(function(){
  var hideTimer = null;
  var idleTimer = null;

  function ensureHotzone(){
    if(document.getElementById('plTopHotzone')) return;
    var hz = document.createElement('div');
    hz.id = 'plTopHotzone';
    document.body.appendChild(hz);

    function showTop(){
      document.body.classList.remove('pl-top-hidden');
      // auto-hide again after short idle
      if(idleTimer) clearTimeout(idleTimer);
      idleTimer = setTimeout(function(){
        if(isFullscreen()) document.body.classList.add('pl-top-hidden');
      }, 2500);
    }

    hz.addEventListener('mouseenter', showTop);
    hz.addEventListener('mousemove', showTop);
    hz.addEventListener('touchstart', showTop, {passive:true});

    // Also show when mouse/touch near top edge
    document.addEventListener('mousemove', function(e){
      if(!isFullscreen()) return;
      if(e.clientY <= 6) showTop();
    });
    document.addEventListener('touchstart', function(e){
      if(!isFullscreen()) return;
      var t = e.touches && e.touches[0];
      if(t && t.clientY <= 20) showTop();
    }, {passive:true});
  }

  function isFullscreen(){
    return !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
  }

  function scheduleHide(){
    if(hideTimer) clearTimeout(hideTimer);
    hideTimer = setTimeout(function(){
      if(isFullscreen()){
        document.body.classList.add('pl-top-hidden');
      }
    }, 5000);
  }

  function onFsChange(){
    ensureHotzone();
    if(isFullscreen()){
      scheduleHide();
    } else {
      document.body.classList.remove('pl-top-hidden');
    }
  }

  document.addEventListener('fullscreenchange', onFsChange);
  document.addEventListener('webkitfullscreenchange', onFsChange);

  // If already fullscreen on load
  setTimeout(onFsChange, 400);
})();


// Top bar auto-hide in fullscreen (5s)
(function(){
  var hideTimer = null;
  function isFs(){
    return !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
  }
  function hideTop(){
    document.body.classList.add('pl-top-hidden');
  }
  function showTop(){
    document.body.classList.remove('pl-top-hidden');
  }
  function scheduleHideTopBar(){
    if(hideTimer) clearTimeout(hideTimer);
    hideTimer = setTimeout(function(){
      if(isFs()) hideTop();
    }, 5000);
  }
  function ensureHotzone(){
    if(document.getElementById('plTopHotzone')) return;
    var hz=document.createElement('div');
    hz.id='plTopHotzone';
    document.body.appendChild(hz);
    function reveal(){
      showTop();
      scheduleHideTopBar();
    }
    hz.addEventListener('mouseenter', reveal);
    hz.addEventListener('mousemove', reveal);
    hz.addEventListener('touchstart', reveal, {passive:true});
    document.addEventListener('mousemove', function(e){
      if(isFs() && e.clientY <= 6) reveal();
    });
    document.addEventListener('touchstart', function(e){
      if(!isFs()) return;
      var t=e.touches && e.touches[0];
      if(t && t.clientY <= 20) reveal();
    }, {passive:true});
  }
  function onFsChange(){
    ensureHotzone();
    if(isFs()){
      scheduleHideTopBar();
    } else {
      showTop();
    }
  }
  document.addEventListener('fullscreenchange', onFsChange);
  document.addEventListener('webkitfullscreenchange', onFsChange);
  // hook fullscreen button click
  document.addEventListener('click', function(e){
    var t=e.target;
    if(!t) return;
    if(t.id==='plFullscreen' || t.id==='btnFullscreen' || (t.closest && t.closest('#plFullscreen'))){
      // after user gesture, schedule hide shortly
      setTimeout(onFsChange, 300);
    }
  }, true);
})();


document.addEventListener('fullscreenchange', function(){ plInitTooltips(); });
document.addEventListener('webkitfullscreenchange', function(){ plInitTooltips(); });
