#!/bin/sh
set -eu

FILE="board.php"

if [ ! -f "$FILE" ]; then
  echo "ERROR: $FILE not found in current directory" >&2
  exit 1
fi

# 1) Remove the stray lines that break PHP parsing (return $k; and the following lone brace)
#    This removes only the first occurrence of the exact two-line sequence.
tmp="$(mktemp)"
awk '
  BEGIN{removed=0}
  {
    if(!removed && $0 ~ /^[[:space:]]*return[[:space:]]+\$k;[[:space:]]*$/){
      getline nextline
      if(nextline ~ /^[[:space:]]*}[[:space:]]*$/){
        removed=1
        next
      } else {
        print $0
        print nextline
        next
      }
    }
    print
  }
' "$FILE" > "$tmp"
mv "$tmp" "$FILE"

# 2) Ensure workstation label display is LABEL only (no "REF - LABEL")
# Common patterns we replace:
#   $display = $ref.' - '.$label;
#   $display = $ref." - ".$label;
#   $display = $ref.' - '.$lbl;
#   $display = $ref." - ".$lbl;
# We replace them with $display = $label; (or $lbl if label var is $lbl)
sed -i \
  -e "s/^[[:space:]]*\$display[[:space:]]*=[[:space:]]*\$ref[[:space:]]*\\.[[:space:]]*' - '[[:space:]]*\\.[[:space:]]*\$label[[:space:]]*;/    \$display = \$label;/" \
  -e 's/^[[:space:]]*\$display[[:space:]]*=[[:space:]]*\$ref[[:space:]]*\.[[:space:]]*" - "[[:space:]]*\.[[:space:]]*\$label[[:space:]]*;/    $display = $label;/' \
  -e "s/^[[:space:]]*\$display[[:space:]]*=[[:space:]]*\$ref[[:space:]]*\\.[[:space:]]*' - '[[:space:]]*\\.[[:space:]]*\$lbl[[:space:]]*;/    \$display = \$lbl;/" \
  -e 's/^[[:space:]]*\$display[[:space:]]*=[[:space:]]*\$ref[[:space:]]*\.[[:space:]]*" - "[[:space:]]*\.[[:space:]]*\$lbl[[:space:]]*;/    $display = $lbl;/' \
  "$FILE" || true

# 3) Update the comment to avoid confusion (optional)
sed -i -e 's/id => "REF - Label"/id => "Label"/' "$FILE" || true

echo "OK: board.php hotfix applied"
