function plInitTooltips(){
  try{
    if(!(window.jQuery && jQuery.fn && jQuery.fn.tooltip)) return;

    // FG + MO default Dolibarr tooltip
    try{
      var $def=jQuery('.classfortooltip').not('.pl-job-tooltip');
      if($def.length){
        $def.tooltip('destroy');
        $def.tooltip();
      }
    }catch(e1){}

    // Job tooltip (multiline)
    try{
      var $job=jQuery('.pl-job-tooltip.classfortooltip');
      if($job.length){
        $job.tooltip('destroy');
        $job.tooltip({
          content:function(){
            var t=jQuery(this).attr('title')||'';
            return (''+t).replace(/\n|&#10;/g,'<br>');
          },
          position:{ my:'left top+15', at:'left bottom', collision:'flipfit' }
        });
      }
    }catch(e2){}
  }catch(e){}
}


function isFullscreen(){ return !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement); }
}catch(e1){}

    // Custom multiline tooltip only for Job
    try{
      var $job = jQuery(".pl-job-tooltip.classfortooltip");
      if($job.length){
        $job.tooltip("destroy");
        $job.tooltip({
          content: function(){
            var t = jQuery(this).attr("title") || "";
            return (""+t).replace(/\n|&#10;/g, "<br>");
          },
          position: { my: "left top+15", at: "left bottom", collision: "flipfit" }
        });
      }
    }catch(e2){}
  }catch(e){}
}

document.addEventListener('DOMContentLoaded', function(){
(function(){
  function updateClock(){
    var d=new Date();
    var s=d.toLocaleString();
    var el=document.getElementById("plClock");
    if(el) el.textContent=s;
  }
  updateClock();
  setInterval(updateClock, 1000);

  var fsBtn = document.getElementById("plFullscreen");
var fsDenied = false;

function fsSupport(){
  var el = document.getElementById("plBoardPage") || document.documentElement;
  return !!(el.requestFullscreen || el.webkitRequestFullscreen || el.mozRequestFullScreen || el.msRequestFullscreen);
}
function isFullscreen(){
  return !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
}
function setUiModes(){
  var isFs = isFullscreen();
  document.body.classList.toggle("pl-fullscreen", isFs);
  // kiosk stays as-is
}
function updateFsButton(){
  if(!fsBtn) return;
  if(isFullscreen() || document.body.classList.contains("pl-kiosk")) fsBtn.textContent = "Exit";
  else fsBtn.textContent = (fsSupport() && !fsDenied) ? "Fullscreen" : "Kiosk";
}

if(fsBtn){
  updateFsButton();

  fsBtn.addEventListener("click", function(){
    // Prefer real Fullscreen; fallback to kiosk if blocked or unsupported
    if(fsSupport() && !fsDenied){
      var el = document.getElementById("plBoardPage") || document.documentElement;
      if(!isFullscreen()){
        var req = el.requestFullscreen || el.webkitRequestFullscreen || el.mozRequestFullScreen || el.msRequestFullscreen;
        try{
          var ret = req && req.call(el);
          if(ret && typeof ret.then === "function"){
            ret.catch(function(){
              fsDenied = true;
              document.body.classList.add("pl-kiosk");
              updateFsButton();
            });
          }
        }catch(e){
          fsDenied = true;
          document.body.classList.add("pl-kiosk");
        }
      } else {
        var exit = document.exitFullscreen || document.webkitExitFullscreen || document.mozCancelFullScreen || document.msExitFullscreen;
        try{ exit && exit.call(document); }catch(e){}
      }
    } else {
      document.body.classList.toggle("pl-kiosk");
    }
    setTimeout(function(){ setUiModes(); updateFsButton(); }, 200);
  });

  document.addEventListener("fullscreenchange", function(){ setUiModes(); updateFsButton(); });
  document.addEventListener("webkitfullscreenchange", function(){ setUiModes(); updateFsButton(); });
}

var refresh = '.((int)$autorefresh).';
var countdownEl = document.getElementById("plRefreshCountdown");
var refreshTimer = null;
var tickTimer = null;

function doAjaxRefresh(){
  try{
    var url = new URL(window.location.href);
    url.searchParams.set("ajax","1");
    // remove any fragment
    url.hash = "";
    fetch(url.toString(), {cache:"no-store", credentials:"same-origin"})
      .then(function(r){
        if(!r.ok) throw new Error("HTTP "+r.status);
        return r.json();
      })
      .then(function(data){
        if(data && data.html){
          var grid = document.getElementById("plBoardGrid");
          if(grid){
            grid.outerHTML = data.html;
          }
          // Re-init tooltips for new DOM
          if (window.jQuery && jQuery.fn && jQuery.fn.tooltip) {
            jQuery(".classfortooltip").tooltip({ position: { my: "left top+15", at: "left bottom", collision: "flipfit" } });
          }
        }
        var clk = document.getElementById("plClock");
        if(clk && data && data.clock) clk.textContent = data.clock;
      })
      .catch(function(err){
        // show small hint in console for debugging
        try{ console.warn("Planning Board refresh failed", err); }catch(e){}
      });
  }catch(e){
    try{ console.warn("Planning Board refresh exception", e); }catch(ex){}
  }
}

function startCountdown(){
  if(!(refresh > 0)) return;
  var remaining = refresh;
  if(countdownEl) countdownEl.textContent = remaining;
  if(tickTimer) clearInterval(tickTimer);
  tickTimer = setInterval(function(){
    remaining -= 1;
    if(remaining <= 0){
      remaining = refresh;
      doAjaxRefresh();
    }
    if(countdownEl) countdownEl.textContent = remaining;
  }, 1000);
}

if(refresh > 0){
  startCountdown();
}
})();

});

(function(){
  function plById(id){ return document.getElementById(id); }

  function applyBoardHtml(html){
  try{
    if(!html) return;
    var old = plById('plBoardGrid');
    if(old){
      old.outerHTML = html;
    }
    if (window.jQuery && jQuery.fn && jQuery.fn.tooltip) {
      jQuery(".classfortooltip").tooltip({ position: { my: "left top+15", at: "left bottom", collision: "flipfit" } });
    }
  }catch(e){}
}

function fetchLastUpdate(){

    try{
      var qs = (window.location.search ? window.location.search.replace(/^\?/, '') : '');
                var sep = qs ? '&' : '';
                fetch('board_data.php?' + qs + sep + '_ts=' + Date.now(), {cache:'no-store', credentials:'same-origin'})
        .then(function(r){ return r.json(); })
        .then(function(j){
          var lu = plById('plLastUpdate');
          if(lu){
            if(j && (j.clock || j.server_time || j.generated_at)) lu.textContent = 'Last update: ' + (j.clock || j.server_time || j.generated_at);
            else lu.textContent = 'Last update: ' + (j.clock || j.server_time || j.generated_at || '');
          }
          if(j && j.html){ applyBoardHtml(j.html);
                    try{ plInitTooltips(); }catch(e){}
try{
  document.querySelectorAll('.pl-card-mo a, .pl-card-prod a').forEach(function(el){
    el.removeAttribute('title');
    el.classList.remove('classfortooltip');
  });
}catch(e){}
                    try{ plInitTooltips(); }catch(e){} }
        })
        .catch(function(){
          var lu = plById('plLastUpdate');
          if(lu) lu.textContent = 'Last update: ERROR';
        });
    }catch(e){
      var lu = plById('plLastUpdate');
      if(lu) lu.textContent = 'Last update: ERROR';
    }
  }

  function init(){
    var refreshEl = plById('plRefreshSeconds');
    var refresh = refreshEl ? parseInt((refreshEl.textContent||'0'),10) : 0;
    var cdEl = plById('plRefreshCountdown');
    if(!(refresh>0) || !cdEl) return;

    var remaining = refresh;
    cdEl.textContent = remaining;

    // initial ping
    fetchLastUpdate();

    setInterval(function(){
      remaining--;
      if(remaining <= 0){
        remaining = refresh;
        fetchLastUpdate();
      }
      cdEl.textContent = remaining;
    }, 1000);
  }

  if(document.readyState==='loading') document.addEventListener('DOMContentLoaded', init);
  else init();
})();


// Auto-hide top bar in fullscreen
(function(){
  var hideTimer = null;
  var idleTimer = null;

  function ensureHotzone(){
    if(document.getElementById('plTopHotzone')) return;
    var hz = document.createElement('div');
    hz.id = 'plTopHotzone';
    document.body.appendChild(hz);

    function showTop(){
      document.body.classList.remove('pl-top-hidden');
      // auto-hide again after short idle
      if(idleTimer) clearTimeout(idleTimer);
      idleTimer = setTimeout(function(){
        if(isFullscreen()) document.body.classList.add('pl-top-hidden');
      }, 2500);
    }

    hz.addEventListener('mouseenter', showTop);
    hz.addEventListener('mousemove', showTop);
    hz.addEventListener('touchstart', showTop, {passive:true});

    // Also show when mouse/touch near top edge
    document.addEventListener('mousemove', function(e){
      if(!isFullscreen()) return;
      if(e.clientY <= 6) showTop();
    });
    document.addEventListener('touchstart', function(e){
      if(!isFullscreen()) return;
      var t = e.touches && e.touches[0];
      if(t && t.clientY <= 20) showTop();
    }, {passive:true});
  }

  function isFullscreenLocal(){
    return !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
  }

  function scheduleHide(){
    if(hideTimer) clearTimeout(hideTimer);
    hideTimer = setTimeout(function(){
      if(isFullscreenLocal()){
        document.body.classList.add('pl-top-hidden');
      }
    }, 5000);
  }

  function onFsChange(){
    ensureHotzone();
    if(isFullscreenLocal()){
      scheduleHide();
    } else {
      document.body.classList.remove('pl-top-hidden');
    }
  }

  document.addEventListener('fullscreenchange', onFsChange);
  document.addEventListener('webkitfullscreenchange', onFsChange);

  // If already fullscreen on load
  setTimeout(onFsChange, 400);
})();

try{ plInitTooltips(); }catch(e){}

try{
  document.querySelectorAll('.pl-card-mo a, .pl-card-prod a').forEach(function(el){
    el.removeAttribute('title');
    el.classList.remove('classfortooltip');
  });
}catch(e){}

document.addEventListener('webkitfullscreenchange', function(){ try{ plInitTooltips(); }catch(e){} });
document.addEventListener('fullscreenchange',function(){try{plInitTooltips();}catch(e){}});
document.addEventListener('webkitfullscreenchange',function(){try{plInitTooltips();}catch(e){}});
