(function(){
  function updateClock(){
    var d=new Date();
    var s=d.toLocaleString();
    var el=document.getElementById("plClock");
    if(el) el.textContent=s;
  }
  updateClock();
  setInterval(updateClock, 1000);

  var fsBtn = document.getElementById("plFullscreen");
var fsDenied = false;

function fsSupport(){
  var el = document.getElementById("plBoardPage") || document.documentElement;
  return !!(el.requestFullscreen || el.webkitRequestFullscreen || el.mozRequestFullScreen || el.msRequestFullscreen);
}
function isFullscreen(){
  return !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
}
function setUiModes(){
  var isFs = isFullscreen();
  document.body.classList.toggle("pl-fullscreen", isFs);
  // kiosk stays as-is
}
function updateFsButton(){
  if(!fsBtn) return;
  if(isFullscreen() || document.body.classList.contains("pl-kiosk")) fsBtn.textContent = "Exit";
  else fsBtn.textContent = (fsSupport() && !fsDenied) ? "Fullscreen" : "Kiosk";
}

if(fsBtn){
  updateFsButton();

  fsBtn.addEventListener("click", function(){
    // Prefer real Fullscreen; fallback to kiosk if blocked or unsupported
    if(fsSupport() && !fsDenied){
      var el = document.getElementById("plBoardPage") || document.documentElement;
      if(!isFullscreen()){
        var req = el.requestFullscreen || el.webkitRequestFullscreen || el.mozRequestFullScreen || el.msRequestFullscreen;
        try{
          var ret = req && req.call(el);
          if(ret && typeof ret.then === "function"){
            ret.catch(function(){
              fsDenied = true;
              document.body.classList.add("pl-kiosk");
              updateFsButton();
            });
          }
        }catch(e){
          fsDenied = true;
          document.body.classList.add("pl-kiosk");
        }
      } else {
        var exit = document.exitFullscreen || document.webkitExitFullscreen || document.mozCancelFullScreen || document.msExitFullscreen;
        try{ exit && exit.call(document); }catch(e){}
      }
    } else {
      document.body.classList.toggle("pl-kiosk");
    }
    setTimeout(function(){ setUiModes(); updateFsButton(); }, 200);
  });

  document.addEventListener("fullscreenchange", function(){ setUiModes(); updateFsButton(); });
  document.addEventListener("webkitfullscreenchange", function(){ setUiModes(); updateFsButton(); });
}

var refresh = '.((int)$autorefresh).';
var countdownEl = document.getElementById("plRefreshCountdown");
var refreshTimer = null;
var tickTimer = null;

function doAjaxRefresh(){
  try{
    var url = new URL(window.location.href);
    url.searchParams.set("ajax","1");
    // remove any fragment
    url.hash = "";
    fetch(url.toString(), {cache:"no-store", credentials:"same-origin"})
      .then(function(r){
        if(!r.ok) throw new Error("HTTP "+r.status);
        return r.json();
      })
      .then(function(data){
        if(data && data.html){
          var grid = document.getElementById("plBoardGrid");
          if(grid){
            grid.outerHTML = data.html;
          }
          // Re-init tooltips for new DOM
          if (window.jQuery && jQuery.fn && jQuery.fn.tooltip) {
            jQuery(".classfortooltip").tooltip({ position: { my: "left top+15", at: "left bottom", collision: "flipfit" } });
          }
        }
        var clk = document.getElementById("plClock");
        if(clk && data && data.clock) clk.textContent = data.clock;
      })
      .catch(function(err){
        // show small hint in console for debugging
        try{ console.warn("Planning Board refresh failed", err); }catch(e){}
      });
  }catch(e){
    try{ console.warn("Planning Board refresh exception", e); }catch(ex){}
  }
}

function startCountdown(){
  if(!(refresh > 0)) return;
  var remaining = refresh;
  if(countdownEl) countdownEl.textContent = remaining;
  if(tickTimer) clearInterval(tickTimer);
  tickTimer = setInterval(function(){
    remaining -= 1;
    if(remaining <= 0){
      remaining = refresh;
      doAjaxRefresh();
    }
    if(countdownEl) countdownEl.textContent = remaining;
  }, 1000);
}

if(refresh > 0){
  startCountdown();
}
})();