let refreshInterval = 60;
let countdown = refreshInterval;

function fetchBoard() {
  fetch('board_data.php?ts=' + Date.now())
    .then(r => r.json())
    .then(j => {
      document.getElementById('lastUpdate').innerText = 'Last update: ' + j.generated_at;
      countdown = refreshInterval;
    })
    .catch(() => {
      document.getElementById('lastUpdate').innerText = 'Last update: ERROR';
    });
}

setInterval(() => {
  countdown--;
  document.getElementById('countdown').innerText = 'Refresh in ' + countdown + 's';
  if (countdown <= 0) fetchBoard();
}, 1000);

document.getElementById('btnFullscreen').onclick = () => {
  if (!document.fullscreenElement) document.documentElement.requestFullscreen();
};

fetchBoard();
