<?php
require '../../main.inc.php';

require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';

if (empty($user->rights->planning->read)) accessforbidden();

$langs->loadLangs(array("main", "mrp"));

$action = GETPOST('action', 'aZ09');
$stationFilter = trim(GETPOST('station', 'alphanohtml'));
$statusFilter  = GETPOST('status', 'int'); // opcjonalnie

// TV / shop-floor mode (fullscreen + auto refresh)
$tvMode      = (int) GETPOST('tv', 'int');
$autoRefresh = (int) GETPOST('refresh', 'int');
if (empty($autoRefresh)) $autoRefresh = ($tvMode ? 60 : 0); // seconds

// Status labels (Option C)
$statusMap = array(
    0 => array('label' => 'Draft',         'class' => 'pl-status-draft'),
    1 => array('label' => 'Released',      'class' => 'pl-status-released'),
    2 => array('label' => 'In production', 'class' => 'pl-status-inprod'),
    3 => array('label' => 'Finished',      'class' => 'pl-status-finished'),
);

/**
 * Check if a column exists (safe optional fields).
 */
function pl_column_exists($db, $table, $column)
{
    $sql = "SELECT 1 FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = '".$db->escape($table)."' AND COLUMN_NAME = '".$db->escape($column)."'";
    $res = $db->query($sql);
    if (!$res) return false;
    return ($db->num_rows($res) > 0);
}

/**
 * Try to resolve workstation labels for numeric IDs.
 * Falls back to the raw value if no dictionary exists.
 */
function pl_load_workstations($db)
{
    $candidates = array(
        array('table' => MAIN_DB_PREFIX.'workstation',     'id' => 'rowid', 'ref' => 'ref',  'label' => 'label'),
        array('table' => MAIN_DB_PREFIX.'workstation',     'id' => 'rowid', 'ref' => 'ref',  'label' => 'name'),
        array('table' => MAIN_DB_PREFIX.'mrp_workstation', 'id' => 'rowid', 'ref' => 'ref',  'label' => 'label'),
        array('table' => MAIN_DB_PREFIX.'mrp_workstation', 'id' => 'rowid', 'ref' => 'ref',  'label' => 'name'),
    );

    foreach ($candidates as $cand) {
        $table = $cand['table'];
        // quick existence check
        $res = $db->query("SHOW TABLES LIKE '".$db->escape($table)."'");
        if (!$res || $db->num_rows($res) == 0) continue;

        // verify columns
        if (!pl_column_exists($db, $table, $cand['id'])) continue;
        if (!pl_column_exists($db, $table, $cand['ref'])) continue;
        if (!pl_column_exists($db, $table, $cand['label'])) continue;

        $sql = "SELECT ".$cand['id']." as id, ".$cand['ref']." as ref, ".$cand['label']." as label FROM ".$table."";
        $r = $db->query($sql);
        if (!$r) continue;
        $map = array();
        while ($o = $db->fetch_object($r)) {
            $full = trim((string) $o->ref);
            $lab  = trim((string) $o->label);
            if ($lab !== '') $full = ($full !== '' ? ($full.' - '.$lab) : $lab);
            $map[(string) $o->id] = $full;
        }
        if (!empty($map)) return $map;
    }

    return array();
}

$pagetitle = "Planning";
llxHeader('', $pagetitle);

// Load module CSS/JS
$cssUrl = dol_buildpath('/custom/planning/css/planning.css', 1);
$jsUrl  = dol_buildpath('/custom/planning/js/planning.js', 1);
print '<link rel="stylesheet" type="text/css" href="'.dol_escape_htmltag($cssUrl).'">';
print '<script src="'.dol_escape_htmltag($jsUrl).'"></script>';

if ($tvMode) {
    // Add a class on <html> so we can hide menus in CSS
    print "<script>document.documentElement.classList.add('pl-tv');</script>";
    if ($autoRefresh > 0) {
        print "<script>window.setTimeout(function(){ window.location.reload(); }, ".((int)$autoRefresh*1000).");</script>";
    }
}

// ---- Pobranie danych (MO + extrafields + product)
global $db, $conf;

$moTable = MAIN_DB_PREFIX."mrp_mo";
$efTable = MAIN_DB_PREFIX."mrp_mo_extrafields";

// Optional fields (vary by Dolibarr versions/config)
$hasStartMade = pl_column_exists($db, $moTable, 'date_start_made');
$hasEndMade   = pl_column_exists($db, $moTable, 'date_end_made');

$qtyDoneField = '';
foreach (array('qty_made', 'qty_produced', 'qty_done', 'qtyreal') as $cand) {
    if (pl_column_exists($db, $moTable, $cand)) { $qtyDoneField = $cand; break; }
}

$select = array(
    'mo.rowid',
    'mo.ref',
    'mo.status',
    'mo.qty',
    'mo.fk_product',
    'mo.date_start_planned',
    'mo.date_end_planned',
    'p.ref as prod_ref',
    'p.label as prod_label',
    'ef.job_number',
    'ef.working_station'
);
if ($hasStartMade) $select[] = 'mo.date_start_made';
if ($hasEndMade)   $select[] = 'mo.date_end_made';
if ($qtyDoneField) $select[] = 'mo.'.$qtyDoneField.' as qty_done';

$sql = "SELECT\n            ".implode(",\n            ", $select)."\n        FROM ".$moTable." as mo
        LEFT JOIN ".$efTable." as ef ON ef.fk_object = mo.rowid
        LEFT JOIN ".MAIN_DB_PREFIX."product as p ON p.rowid = mo.fk_product
        WHERE mo.entity IN (".getEntity('mrp_mo').") ";

if ($stationFilter !== '') {
    $sql .= " AND ef.working_station = '".$db->escape($stationFilter)."' ";
}
if (!empty($statusFilter)) {
    $sql .= " AND mo.status = ".((int) $statusFilter)." ";
}

// sensowne sortowanie do “planning”
$sql .= " ORDER BY ef.working_station ASC, ef.job_number ASC, mo.date_start_planned ASC ";

$res = $db->query($sql);
if (!$res) {
    print '<div class="error">'.$db->lasterror().'</div>';
    llxFooter();
    exit;
}

// ---- Grupowanie po working_station
$stations = array();
$workstationMap = pl_load_workstations($db); // id -> "REF - Label"

while ($obj = $db->fetch_object($res)) {
    $stationRaw = trim((string) $obj->working_station);
    if ($stationRaw === '') $stationRaw = '(no working_station)';

    // Resolve full workstation label if the value looks like an ID
    $stationLabel = $stationRaw;
    if (ctype_digit($stationRaw) && isset($workstationMap[$stationRaw])) {
        $stationLabel = $workstationMap[$stationRaw];
    }

    if (!isset($stations[$stationRaw])) {
        $stations[$stationRaw] = array(
            'label' => $stationLabel,
            'jobs'  => array(),
        );
    }

    // Dates: prefer actual (made) if available, fallback to planned
    $startMade = ($hasStartMade && isset($obj->date_start_made)) ? $obj->date_start_made : '';
    $endMade   = ($hasEndMade && isset($obj->date_end_made))     ? $obj->date_end_made   : '';

    $start = $startMade ? $startMade : $obj->date_start_planned;
    $end   = $endMade   ? $endMade   : $obj->date_end_planned;

    $qtyDone = (isset($obj->qty_done) ? $obj->qty_done : null);

    $stations[$stationRaw]['jobs'][] = array(
        'rowid'      => (int) $obj->rowid,
        'ref'        => $obj->ref,
        'status'     => (int) $obj->status,
        'qty'        => $obj->qty,
        'qty_done'   => $qtyDone,
        'job_number' => $obj->job_number,
        'prod_ref'   => $obj->prod_ref,
        'prod_label' => $obj->prod_label,
        'start'      => $start,
        'end'        => $end,
        'start_planned' => $obj->date_start_planned,
        'end_planned'   => $obj->date_end_planned,
    );
}

// ---- Filtry (proste)
print '<div class="fichecenter">';
print '<form method="GET" action="'.dol_escape_htmltag($_SERVER["PHP_SELF"]).'">';
print '<div class="inline-block" style="margin-right:10px;">';
print '<label>Working station</label> ';
print '<input type="text" name="station" value="'.dol_escape_htmltag($stationFilter).'" class="minwidth200" />';
print '</div>';

print '<div class="inline-block" style="margin-right:10px;">';
print '<label>Status</label> ';
print '<input type="number" name="status" value="'.dol_escape_htmltag((string)$statusFilter).'" class="width75" />';
print '</div>';

// Preserve TV params
if ($tvMode) {
    print '<input type="hidden" name="tv" value="1">';
    print '<input type="hidden" name="refresh" value="'.((int)$autoRefresh).'">';
}

print '<button class="butAction" type="submit">Filter</button>';

// TV mode toggle
$baseUrl = dol_escape_htmltag($_SERVER["PHP_SELF"]);
$qs = array();
if ($stationFilter !== '') $qs[] = 'station='.urlencode($stationFilter);
if (!empty($statusFilter))  $qs[] = 'status='.urlencode((string)$statusFilter);

if ($tvMode) {
    $toggleUrl = $baseUrl.(!empty($qs) ? '?'.implode('&', $qs) : '');
    print ' <a class="butAction" href="'.$toggleUrl.'">Exit TV</a>';
} else {
    $qs2 = $qs;
    $qs2[] = 'tv=1';
    $qs2[] = 'refresh=60';
    $toggleUrl = $baseUrl.'?'.implode('&', $qs2);
    print ' <a class="butAction" href="'.$toggleUrl.'">TV Mode</a>';
}

if ($tvMode && $autoRefresh > 0) {
    print '<span class="pl-refresh-hint">Auto refresh: '.((int)$autoRefresh).'s</span>';
}
print '</form>';
print '</div>';

print '<div class="clearboth"></div><br>';

// ---- Render grup
foreach ($stations as $stationRaw => $group) {
    $jobs = $group['jobs'];
    $stationTitle = $group['label'];
    print '<div class="fiche">';

    // Nagłówek grupy
    print '<div class="titre">'.$langs->trans("WorkingStation").': '.dol_escape_htmltag($stationTitle).' ('.count($jobs).')</div>';

    print '<div class="div-table-responsive-no-min">';
    print '<table class="liste centpercent pl-table" data-station="'.dol_escape_htmltag($stationRaw).'">';
    print '<tr class="liste_titre">';
    print '<th>Job #</th>';
    print '<th>MO</th>';
    print '<th>Product</th>';
    print '<th class="right">Qty</th>';
    print '<th>Progress</th>';
    print '<th>Start</th>';
    print '<th>End</th>';
    print '<th>Timeline</th>';
    print '<th>Duration</th>';
    print '<th>Status</th>';
    print '</tr>';

    // Station range for simple timeline bars
    $minStart = null;
    $maxEnd = null;
    foreach ($jobs as $j0) {
        if (!empty($j0['start']) && (is_null($minStart) || $j0['start'] < $minStart)) $minStart = $j0['start'];
        if (!empty($j0['end']) && (is_null($maxEnd) || $j0['end'] > $maxEnd)) $maxEnd = $j0['end'];
    }
    $rangeSeconds = 0;
    if (!is_null($minStart) && !is_null($maxEnd)) {
        $rangeSeconds = ((int)$maxEnd) - ((int)$minStart);
        if ($rangeSeconds < 1) $rangeSeconds = 1;
    }

    foreach ($jobs as $j) {
        $moUrl = DOL_URL_ROOT.'/mrp/mo_card.php?id='.$j['rowid'];

        $startTxt = $j['start'] ? dol_print_date($j['start'], 'dayhour') : '';
        $endTxt   = $j['end']   ? dol_print_date($j['end'], 'dayhour')   : '';

        $duration = '';
        if (!empty($j['start']) && !empty($j['end'])) {
            $seconds = ((int)$j['end']) - ((int)$j['start']);
            if ($seconds > 0) $duration = convertSecondToTime($seconds, 'allhourmin');
        }

        // Overdue: planned end is in the past and not finished
        $isOverdue = (!empty($j['end_planned']) && ((int)$j['end_planned'] < dol_now()) && ((int)$j['status'] !== 3));
        $trClass = $isOverdue ? ' class="pl-overdue"' : '';

        print '<tr draggable="true" data-rowid="'.((int)$j['rowid']).'"'.$trClass.'>';
        print '<td>'.dol_escape_htmltag($j['job_number']).'</td>';
        print '<td><a href="'.dol_escape_htmltag($moUrl).'">'.dol_escape_htmltag($j['ref']).'</a></td>';
        print '<td>';
        print dol_escape_htmltag($j['prod_ref']);
        if (!empty($j['prod_label'])) print ' - '.dol_escape_htmltag($j['prod_label']);
        print '</td>';
        print '<td class="right">'.dol_escape_htmltag((string)$j['qty']).'</td>';

        // Progress (optional)
        $progressHtml = '';
        if (!is_null($j['qty_done']) && $j['qty'] > 0) {
            $pct = max(0, min(100, (int) round(((float)$j['qty_done'] / (float)$j['qty']) * 100)));
            $progressHtml = '<div class="pl-progress" title="'.dol_escape_htmltag($j['qty_done'].' / '.$j['qty']).'">'
                .'<div class="pl-progress-bar" style="width:'.$pct.'%"></div>'
                .'<span class="pl-progress-text">'.$pct.'%</span>'
                .'</div>';
        } else {
            $progressHtml = '<span class="opacitymedium">-</span>';
        }
        print '<td class="pl-progress-cell">'.$progressHtml.'</td>';

        print '<td>'.$startTxt.'</td>';
        print '<td>'.$endTxt.'</td>';

        // Timeline bar (simple station-relative)
        $barHtml = '<span class="opacitymedium">-</span>';
        if ($rangeSeconds > 0 && !empty($j['start']) && !empty($j['end'])) {
            $leftPct = (int) round((((int)$j['start'] - (int)$minStart) / (float)$rangeSeconds) * 100);
            $widthPct = (int) round((((int)$j['end'] - (int)$j['start']) / (float)$rangeSeconds) * 100);
            $leftPct = max(0, min(100, $leftPct));
            $widthPct = max(1, min(100, $widthPct));
            $barHtml = '<div class="pl-timeline" title="'.dol_escape_htmltag($startTxt.' → '.$endTxt).'">'
                .'<div class="pl-timeline-bar" style="left:'.$leftPct.'%;width:'.$widthPct.'%"></div>'
                .'</div>';
        }
        print '<td class="pl-timeline-cell">'.$barHtml.'</td>';

        print '<td>'.$duration.'</td>';

        // Status label + color badge
        $st = (int) $j['status'];
        if (isset($statusMap[$st])) {
            $stLabel = $statusMap[$st]['label'];
            $stClass = $statusMap[$st]['class'];
        } else {
            $stLabel = 'Unknown ('.$st.')';
            $stClass = 'pl-status-unknown';
        }
        $badge = '<span class="pl-status-badge '.dol_escape_htmltag($stClass).'">'.dol_escape_htmltag($stLabel).'</span>';
        if ($isOverdue) $badge .= ' <span class="pl-overdue-badge">OVERDUE</span>';

        print '<td class="nowrap">'.$badge.'</td>';
        print '</tr>';
    }

    print '</table>';
    print '</div>';

    print '</div><br>';
}

llxFooter();
