(function(){
  function qs(sel, root){ return (root||document).querySelector(sel); }
  function qsa(sel, root){ return Array.prototype.slice.call((root||document).querySelectorAll(sel)); }

  function storageKey(station){ return 'planningOrder__' + station; }

  function applySavedOrder(table){
    var station = table.getAttribute('data-station') || '';
    if (!station) return;
    var key = storageKey(station);
    var raw = localStorage.getItem(key);
    if (!raw) return;
    var order;
    try { order = JSON.parse(raw); } catch(e){ return; }
    if (!Array.isArray(order) || order.length === 0) return;

    var rows = qsa('tr[draggable="true"]', table);
    var byId = {};
    rows.forEach(function(r){ byId[r.getAttribute('data-rowid')] = r; });

    // Build new order, keep any unknown rows at the end
    var frag = document.createDocumentFragment();
    order.forEach(function(id){ if (byId[id]) frag.appendChild(byId[id]); });
    rows.forEach(function(r){ if (!order.includes(r.getAttribute('data-rowid'))) frag.appendChild(r); });

    // Insert after header row
    var header = qs('tr.liste_titre', table);
    if (header && header.parentNode) {
      header.parentNode.appendChild(frag);
    }
  }

  function enableDnD(table){
    var station = table.getAttribute('data-station') || '';
    if (!station) return;
    var key = storageKey(station);

    var dragged = null;

    function saveOrder(){
      var ids = qsa('tr[draggable="true"]', table).map(function(r){ return r.getAttribute('data-rowid'); });
      localStorage.setItem(key, JSON.stringify(ids));
    }

    qsa('tr[draggable="true"]', table).forEach(function(row){
      row.addEventListener('dragstart', function(ev){
        dragged = row;
        row.classList.add('pl-dragging');
        try { ev.dataTransfer.setData('text/plain', row.getAttribute('data-rowid') || ''); } catch(e){}
        ev.dataTransfer.effectAllowed = 'move';
      });
      row.addEventListener('dragend', function(){
        row.classList.remove('pl-dragging');
        dragged = null;
        saveOrder();
      });
      row.addEventListener('dragover', function(ev){
        if (!dragged || dragged === row) return;
        ev.preventDefault();
        ev.dataTransfer.dropEffect = 'move';
      });
      row.addEventListener('drop', function(ev){
        if (!dragged || dragged === row) return;
        ev.preventDefault();
        var rect = row.getBoundingClientRect();
        var after = (ev.clientY - rect.top) > (rect.height / 2);
        if (after) {
          row.parentNode.insertBefore(dragged, row.nextSibling);
        } else {
          row.parentNode.insertBefore(dragged, row);
        }
      });
    });

    // Restore saved order on load
    applySavedOrder(table);
  }

  function addFullscreenButtonIfTv(){
    if (!document.documentElement.classList.contains('pl-tv')) return;
    var btn = document.createElement('a');
    btn.href = '#';
    btn.className = 'pl-fs-btn';
    btn.textContent = 'Fullscreen';
    btn.addEventListener('click', function(e){
      e.preventDefault();
      var el = document.documentElement;
      var req = el.requestFullscreen || el.webkitRequestFullscreen || el.mozRequestFullScreen || el.msRequestFullscreen;
      if (req) req.call(el);
    });
    document.body.appendChild(btn);
  }

  function init(){
    qsa('table.pl-table').forEach(function(t){
      enableDnD(t);
    });
    addFullscreenButtonIfTv();
  }

  if (document.readyState === 'loading') document.addEventListener('DOMContentLoaded', init);
  else init();
})();
